/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.text.templator.ui;

import ch.elexis.core.text.ITextPlugin;
import ch.elexis.core.text.ReplaceCallback;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.text.templator.model.ODFDoc;
import ch.elexis.ungrad.text.templator.ui.OdfTemplateFieldsDisplay;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class OdfTextPlugin
implements ch.elexis.core.text.ITextPlugin,
ITextPlugin {
    private ODFDoc doc = new ODFDoc();
    private OdfTemplateFieldsDisplay display;
    private ITextPlugin.ICallback saveHandler;

    public Composite createContainer(Composite parent, ITextPlugin.ICallback handler) {
        this.display = new OdfTemplateFieldsDisplay(parent, handler);
        this.saveHandler = handler;
        return this.display;
    }

    public boolean createEmptyDocument() {
        this.doc.clear();
        this.display.set(this.doc);
        return true;
    }

    public boolean loadFromByteArray(byte[] bs, boolean asTemplate) {
        if (asTemplate) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bs);
            return this.loadFromStream(bais, asTemplate);
        }
        FileDialog fd = new FileDialog(this.display.getShell());
        fd.setFilterPath(this.doc.getDocumentDirectory().getAbsolutePath());
        String result = fd.open();
        if (result != null) {
            System.out.print(result);
            this.doc.editFile(result);
        }
        this.display.set(this.doc);
        return true;
    }

    public boolean loadFromStream(InputStream is, boolean asTemplate) {
        block4: {
            if (!asTemplate) break block4;
            Map<String, String> fields = this.doc.parseTemplate(is);
            this.display.set(this.doc);
            if (fields != null) {
                return true;
            }
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileTool.copyStreams((InputStream)is, (OutputStream)baos);
            this.display.set(null);
            return this.loadFromByteArray(baos.toByteArray(), false);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)"Fehler beim Lesen", (String)ex.getMessage());
        }
        return false;
    }

    public boolean findOrReplace(String pattern, ReplaceCallback cb) {
        boolean hadMatch = false;
        for (Map.Entry<String, String> e : this.doc.getFields()) {
            String k = e.getKey();
            if (!k.matches(pattern)) continue;
            hadMatch = true;
            this.doc.setField(k, (String)cb.replace(k));
        }
        this.display.set(this.doc);
        return hadMatch;
    }

    public byte[] storeToByteArray() {
        try {
            return this.doc.asByteArray();
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)"Fehler beim Speichern", (String)ex.getMessage());
            return new byte[0];
        }
    }

    public boolean insertTable(String place, int properties, String[][] contents, int[] columnSizes) {
        StringBuffer sbu = new StringBuffer();
        int z = 0;
        while (z < contents.length) {
            int s = 0;
            while (s < contents[z].length) {
                sbu.append(contents[z][s]).append("\t");
                ++s;
            }
            sbu.append("\n");
            ++z;
        }
        String repl = sbu.toString();
        place = "\\[" + ((String)place).substring(1, ((String)place).length() - 1) + "\\]";
        Pattern pat = Pattern.compile((String)place);
        for (Map.Entry<String, String> field : this.doc.getFields()) {
            Matcher matcher = pat.matcher(field.getKey());
            if (!matcher.find()) continue;
            this.doc.setField(field.getKey(), repl);
        }
        return true;
    }

    public Object insertTextAt(int x, int y, int w, int h, String text, int adjust) {
        return null;
    }

    public boolean setFont(String name, int style, float size) {
        return false;
    }

    public boolean setStyle(int style) {
        return false;
    }

    public Object insertText(String marke, String text, int adjust) {
        return null;
    }

    public Object insertText(Object pos, String text, int adjust) {
        return null;
    }

    public boolean clear() {
        return false;
    }

    public String getMimeType() {
        return "application/vnd.oasis.opendocument.text";
    }

    public ITextPlugin.PageFormat getFormat() {
        return ITextPlugin.PageFormat.A4;
    }

    public void setFormat(ITextPlugin.PageFormat f) {
    }

    public void setParameter(ITextPlugin.Parameter parameter) {
    }

    public int findCount(String text) {
        return 0;
    }

    public List<String> findMatching(String pattern) {
        return null;
    }

    public Object getCurrentDocument() {
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public void setFocus() {
    }

    public void dispose() {
    }

    public void showMenu(boolean b) {
    }

    public void showToolbar(boolean b) {
    }

    public void setSaveOnFocusLost(boolean bSave) {
    }

    public boolean print(String toPrinter, String toTray, boolean waitUntilFinished) {
        return false;
    }

    public boolean isDirectOutput() {
        return false;
    }

    public void initTemplatePrintSettings(String template) {
        this.doc.setTitle(template);
    }
}

