/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.text.templator.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.text.templator.model.ODFDoc;
import ch.rgw.tools.ExHandler;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OdfTemplateFieldsDisplay
extends Composite {
    private IAction printAction;
    private ITextPlugin.ICallback saveHandler;
    private Composite cFields;
    private ODFDoc doc;

    public OdfTemplateFieldsDisplay(Composite parent, ITextPlugin.ICallback handler) {
        super(parent, 0);
        this.saveHandler = handler;
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        }
        this.setLayout((Layout)new FillLayout());
        Composite body = new Composite((Composite)this, 0);
        body.setLayout((Layout)new GridLayout());
        this.makeActions();
        ToolBarManager tbm = new ToolBarManager(256);
        tbm.add(this.printAction);
        tbm.createControl(body);
        this.cFields = new Composite(body, 0);
        this.cFields.setLayout((Layout)new GridLayout(2, false));
        this.cFields.setLayoutData((Object)SWTHelper.getFillGridData());
    }

    public void set(ODFDoc doc) {
        Control[] controlArray = this.cFields.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (doc.getFields().size() == 0) {
            Label lbl = new Label(this.cFields, 0);
            lbl.setText("Externes Dokument");
            lbl.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        } else {
            for (Map.Entry<String, String> e : doc.getFields()) {
                Label lbl = new Label(this.cFields, 0);
                lbl.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                Text text = new Text(this.cFields, 2048);
                text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
                lbl.setText(e.getKey());
                text.setText(e.getValue());
                text.setData("field", (Object)e.getKey());
            }
        }
        this.cFields.layout();
        this.doc = doc;
        if (CoreHub.localCfg.get("briefe/ungrad-templator/direct_output", false)) {
            this.printAction.run();
        }
    }

    private void makeActions() {
        this.printAction = new Action("Ausgeben"){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                this.setToolTipText("Gibt dieses Dokument mit dem konfigurierten Ausgabeprogramm aus");
            }

            public void run() {
                try {
                    OdfTemplateFieldsDisplay.this.doc.doOutput();
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                    SWTHelper.showError((String)"Fehler bei Ausgabe", (String)(e.getMessage() == null ? e.getClass().toString() : e.getMessage()));
                }
            }
        };
    }
}

