/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.text.templator.model;

import ch.elexis.ungrad.text.templator.model.ODFDoc;
import ch.rgw.tools.StringTool;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OdfTemplateFilterStream
extends FilterOutputStream {
    private StringBuilder sb;
    private static final int AWAIT_START = 0;
    private static final int AWAIT_END = 1;
    private int state = 0;
    private ODFDoc doc;

    public OdfTemplateFilterStream(ODFDoc doc, OutputStream out) {
        super(out);
        this.doc = doc;
    }

    @Override
    public void flush() throws IOException {
        if (this.sb != null) {
            int i = 0;
            while (i < this.sb.length()) {
                super.write(this.sb.charAt(i));
                ++i;
            }
            this.sb = null;
            this.state = 0;
        }
        super.flush();
    }

    @Override
    public void write(int b) throws IOException {
        switch (this.state) {
            case 0: {
                if (b == 91) {
                    this.sb = new StringBuilder("[");
                    this.state = 1;
                    break;
                }
                super.write(b);
                break;
            }
            case 1: {
                this.sb.append((char)b);
                if (b != 93) break;
                String field = this.sb.toString();
                String val = this.doc.getField(field);
                if (StringTool.isNothing((Object)val)) {
                    this.flush();
                } else {
                    String conv = this.convert(val);
                    byte[] byArray = conv.getBytes();
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte c = byArray[n2];
                        super.write(c);
                        ++n2;
                    }
                }
                this.sb = null;
                this.state = 0;
            }
        }
    }

    private String convert(String input) {
        String ret = input.replaceAll("\\t", "<text:tab/>");
        ret = ret.replaceAll("\\n", "<text:line-break/>");
        return ret;
    }
}

