/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.views;

import ch.elexis.ungrad.tardoc.Messages;
import ch.elexis.ungrad.tardoc.views.TardocKonsView;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TimerComposite
extends Composite {
    TardocKonsView tkv;
    private Label timerLabel;
    private Button startPauseButton;
    private Button resetButton;
    private Image playIcon;
    private Image pauseIcon;
    private Image stopIcon;

    public TimerComposite(Composite parent, TardocKonsView view) {
        super(parent, 0);
        this.tkv = view;
        this.loadIcons();
        GridLayout timerLayout = new GridLayout(3, false);
        timerLayout.marginWidth = 0;
        timerLayout.marginHeight = 0;
        timerLayout.horizontalSpacing = 3;
        this.setLayout((Layout)timerLayout);
        this.setLayoutData(new GridData(131072, 0x1000000, false, false));
        this.timerLabel = new Label((Composite)this, 0);
        this.timerLabel.setText("00:00");
        GridData gdTimer = new GridData(131072, 0x1000000, false, false);
        gdTimer.widthHint = 50;
        this.timerLabel.setLayoutData((Object)gdTimer);
        this.startPauseButton = new Button((Composite)this, 8);
        this.startPauseButton.setImage(this.playIcon);
        this.startPauseButton.setToolTipText(Messages.TimerComposite_StartTimer_Tooltip);
        GridData gdStartPause = new GridData(0x1000000, 0x1000000, false, false);
        gdStartPause.widthHint = 24;
        gdStartPause.heightHint = 24;
        this.startPauseButton.setLayoutData((Object)gdStartPause);
        this.startPauseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimerComposite.this.toggleTimer();
            }
        });
        this.resetButton = new Button((Composite)this, 8);
        this.resetButton.setImage(this.stopIcon);
        this.resetButton.setToolTipText(Messages.TimerComposite_ResetTimer_Tooltip);
        GridData gdReset = new GridData(0x1000000, 0x1000000, false, false);
        gdReset.widthHint = 24;
        gdReset.heightHint = 24;
        this.resetButton.setLayoutData((Object)gdReset);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimerComposite.this.resetTimer();
            }
        });
        this.tkv.encounterTimer.addTimerListener(newTime -> this.getDisplay().asyncExec(() -> this.updateDisplay(newTime)));
    }

    private void loadIcons() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        ImageDescriptor playDesc = ImageDescriptor.createFromURL((URL)bundle.getEntry("icons/media-play-2x.png"));
        this.playIcon = playDesc.createImage();
        ImageDescriptor pauseDesc = ImageDescriptor.createFromURL((URL)bundle.getEntry("icons/media-pause-2x.png"));
        this.pauseIcon = pauseDesc.createImage();
        ImageDescriptor stopDesc = ImageDescriptor.createFromURL((URL)bundle.getEntry("icons/media-stop-2x.png"));
        this.stopIcon = stopDesc.createImage();
    }

    private void toggleTimer() {
        if (!this.tkv.encounterTimer.isRunning()) {
            this.tkv.encounterTimer.resume();
            this.startPauseButton.setImage(this.pauseIcon);
            this.startPauseButton.setToolTipText(Messages.TimerComposite_PauseTimer_Tooltip);
        } else {
            this.tkv.encounterTimer.pause();
            this.startPauseButton.setImage(this.playIcon);
            this.startPauseButton.setToolTipText(Messages.TimerComposite_StartTimer_Tooltip);
        }
    }

    private void resetTimer() {
        this.startPauseButton.setImage(this.playIcon);
        this.startPauseButton.setToolTipText(Messages.TimerComposite_StartTimer_Tooltip);
        this.tkv.encounterTimer.stop();
        this.updateDisplay(0L);
    }

    public void updateDisplay(long elapsedSeconds) {
        long minutes = elapsedSeconds / 60L;
        long seconds = elapsedSeconds % 60L;
        String timeString = String.format("%02d:%02d", minutes, seconds);
        if (this.timerLabel != null && !this.timerLabel.isDisposed()) {
            this.timerLabel.setText(timeString);
        }
        if (this.tkv.encounterTimer.isRunning()) {
            this.tkv.billingsManager.autobill(minutes);
            this.startPauseButton.setImage(this.pauseIcon);
            this.startPauseButton.setToolTipText(Messages.TimerComposite_PauseTimer_Tooltip);
        } else {
            this.startPauseButton.setImage(this.playIcon);
            this.startPauseButton.setToolTipText(Messages.TimerComposite_StartTimer_Tooltip);
        }
    }

    public void dispose() {
        this.tkv.encounterTimer.stop();
        if (this.playIcon != null && !this.playIcon.isDisposed()) {
            this.playIcon.dispose();
        }
        if (this.pauseIcon != null && !this.pauseIcon.isDisposed()) {
            this.pauseIcon.dispose();
        }
        if (this.stopIcon != null && !this.stopIcon.isDisposed()) {
            this.stopIcon.dispose();
        }
        super.dispose();
    }
}

