/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.views;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.Extensions;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.text.EnhancedTextField;
import ch.elexis.core.ui.text.IRichTextDisplay;
import ch.elexis.core.ui.util.IKonsExtension;
import ch.elexis.ungrad.tardoc.Messages;
import ch.elexis.ungrad.tardoc.services.BillingsManager;
import ch.elexis.ungrad.tardoc.services.EncounterTimer;
import ch.elexis.ungrad.tardoc.services.TardocManager;
import ch.elexis.ungrad.tardoc.views.AdditionsComposite;
import ch.elexis.ungrad.tardoc.views.CasesComposite;
import ch.elexis.ungrad.tardoc.views.DetailsComposite;
import ch.elexis.ungrad.tardoc.views.TimerComposite;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import jakarta.inject.Inject;
import java.time.LocalDate;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.LoggerFactory;

public class TardocKonsView
extends ViewPart {
    public static final String ID = "ch.elexis.ungrad.tardoc.views.TardocKonsView";
    Hashtable<String, IKonsExtension> hXrefs;
    private DetailsComposite cDesc;
    public TimerComposite timerComposite;
    public EncounterTimer encounterTimer = new EncounterTimer();
    CasesComposite casesComposite;
    protected IEncounter actEncounter;
    EnhancedTextField etf;
    BillingsManager billingsManager = new BillingsManager(this);
    IPatient actPat;
    private boolean created = false;
    private AdditionsComposite additionsComposite;
    private SashForm sashForm;
    private boolean additionsVisible = true;
    private Action toggleAdditionsAction;
    private Action toggleViewAction;
    private IMemento memento;
    private static final int[] DEFAULT_WEIGHTS = new int[]{60, 40};
    private IPartListener2 udpateOnVisible = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            if (TardocKonsView.this.actEncounter != null && TardocKonsView.this.etf != null && !TardocKonsView.this.etf.isDisposed() && !TardocKonsView.this.etf.isDirty()) {
                TardocKonsView.this.setKonsText(TardocKonsView.this.actEncounter, TardocKonsView.this.actEncounter.getVersionedEntry().getHeadVersion());
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
            if (TardocKonsView.this.actEncounter != null && TardocKonsView.this.etf.isDirty()) {
                EncounterServiceHolder.get().updateVersionedEntry(TardocKonsView.this.actEncounter, TardocKonsView.this.etf.getContentsAsXML(), TardocKonsView.this.getVersionRemark());
                TardocKonsView.this.etf.setDirty(false);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)TardocKonsView.this.actEncounter);
            }
        }
    };

    @org.eclipse.e4.core.di.annotations.Optional
    @Inject
    void udpatePatient(@UIEventTopic(value="info/elexis/model/update") IPatient patient) {
        if (patient != null && patient.equals(this.actPat) && this.created) {
            this.actPat = null;
            this.setPatient(patient);
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void reloadPatient(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (IPatient.class.equals(clazz) && this.created) {
            this.actPat = null;
            this.setPatient(this.actPat);
        }
    }

    @Inject
    void activePatient(@org.eclipse.e4.core.di.annotations.Optional IPatient patient) {
        if (this.created) {
            Display.getDefault().asyncExec(() -> {
                this.actPat = null;
                this.setPatient(patient);
            });
        }
    }

    @Inject
    void activeUser(@org.eclipse.e4.core.di.annotations.Optional IUser user) {
        if (this.created) {
            Display.getDefault().asyncExec(() -> {});
        }
    }

    @Inject
    @org.eclipse.e4.core.di.annotations.Optional
    public void reloadCoverage(@UIEventTopic(value="info/elexis/model/reload") Class<?> clazz) {
        if (ICoverage.class.equals(clazz) && this.created) {
            this.updateFallCombo();
        }
    }

    @Inject
    void updateCoverage(@org.eclipse.e4.core.di.annotations.Optional @UIEventTopic(value="info/elexis/model/update") ICoverage coverage) {
        if (this.created && this.casesComposite != null && !this.casesComposite.isDisposed()) {
            this.updateFallCombo();
        }
    }

    private String getVersionRemark() {
        String remark = "edit";
        Optional activeUser = ContextServiceHolder.get().getRootContext().getTyped(IUser.class);
        if (activeUser.isPresent()) {
            remark = ((IUser)activeUser.get()).getLabel();
        }
        return remark;
    }

    private synchronized void setPatient(IPatient pat) {
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("[KONS PAT] " + (pat != null ? pat.getId() : "null"));
        this.actPat = pat;
        if (pat != null) {
            this.updateFallCombo();
        }
    }

    private void updateFallCombo() {
        this.casesComposite.refreshCases(this.actEncounter);
    }

    @Inject
    void selectedEncounter(@org.eclipse.e4.core.di.annotations.Optional IEncounter encounter) {
        if (this.created) {
            Display.getDefault().asyncExec(() -> {
                if (encounter != null) {
                    this.setKons(encounter);
                } else {
                    this.setKons(null);
                }
            });
        }
    }

    private synchronized void setKons(IEncounter encounter) {
        LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("[KONS] " + (encounter != null ? encounter.getId() : "null"));
        if (this.actEncounter != null && this.etf.isDirty()) {
            EncounterServiceHolder.get().updateVersionedEntry(this.actEncounter, this.etf.getContentsAsXML(), this.getVersionRemark());
            this.etf.setDirty(false);
        }
        this.cDesc.setEncounter(encounter);
        if (encounter != null) {
            ICoverage coverage = encounter.getCoverage();
            this.setKonsText(encounter, encounter.getVersionedEntry().getHeadVersion());
            this.casesComposite.setEncounter(coverage);
            if (encounter.getDate().isEqual(LocalDate.now())) {
                this.etf.setTextBackground(UiDesk.getColor((String)"weiss"));
            } else {
                this.etf.setTextBackground(UiDesk.getColor((String)"weiss"));
            }
            this.billingsManager.setEncounter(encounter);
            if (this.additionsComposite != null && !this.additionsComposite.isDisposed()) {
                this.additionsComposite.getBillingPositionsComposite().setKons(encounter);
                this.additionsComposite.getDiagnosesComposite().setKons(encounter);
            }
            this.encounterTimer.stop();
            this.etf.setEnabled(true);
        } else {
            this.etf.setText("");
            this.etf.setEnabled(false);
        }
        this.actEncounter = encounter;
        this.cDesc.layout();
    }

    void setKonsText(IEncounter encounter, int version) {
        String ntext = "";
        if (version >= 0 && version <= encounter.getVersionedEntry().getHeadVersion()) {
            VersionedResource vr = encounter.getVersionedEntry();
            VersionedResource.ResourceItem entry = vr.getVersion(version);
            ntext = entry.data;
            StringBuilder sb = new StringBuilder();
            sb.append("rev. ").append(version).append(ch.elexis.core.ui.views.Messages.KonsDetailView_of).append(new TimeTool(entry.timestamp).toString(0)).append(" (").append(entry.remark).append(")");
        }
        this.etf.setText(ntext);
        this.etf.setKons(encounter);
    }

    public String getText() {
        return this.etf.getContentsPlaintext();
    }

    public void insertTextAtEndOfKons(String text) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        String existing = this.etf.getContentsPlaintext();
        if (LocalLockServiceHolder.get().acquireLock((Object)this.actEncounter).isOk()) {
            this.etf.replace(0, existing.length(), existing + text);
            EncounterServiceHolder.get().updateVersionedEntry(this.actEncounter, new Samdas(this.etf.getContentsAsXML()));
            ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.actEncounter);
            LocalLockServiceHolder.get().releaseLock((Object)this.actEncounter);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        String[] parts;
        String savedWeights;
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite topSection = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(3, false);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        topLayout.horizontalSpacing = 5;
        topSection.setLayout((Layout)topLayout);
        topSection.setLayoutData((Object)new GridData(4, 128, true, false));
        this.cDesc = new DetailsComposite(topSection, this);
        this.casesComposite = new CasesComposite(topSection, this);
        this.casesComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.timerComposite = new TimerComposite(topSection, this);
        this.sashForm = new SashForm(parent, 512);
        this.sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.etf = new EnhancedTextField((Composite)this.sashForm, 2626);
        this.etf.setBackground(Display.getCurrent().getSystemColor(1));
        this.hXrefs = new Hashtable();
        List xrefs = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsExtension", (boolean)false);
        for (IKonsExtension x : xrefs) {
            String provider = x.connect((IRichTextDisplay)this.etf);
            this.hXrefs.put(provider, x);
        }
        this.etf.setXrefHandlers(this.hXrefs);
        List makros = Extensions.getClasses((List)Extensions.getExtensions((String)"ch.elexis.core.ui.KonsExtension"), (String)"KonsMakro", (boolean)false);
        this.etf.setExternalMakros(makros);
        this.additionsComposite = new AdditionsComposite((Composite)this.sashForm, this, this.memento);
        this.getSite().setSelectionProvider((ISelectionProvider)this.additionsComposite.getBillingPositionsComposite().getBillingPositionsViewer());
        int[] weights = DEFAULT_WEIGHTS;
        if (this.memento != null && (savedWeights = this.memento.getString("additions_height")) != null && (parts = savedWeights.split(",")).length == 2) {
            try {
                weights = new int[]{Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim())};
            }
            catch (NumberFormatException numberFormatException) {
                weights = DEFAULT_WEIGHTS;
            }
        }
        this.sashForm.setWeights(weights);
        this.createActions();
        this.contributeToActionBars();
        System.out.println("TardocKonsView: Initializing TardocManager...");
        BundleContext bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        System.out.println("TardocKonsView: BundleContext obtained: " + (bundleContext != null));
        TardocManager manager = TardocManager.getInstance();
        if (manager.isServiceAvailable(bundleContext)) {
            System.out.println("TardocKonsView: Service is available, querying...");
            List<ITardocLeistung> results = manager.getLeistungen("Konsultation", bundleContext);
            System.out.println("TardocManager returned " + results.size() + " results for 'Konsultation'");
            if (results.size() > 0) {
                System.out.println("First result: " + results.get(0).getCode() + " - " + results.get(0).getText());
            }
        } else {
            System.err.println("TardocKonsView: Service is NOT available");
        }
        IViewSite viewSite = this.getViewSite();
        this.etf.connectGlobalActions(viewSite);
        this.created = true;
        ContextServiceHolder.get().getTyped(IEncounter.class).ifPresent(e -> this.selectedEncounter((IEncounter)e));
        this.getSite().getPage().addPartListener(this.udpateOnVisible);
    }

    private void createActions() {
        this.toggleAdditionsAction = new Action("\u00a7", 1){

            public void run() {
                TardocKonsView.this.toggleAdditionsVisibility();
            }
        };
        this.toggleAdditionsAction.setToolTipText(Messages.TardocKonsView_ToggleAdditions_Tooltip);
        this.toggleAdditionsAction.setImageDescriptor(Images.IMG_VIEW_PATIENT_DETAIL.getImageDescriptor());
        this.toggleViewAction = new Action("Dx", 1){

            public void run() {
                TardocKonsView.this.toggleView();
            }
        };
        this.toggleViewAction.setToolTipText(Messages.TardocKonsView_SwitchToDiagnoses_Tooltip);
        this.toggleViewAction.setImageDescriptor(Images.IMG_BILL.getImageDescriptor());
    }

    private void contributeToActionBars() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.toggleAdditionsAction);
        toolBarManager.add((IAction)this.toggleViewAction);
    }

    private void toggleAdditionsVisibility() {
        boolean bl = this.additionsVisible = !this.additionsVisible;
        if (this.additionsVisible) {
            String[] parts;
            String savedWeights;
            int[] weights = DEFAULT_WEIGHTS;
            if (this.memento != null && (savedWeights = this.memento.getString("additions_height")) != null && (parts = savedWeights.split(",")).length == 2) {
                try {
                    weights = new int[]{Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim())};
                }
                catch (NumberFormatException numberFormatException) {
                    weights = DEFAULT_WEIGHTS;
                }
            }
            this.sashForm.setWeights(weights);
            this.sashForm.setMaximizedControl(null);
        } else if (this.sashForm.getChildren().length > 0) {
            this.sashForm.setMaximizedControl(this.sashForm.getChildren()[0]);
        }
        this.sashForm.layout(true, true);
    }

    private void toggleView() {
        if (this.additionsComposite != null && !this.additionsComposite.isDisposed()) {
            this.additionsComposite.toggleView();
            if (this.additionsComposite.isShowingBillingPositions()) {
                this.getSite().setSelectionProvider((ISelectionProvider)this.additionsComposite.getBillingPositionsComposite().getBillingPositionsViewer());
                this.toggleViewAction.setToolTipText(Messages.TardocKonsView_SwitchToDiagnoses_Tooltip);
            } else {
                this.getSite().setSelectionProvider((ISelectionProvider)this.additionsComposite.getDiagnosesComposite().getDiagnosesViewer());
                this.toggleViewAction.setToolTipText(Messages.TardocKonsView_SwitchToBillingPositions_Tooltip);
            }
        }
    }

    public void setFocus() {
        if (this.etf != null && !this.etf.isDisposed()) {
            this.etf.setFocus();
        }
    }

    public void dispose() {
        this.created = false;
        this.encounterTimer.dispose();
        this.getSite().getPage().removePartListener(this.udpateOnVisible);
        super.dispose();
    }

    public void saveState(IMemento memento) {
        int[] w = this.sashForm.getWeights();
        memento.putString("additions_height", Integer.toString(w[0]) + "," + Integer.toString(w[1]));
        if (this.additionsComposite != null && !this.additionsComposite.isDisposed()) {
            this.additionsComposite.saveState(memento);
        }
        super.saveState(memento);
    }
}

