/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.views;

import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.views.DiagnosenDisplay;
import ch.elexis.ungrad.tardoc.Messages;
import ch.elexis.ungrad.tardoc.services.DiagnosesManager;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;

public class DiagnosesComposite
extends Composite {
    private TableViewer diagnosesViewer;
    private Text searchField;
    private Combo codeSystemCombo;
    private DiagnosesManager diagnosesManager;
    private IWorkbenchPage page;
    private IEncounter currentEncounter;
    private DiagnosenDisplay diags;
    private IMemento memento;
    private String[] CODE_SYSTEMS;
    private static final String MEMENTO_CODE_SYSTEM = "selected_code_system";

    @Optional
    @Inject
    public void updateEncounter(@UIEventTopic(value="info/elexis/model/update") IEncounter encounter) {
        if (encounter != null && encounter.equals(this.currentEncounter) && this.diags != null) {
            this.diags.setEncounter(encounter);
        }
    }

    void setKons(IEncounter k) {
        this.currentEncounter = k;
        this.diags.setEncounter(k);
    }

    public DiagnosesComposite(IWorkbenchPage page, Composite parent, int style, IMemento memento) {
        super(parent, style);
        this.page = page;
        this.memento = memento;
        this.CODE_SYSTEMS = new String[]{Messages.DiagnosesComposite_CodeSystem_All, Messages.DiagnosesComposite_CodeSystem_ICD10, Messages.DiagnosesComposite_CodeSystem_TICode};
        this.diagnosesManager = new DiagnosesManager();
        this.createContent();
        this.restoreState();
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.diags = new DiagnosenDisplay(this.page, (Composite)this, 0);
        GridData ddLayoutData = new GridData(4, 4, true, true);
        ddLayoutData.minimumHeight = 100;
        this.diags.setLayoutData((Object)ddLayoutData);
        this.createSearchControls(this);
        this.diagnosesViewer = new TableViewer((Composite)this, 67588);
        GridData viewerGridData = new GridData(4, 4, true, true);
        viewerGridData.minimumHeight = 100;
        this.diagnosesViewer.getTable().setLayoutData((Object)viewerGridData);
        this.diagnosesViewer.getTable().setHeaderVisible(false);
        this.diagnosesViewer.getTable().setLinesVisible(true);
        this.diagnosesViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.diagnosesViewer.setLabelProvider((IBaseLabelProvider)new DiagnosisLabelProvider());
        this.addDragSupport();
        this.addDoubleClickListener();
        this.diagnosesViewer.setInput(Collections.emptyList());
    }

    private void createSearchControls(Composite parent) {
        Composite searchComposite = new Composite(parent, 0);
        searchComposite.setLayout((Layout)new GridLayout(4, false));
        searchComposite.setLayoutData((Object)new GridData(4, 1024, true, false));
        Label codeSystemLabel = new Label(searchComposite, 0);
        codeSystemLabel.setText(Messages.DiagnosesComposite_CodeSystem_Label);
        codeSystemLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.codeSystemCombo = new Combo(searchComposite, 2056);
        this.codeSystemCombo.setItems(this.CODE_SYSTEMS);
        this.codeSystemCombo.select(0);
        this.codeSystemCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.codeSystemCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosesComposite.this.performSearch();
            }
        });
        Label searchLabel = new Label(searchComposite, 0);
        searchLabel.setText(Messages.DiagnosesComposite_Search_Label);
        searchLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.searchField = new Text(searchComposite, 2944);
        this.searchField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchField.setMessage(Messages.DiagnosesComposite_Search_Placeholder);
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DiagnosesComposite.this.performSearch();
            }
        });
    }

    private void performSearch() {
        String searchText = this.searchField.getText().trim();
        if (searchText.isEmpty()) {
            this.diagnosesViewer.setInput(Collections.emptyList());
            return;
        }
        String codeSystem = this.codeSystemCombo.getText();
        try {
            List<IDiagnosis> results = this.diagnosesManager.findDiagnoses(codeSystem, searchText);
            this.diagnosesViewer.setInput(results);
        }
        catch (Exception ex) {
            this.diagnosesViewer.setInput(Collections.emptyList());
            ex.printStackTrace();
        }
    }

    private void addDragSupport() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource dragSource = new DragSource((Control)this.diagnosesViewer.getTable(), operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DiagnosesComposite.this.diagnosesViewer.getSelection();
                if (selection.isEmpty()) {
                    event.data = null;
                    return;
                }
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof IDiagnosis) {
                    IDiagnosis diagnosis = (IDiagnosis)firstElement;
                    String storeToString = StoreToStringServiceHolder.getStoreToString((Object)diagnosis);
                    event.data = storeToString;
                } else {
                    event.data = null;
                }
            }

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)DiagnosesComposite.this.diagnosesViewer.getSelection();
                event.doit = !selection.isEmpty();
            }
        });
    }

    private void addDoubleClickListener() {
        this.diagnosesViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty() || this.currentEncounter == null) {
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IDiagnosis) {
                IDiagnosis diagnosis = (IDiagnosis)firstElement;
                this.currentEncounter.addDiagnosis(diagnosis);
                if (this.diags != null) {
                    this.diags.setEncounter(this.currentEncounter);
                }
                CoreModelServiceHolder.get().save((Identifiable)this.currentEncounter);
            }
        });
    }

    public TableViewer getDiagnosesViewer() {
        return this.diagnosesViewer;
    }

    public void setInput(Object input) {
        if (this.diagnosesViewer != null && !this.diagnosesViewer.getTable().isDisposed()) {
            this.diagnosesViewer.setInput(input);
        }
    }

    public void refresh() {
        if (this.diagnosesViewer != null && !this.diagnosesViewer.getTable().isDisposed()) {
            this.diagnosesViewer.refresh();
        }
    }

    public void saveState(IMemento memento) {
        if (memento != null && this.codeSystemCombo != null && !this.codeSystemCombo.isDisposed()) {
            memento.putString(MEMENTO_CODE_SYSTEM, this.codeSystemCombo.getText());
        }
    }

    private void restoreState() {
        String savedCodeSystem;
        if (this.memento != null && this.codeSystemCombo != null && !this.codeSystemCombo.isDisposed() && (savedCodeSystem = this.memento.getString(MEMENTO_CODE_SYSTEM)) != null) {
            int i = 0;
            while (i < this.CODE_SYSTEMS.length) {
                if (this.CODE_SYSTEMS[i].equals(savedCodeSystem)) {
                    this.codeSystemCombo.select(i);
                    break;
                }
                ++i;
            }
        }
    }

    class DiagnosisLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DiagnosisLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof IDiagnosis) {
                IDiagnosis diagnosis = (IDiagnosis)obj;
                String codeSystem = diagnosis.getCodeSystemName();
                return "[" + codeSystem + "] " + diagnosis.getCode() + " - " + diagnosis.getText();
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

