/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.views;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.ac.EvACEs;
import ch.elexis.core.services.holder.AccessControlServiceHolder;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalActions;
import ch.elexis.core.ui.data.UiMandant;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.ungrad.tardoc.views.TardocKonsView;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DetailsComposite
extends Composite {
    private TardocKonsView tkv;
    private Hyperlink hlMandant;
    private Hyperlink hlDate;
    private FormToolkit tk = UiDesk.getToolkit();

    public DetailsComposite(Composite parent, TardocKonsView view) {
        super(parent, 0);
        this.tkv = view;
        this.setLayout((Layout)new RowLayout(256));
        GridData gdDesc = new GridData(4, 0x1000000, false, false);
        gdDesc.widthHint = 250;
        this.setLayoutData(gdDesc);
        this.hlDate = this.tk.createHyperlink((Composite)this, "---", 0);
        this.hlDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                GlobalActions.redateAction.reflectRight();
                if (GlobalActions.redateAction.isEnabled()) {
                    GlobalActions.redateAction.doRun();
                    DetailsComposite.this.setEncounter(DetailsComposite.this.tkv.actEncounter);
                }
            }
        });
        this.hlMandant = this.tk.createHyperlink((Composite)this, "--", 0);
        this.hlMandant.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Result result;
                IMandator mandator;
                Mandant currentMandant = ElexisEventDispatcher.getSelectedMandator();
                KontaktSelektor ksl = new KontaktSelektor(DetailsComposite.this.tkv.getSite().getShell(), Mandant.class, Messages.Core_Select_Mandator, Messages.KonsDetailView_SelectMandatorBody, new String[]{"Kuerzel", "Bezeichnung1", "Bezeichnung2"});
                ksl.disableContextSelection();
                if (ksl.open() == 0 && (mandator = (IMandator)CoreModelServiceHolder.get().load(((Mandant)ksl.getSelection()).getId(), IMandator.class).orElse(null)) != null && !(result = EncounterServiceHolder.get().transferToMandator(DetailsComposite.this.tkv.actEncounter, mandator, false)).isOK()) {
                    MessageDialog.openError((Shell)DetailsComposite.this.tkv.getSite().getShell(), (String)Messages.Core_Error, (String)result.getCombinedMessages());
                }
                ElexisEventDispatcher.fireSelectionEvent((PersistentObject)currentMandant);
            }
        });
        this.hlMandant.setBackground(parent.getBackground());
    }

    void setEncounter(IEncounter enc) {
        if (this.isDisposed() || this.hlDate == null || this.hlDate.isDisposed() || this.hlMandant == null || this.hlMandant.isDisposed()) {
            return;
        }
        if (enc == null) {
            this.hlDate.setText("---");
            this.hlMandant.setText("---");
        } else {
            IMandator mandator = enc.getMandator();
            String encounterDate = TimeUtil.formatSafe((LocalDate)enc.getDate());
            this.hlDate.setText(encounterDate + " (" + new TimeTool(enc.getDate()).getDurationToNowString() + ")");
            StringBuilder sb = new StringBuilder();
            if (mandator == null) {
                sb.append(Messages.KonsDetailView_NotYours);
                this.hlMandant.setBackground(this.hlMandant.getParent().getBackground());
            } else {
                IContact biller = mandator.getBiller();
                if (biller.getId().equals(mandator.getId())) {
                    sb.append("(").append(mandator.getLabel()).append(")");
                } else {
                    sb.append("(").append(mandator.getLabel()).append("/").append(biller.getLabel()).append(")");
                }
                this.hlMandant.setBackground(UiMandant.getColorForMandator((Mandant)Mandant.load((String)mandator.getId())));
            }
            this.hlMandant.setText(sb.toString());
            boolean hlMandantEnabled = BillingServiceHolder.get().isEditable(enc).isOK() && AccessControlServiceHolder.get().evaluate(EvACEs.KONS_REASSIGN);
            this.hlMandant.setEnabled(hlMandantEnabled);
        }
    }
}

