/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.views;

import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.util.CoverageComparator;
import ch.elexis.core.ui.views.provider.CoverageColorLabelProvider;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CoverageSelectionDialog
extends Dialog {
    private IPatient patient;
    private ICoverage selectedCoverage;
    private ICoverage currentCoverage;
    private TableViewer tableViewer;

    public CoverageSelectionDialog(Shell parentShell, IPatient patient, ICoverage currentCoverage) {
        super(parentShell);
        this.patient = patient;
        this.currentCoverage = currentCoverage;
        this.selectedCoverage = currentCoverage;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Case (Fall)");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Select a case for the current consultation:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tableViewer = new TableViewer(container, 67588);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 200;
        gd.widthHint = 400;
        this.tableViewer.getTable().setLayoutData((Object)gd);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new CoverageColorLabelProvider());
        if (this.patient != null) {
            List coverages = this.patient.getCoverages();
            Collections.sort(coverages, new CoverageComparator());
            this.tableViewer.setInput((Object)coverages);
            if (this.currentCoverage != null) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.currentCoverage));
            }
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    CoverageSelectionDialog.this.selectedCoverage = (ICoverage)selection.getFirstElement();
                }
            }
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public ICoverage getSelectedCoverage() {
        return this.selectedCoverage;
    }
}

