/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.views;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.icons.ImageSize;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.tardoc.Messages;
import ch.elexis.ungrad.tardoc.views.CoverageSelectionDialog;
import ch.elexis.ungrad.tardoc.views.TardocKonsView;
import ch.rgw.tools.Result;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class CasesComposite
extends Composite {
    private TardocKonsView tkv;
    private Hyperlink coverageLink;
    private ICoverage currentCoverage;
    private IPatient currentPatient;

    public CasesComposite(Composite parent, TardocKonsView view) {
        super(parent, 0);
        this.tkv = view;
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.coverageLink = new Hyperlink((Composite)this, 0);
        this.coverageLink.setText(Messages.CasesComposite_NoCase_Selected);
        this.coverageLink.setUnderlined(true);
        this.coverageLink.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.coverageLink.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CasesComposite.this.openCoverageSelectionDialog();
            }
        });
    }

    private void openCoverageSelectionDialog() {
        ICoverage selectedCoverage;
        if (this.currentPatient == null) {
            return;
        }
        CoverageSelectionDialog dialog = new CoverageSelectionDialog(this.getShell(), this.currentPatient, this.currentCoverage);
        if (dialog.open() == 0 && (selectedCoverage = dialog.getSelectedCoverage()) != null && !selectedCoverage.equals(this.currentCoverage)) {
            this.handleCoverageChange(selectedCoverage);
        }
    }

    private void handleCoverageChange(ICoverage changeToCoverage) {
        String fallLabel;
        ICoverage actCoverage = this.currentCoverage;
        String string = fallLabel = actCoverage != null ? actCoverage.getLabel() : "Current Case NOT found!!";
        if (!changeToCoverage.isOpen()) {
            SWTHelper.alert((String)ch.elexis.core.ui.views.Messages.Core_Case_is_closed, (String)ch.elexis.core.ui.views.Messages.KonsDetailView_CaseClosedBody);
        } else {
            Result transferResult;
            MessageDialog msd = new MessageDialog(this.getShell(), ch.elexis.core.ui.views.Messages.KonsDetailView_ChangeCaseCaption, Images.IMG_LOGO.getImage(ImageSize._75x66_TitleDialogIconSize), MessageFormat.format(ch.elexis.core.ui.views.Messages.KonsDetailView_ConfirmChangeConsToCase, fallLabel, changeToCoverage.getLabel()), 3, new String[]{ch.elexis.core.ui.views.Messages.Core_Yes, ch.elexis.core.ui.views.Messages.Corr_No}, 0);
            if (msd.open() == 0 && this.tkv.actEncounter != null && !(transferResult = EncounterServiceHolder.get().transferToCoverage(this.tkv.actEncounter, changeToCoverage, false)).isOK()) {
                SWTHelper.alert((String)"Error", (String)transferResult.toString());
            }
        }
    }

    void refreshCases(IEncounter actEncounter) {
        IPatient pat;
        if (this.isDisposed() || this.coverageLink == null || this.coverageLink.isDisposed()) {
            return;
        }
        this.currentPatient = pat = (IPatient)ContextServiceHolder.get().getRootContext().getTyped(IPatient.class).orElse(null);
        if (actEncounter != null) {
            this.currentCoverage = actEncounter.getCoverage();
            this.updateLinkText(this.currentCoverage);
            this.updateLinkColor(this.currentCoverage);
        } else {
            this.currentCoverage = null;
            this.coverageLink.setText(Messages.CasesComposite_NoCase_Selected);
            this.coverageLink.setForeground(this.getDisplay().getSystemColor(16));
        }
    }

    void setEncounter(ICoverage coverage) {
        if (this.isDisposed() || this.coverageLink == null || this.coverageLink.isDisposed()) {
            return;
        }
        this.currentCoverage = coverage;
        this.updateLinkText(coverage);
        this.updateLinkColor(coverage);
        this.coverageLink.setEnabled(coverage != null && coverage.isOpen());
    }

    private void updateLinkText(ICoverage coverage) {
        if (this.isDisposed() || this.coverageLink == null || this.coverageLink.isDisposed()) {
            return;
        }
        if (coverage != null) {
            Object label = coverage.getLabel();
            if (!coverage.isOpen()) {
                label = (String)label + " " + Messages.CasesComposite_Closed_Suffix;
            }
            this.coverageLink.setText((String)label);
        } else {
            this.coverageLink.setText(Messages.CasesComposite_NoCase_Selected);
        }
        this.layout(true);
    }

    private void updateLinkColor(ICoverage coverage) {
        if (this.isDisposed() || this.coverageLink == null || this.coverageLink.isDisposed()) {
            return;
        }
        if (coverage != null) {
            Color color = !coverage.isOpen() ? this.getDisplay().getSystemColor(16) : this.getDisplay().getSystemColor(9);
            this.coverageLink.setForeground(color);
        } else {
            this.coverageLink.setForeground(this.getDisplay().getSystemColor(16));
        }
    }
}

