/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.views;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.ui.processor.BillingProcessor;
import ch.elexis.core.ui.views.VerrechnungsDisplay;
import ch.elexis.ungrad.tardoc.Messages;
import ch.elexis.ungrad.tardoc.services.TardocManager;
import ch.elexis.ungrad.tardoc.views.TardocKonsView;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class BillingPositionsComposite
extends Composite {
    private TableViewer billingPositionsViewer;
    private Text searchField;
    private TardocManager tardocManager;
    private BundleContext bundleContext;
    private TardocKonsView tkv;
    private VerrechnungsDisplay billed;
    private IEncounter currentEncounter;

    @Optional
    @Inject
    public void updateEncounter(@UIEventTopic(value="info/elexis/model/update") IEncounter encounter) {
        if (encounter != null && encounter.equals(this.currentEncounter) && this.billed != null) {
            this.billed.setEncounter(encounter);
        }
    }

    public BillingPositionsComposite(Composite parent, int style, TardocKonsView view) {
        super(parent, style);
        this.tkv = view;
        this.bundleContext = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        this.tardocManager = TardocManager.getInstance();
        this.createContent();
    }

    void setKons(IEncounter k) {
        this.currentEncounter = k;
        this.billed.setEncounter(k);
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.billed = new VerrechnungsDisplay(this.tkv.getSite().getPage(), (Composite)this, 0);
        GridData billedGridData = new GridData(4, 4, true, true);
        billedGridData.minimumHeight = 100;
        billedGridData.heightHint = 700;
        this.billed.setLayoutData((Object)billedGridData);
        this.createSearchField(this);
        this.billingPositionsViewer = new TableViewer((Composite)this, 67588);
        GridData viewerGridData = new GridData(4, 4, true, true);
        viewerGridData.minimumHeight = 100;
        viewerGridData.heightHint = 300;
        this.billingPositionsViewer.getTable().setLayoutData((Object)viewerGridData);
        this.billingPositionsViewer.getTable().setHeaderVisible(false);
        this.billingPositionsViewer.getTable().setLinesVisible(true);
        this.billingPositionsViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.billingPositionsViewer.setLabelProvider((IBaseLabelProvider)new BillingPositionLabelProvider());
        this.addDragSupport();
        this.addDoubleClickSupport();
        this.billingPositionsViewer.setInput(Collections.emptyList());
    }

    private void createSearchField(Composite parent) {
        Composite searchComposite = new Composite(parent, 0);
        searchComposite.setLayout((Layout)new GridLayout(2, false));
        searchComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label searchLabel = new Label(searchComposite, 0);
        searchLabel.setText(Messages.BillingPositionsComposite_Search_Label);
        searchLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.searchField = new Text(searchComposite, 2944);
        this.searchField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchField.setMessage(Messages.BillingPositionsComposite_Search_Placeholder);
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BillingPositionsComposite.this.performSearch();
            }
        });
    }

    private void performSearch() {
        String searchText = this.searchField.getText().trim();
        if (searchText.isEmpty()) {
            this.billingPositionsViewer.setInput(Collections.emptyList());
            return;
        }
        if (this.tardocManager == null || !this.tardocManager.isServiceAvailable(this.bundleContext)) {
            this.billingPositionsViewer.setInput(Collections.emptyList());
            return;
        }
        try {
            List<ITardocLeistung> results = this.tardocManager.getLeistungen(searchText, this.bundleContext);
            this.billingPositionsViewer.setInput(results);
        }
        catch (Exception ex) {
            this.billingPositionsViewer.setInput(Collections.emptyList());
            ex.printStackTrace();
        }
    }

    private void addDragSupport() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        DragSource dragSource = new DragSource((Control)this.billingPositionsViewer.getTable(), operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BillingPositionsComposite.this.billingPositionsViewer.getSelection();
                if (selection.isEmpty()) {
                    event.data = null;
                    return;
                }
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof ITardocLeistung) {
                    ITardocLeistung leistung = (ITardocLeistung)firstElement;
                    String storeToString = StoreToStringServiceHolder.getStoreToString((Object)leistung);
                    event.data = storeToString;
                } else {
                    event.data = null;
                }
            }

            public void dragStart(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)BillingPositionsComposite.this.billingPositionsViewer.getSelection();
                event.doit = !selection.isEmpty();
            }
        });
    }

    public TableViewer getBillingPositionsViewer() {
        return this.billingPositionsViewer;
    }

    public void setInput(Object input) {
        if (this.billingPositionsViewer != null && !this.billingPositionsViewer.getTable().isDisposed()) {
            this.billingPositionsViewer.setInput(input);
        }
    }

    public void refresh() {
        if (this.billingPositionsViewer != null && !this.billingPositionsViewer.getTable().isDisposed()) {
            this.billingPositionsViewer.refresh();
        }
    }

    private void addDoubleClickSupport() {
        this.billingPositionsViewer.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)BillingPositionsComposite.this.billingPositionsViewer.getSelection();
                if (selection.isEmpty() || BillingPositionsComposite.this.currentEncounter == null) {
                    return;
                }
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof ITardocLeistung) {
                    ITardocLeistung leistung = (ITardocLeistung)firstElement;
                    try {
                        BillingProcessor bp = new BillingProcessor(BillingPositionsComposite.this.currentEncounter);
                        bp.processOtherObject((Object)leistung);
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)BillingPositionsComposite.this.currentEncounter);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    class BillingPositionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        BillingPositionLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ITardocLeistung) {
                ITardocLeistung leistung = (ITardocLeistung)obj;
                return leistung.getCode() + " - " + leistung.getText();
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

