/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.services;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.base.ch.arzttarife.util.ArzttarifeUtil;
import ch.elexis.core.findings.ICoding;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TardocManager.class})
public class TardocManager {
    private static IModelService modelService;
    private boolean bOnlyValidForDignity = true;
    private static TardocManager theInstance;

    static {
        theInstance = null;
    }

    private TardocManager() {
    }

    public static TardocManager getInstance() {
        if (theInstance == null) {
            theInstance = new TardocManager();
        }
        return theInstance;
    }

    @Reference(target="(service.model.name=ch.elexis.base.ch.arzttarife.model)")
    public void setModelService(IModelService modelService) {
        TardocManager.modelService = modelService;
    }

    private IModelService getModelService(BundleContext context) {
        if (modelService != null) {
            System.out.println("TardocManager: Using injected IModelService");
            return modelService;
        }
        System.out.println("TardocManager: Attempting direct OSGi lookup for IModelService");
        try {
            if (context == null) {
                context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            }
            if (context != null) {
                System.out.println("TardocManager: BundleContext obtained");
                String filter = "(service.model.name=ch.elexis.base.ch.arzttarife.model)";
                ServiceReference[] refs = context.getServiceReferences(IModelService.class.getName(), filter);
                if (refs != null && refs.length > 0) {
                    IModelService service;
                    System.out.println("TardocManager: Found " + refs.length + " matching service(s)");
                    modelService = service = (IModelService)context.getService(refs[0]);
                    return service;
                }
                System.err.println("TardocManager: No matching IModelService found with filter: " + filter);
            } else {
                System.err.println("TardocManager: BundleContext is null");
            }
        }
        catch (InvalidSyntaxException e) {
            System.err.println("TardocManager: Invalid filter syntax");
            e.printStackTrace();
        }
        return null;
    }

    public List<ITardocLeistung> getLeistungen(String filter) {
        return this.getLeistungen(filter, null);
    }

    public List<ITardocLeistung> getLeistungen(String filter, BundleContext context) {
        IModelService service = this.getModelService(context);
        if (service == null) {
            System.err.println("TardocManager: IModelService is not available");
            return Collections.emptyList();
        }
        try {
            IQuery query = service.getQuery(ITardocLeistung.class);
            query.and("isChapter", IQuery.COMPARATOR.EQUALS, (Object)false);
            if (filter != null && !filter.trim().isEmpty()) {
                query.and("tx255", IQuery.COMPARATOR.LIKE, (Object)("%" + filter + "%"), true);
            }
            query.and("deleted", IQuery.COMPARATOR.EQUALS, (Object)false);
            query.orderBy("code_", IQuery.ORDER.ASC);
            List<ITardocLeistung> results = query.execute();
            if (this.bOnlyValidForDignity) {
                results = this.filterByDignity(results);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private List<ITardocLeistung> filterByDignity(List<ITardocLeistung> leistungen) {
        IMandator mandator = ContextServiceHolder.get().getActiveMandator().orElse(null);
        if (mandator == null) {
            return leistungen;
        }
        List mandatorDignities = ArzttarifeUtil.getMandantTardocSepcialist((IMandator)mandator);
        if (mandatorDignities == null || mandatorDignities.isEmpty()) {
            return leistungen;
        }
        Set mandatorDignityCodes = mandatorDignities.stream().map(ICoding::getCode).collect(Collectors.toSet());
        return leistungen.stream().filter(leistung -> {
            String[] dignities;
            String digniQuali = leistung.getDigniQuali();
            if (digniQuali == null || digniQuali.trim().isEmpty()) {
                return true;
            }
            String[] stringArray = dignities = digniQuali.split("\\|");
            int n = dignities.length;
            int n2 = 0;
            while (n2 < n) {
                String dignity = stringArray[n2];
                if (mandatorDignityCodes.contains(dignity.trim())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public boolean isOnlyValidForDignity() {
        return this.bOnlyValidForDignity;
    }

    public void setOnlyValidForDignity(boolean onlyValidForDignity) {
        this.bOnlyValidForDignity = onlyValidForDignity;
    }

    public boolean isServiceAvailable() {
        return this.isServiceAvailable(null);
    }

    public boolean isServiceAvailable(BundleContext context) {
        return this.getModelService(context) != null;
    }

    public ITardocLeistung getLeistungByCode(String code, BundleContext context) {
        IModelService service = this.getModelService(context);
        if (service == null) {
            System.err.println("TardocManager: IModelService is not available");
            return null;
        }
        try {
            IQuery query = service.getQuery(ITardocLeistung.class);
            query.and("code_", IQuery.COMPARATOR.EQUALS, (Object)code);
            query.and("deleted", IQuery.COMPARATOR.EQUALS, (Object)false);
            List results = query.execute();
            if (results != null && !results.isEmpty()) {
                return (ITardocLeistung)results.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean mandatorHasDignity(String dignityCode) {
        IMandator mandator = ContextServiceHolder.get().getActiveMandator().orElse(null);
        if (mandator == null) {
            return false;
        }
        List mandatorDignities = ArzttarifeUtil.getMandantTardocSepcialist((IMandator)mandator);
        if (mandatorDignities == null || mandatorDignities.isEmpty()) {
            return false;
        }
        return mandatorDignities.stream().anyMatch(coding -> dignityCode.equals(coding.getCode()));
    }
}

