/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TardocConfig {
    private Map<String, DignityConfig> dignityConfigs;

    public DignityConfig getDignityConfig(String dignityCode) {
        return this.dignityConfigs != null ? this.dignityConfigs.get(dignityCode) : null;
    }

    public Map<String, DignityConfig> getDignityConfigs() {
        return this.dignityConfigs;
    }

    public void setDignityConfigs(Map<String, DignityConfig> configs) {
        this.dignityConfigs = configs;
    }

    public static TardocConfig load() {
        try {
            Bundle bundle = FrameworkUtil.getBundle(TardocConfig.class);
            if (bundle != null) {
                InputStream is = bundle.getResource("rsc/config.json").openStream();
                InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
                Gson gson = new GsonBuilder().registerTypeAdapter(TardocConfig.class, (Object)new TardocConfigDeserializer()).create();
                TardocConfig config = (TardocConfig)gson.fromJson((Reader)reader, TardocConfig.class);
                ((Reader)reader).close();
                return config;
            }
        }
        catch (Exception e) {
            System.err.println("Error loading config.json: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public static class DignityConfig {
        public boolean autobilling_enabled;
        public String initial_billing;
        public FollowupBilling followup_billing;
        public Map<String, String> stop_timer;
        public Map<String, String> continue_timer;

        public boolean isAutobillingEnabled() {
            return this.autobilling_enabled;
        }

        public String getInitialBilling() {
            return this.initial_billing;
        }

        public FollowupBilling getFollowupBilling() {
            return this.followup_billing;
        }

        public Map<String, String> getStopTimer() {
            return this.stop_timer;
        }

        public Map<String, String> getContinueTimer() {
            return this.continue_timer;
        }
    }

    public static class FollowupBilling {
        public String code;
        public String after;
        public String every;
        public String max;

        public String getCode() {
            return this.code;
        }

        public int getMax() {
            try {
                return Integer.parseInt(this.max);
            }
            catch (NumberFormatException numberFormatException) {
                return 1;
            }
        }

        public int getAfter() {
            try {
                return Integer.parseInt(this.after);
            }
            catch (NumberFormatException numberFormatException) {
                return 1;
            }
        }

        public int getEvery() {
            try {
                return Integer.parseInt(this.every);
            }
            catch (NumberFormatException numberFormatException) {
                return 1;
            }
        }
    }

    private static class TardocConfigDeserializer
    implements JsonDeserializer<TardocConfig> {
        private TardocConfigDeserializer() {
        }

        public TardocConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            TardocConfig config = new TardocConfig();
            JsonObject jsonObject = json.getAsJsonObject();
            HashMap<String, DignityConfig> dignityConfigs = new HashMap<String, DignityConfig>();
            for (Map.Entry entry : jsonObject.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                try {
                    Integer.parseInt(key);
                    DignityConfig dignityConfig = (DignityConfig)context.deserialize(value, DignityConfig.class);
                    dignityConfigs.put(key, dignityConfig);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            config.setDignityConfigs(dignityConfigs);
            return config;
        }
    }
}

