/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.services;

import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class EncounterTimer
extends Timer {
    private long startTime = 0L;
    private long pausedTime = 0L;
    private boolean isRunning = false;
    private LinkedList<TimerListener> listeners = new LinkedList();

    public EncounterTimer() {
        super("ElexisEncounterTimer", true);
        this.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!EncounterTimer.this.isRunning) {
                    return;
                }
                EncounterTimer.this.publish();
            }
        }, 0L, 1000L);
    }

    private void publish() {
        long elapsedSeconds = (System.currentTimeMillis() - this.startTime) / 1000L;
        if (this.startTime == 0L) {
            elapsedSeconds = 0L;
        }
        for (TimerListener listener : this.listeners) {
            listener.onTick(elapsedSeconds);
        }
    }

    public void start() {
        this.isRunning = true;
        this.startTime = System.currentTimeMillis();
    }

    public void pause() {
        this.isRunning = false;
        this.pausedTime = System.currentTimeMillis() - this.startTime;
        this.publish();
    }

    public void resume() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
        } else {
            this.startTime = System.currentTimeMillis() - this.pausedTime;
            this.pausedTime = 0L;
        }
        this.isRunning = true;
        this.publish();
    }

    public void stop() {
        this.isRunning = false;
        this.startTime = 0L;
        this.publish();
    }

    public void dispose() {
        for (TimerListener listener : this.listeners) {
            this.removeTimerListener(listener);
        }
        this.cancel();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void addTimerListener(TimerListener listener) {
        this.listeners.add(listener);
    }

    public void removeTimerListener(TimerListener listener) {
        this.listeners.remove(listener);
    }

    public static interface TimerListener {
        public void onTick(long var1);
    }
}

