/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.services;

import ch.elexis.core.model.IDiagnosis;
import ch.elexis.core.model.IDiagnosisTree;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.IQuery;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DiagnosesManager {
    private static IModelService icd10ModelService;

    private IModelService getIcd10ModelService() {
        if (icd10ModelService != null) {
            return icd10ModelService;
        }
        try {
            BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            if (context != null) {
                String filter = "(service.model.name=ch.elexis.base.ch.icd10)";
                ServiceReference[] refs = context.getServiceReferences(IModelService.class.getName(), filter);
                if (refs != null && refs.length > 0) {
                    IModelService service;
                    icd10ModelService = service = (IModelService)context.getService(refs[0]);
                    return service;
                }
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<IDiagnosis> findDiagnoses(String codeSystem, String pattern) {
        if (pattern == null || pattern.trim().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IDiagnosis> results = new ArrayList<IDiagnosis>();
        if ("ICD-10".equals(codeSystem)) {
            results.addAll(this.searchIcd10(pattern));
        } else if ("TI-Code".equals(codeSystem)) {
            results.addAll(this.searchTessinerCode(pattern));
        } else if ("Alle".equals(codeSystem)) {
            results.addAll(this.searchIcd10(pattern));
            results.addAll(this.searchTessinerCode(pattern));
        }
        return results;
    }

    private List<IDiagnosis> searchIcd10(String pattern) {
        IModelService service = this.getIcd10ModelService();
        if (service == null) {
            System.err.println("DiagnosesManager: ICD-10 IModelService is not available");
            return Collections.emptyList();
        }
        try {
            IQuery query = service.getQuery(IDiagnosisTree.class);
            query.startGroup();
            query.or("code", IQuery.COMPARATOR.LIKE, (Object)("%" + pattern + "%"), true);
            query.or("text", IQuery.COMPARATOR.LIKE, (Object)("%" + pattern + "%"), true);
            query.andJoinGroups();
            query.orderBy("code", IQuery.ORDER.ASC);
            List results = query.execute();
            return results.stream().map(d -> d).collect(Collectors.toList());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private List<IDiagnosis> searchTessinerCode(String pattern) {
        ArrayList<IDiagnosis> results;
        block11: {
            results = new ArrayList<IDiagnosis>();
            String searchPattern = pattern.toLowerCase();
            try {
                BundleContext context = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                if (context == null) break block11;
                try {
                    ServiceReference[] refs = context.getServiceReferences("ch.elexis.core.services.ICodeElementServiceContribution", null);
                    if (refs != null && refs.length > 0) {
                        ServiceReference[] serviceReferenceArray = refs;
                        int n = refs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ServiceReference ref = serviceReferenceArray[n2];
                            Object service = context.getService(ref);
                            Method getSystemMethod = service.getClass().getMethod("getSystem", new Class[0]);
                            String systemName = (String)getSystemMethod.invoke(service, new Object[0]);
                            if ("TI-Code".equals(systemName)) {
                                Method getElementsMethod = service.getClass().getMethod("getElements", Map.class);
                                HashMap<Object, Boolean> contextMap = new HashMap<Object, Boolean>();
                                Class<?> contextKeysClass = Class.forName("ch.elexis.core.services.ICodeElementService$ContextKeys");
                                Object treeRootsKey = contextKeysClass.getField("TREE_ROOTS").get(null);
                                contextMap.put(treeRootsKey, Boolean.TRUE);
                                Object rootElements = getElementsMethod.invoke(service, contextMap);
                                if (rootElements instanceof List) {
                                    List roots = (List)rootElements;
                                    for (IDiagnosisTree root : roots) {
                                        List children;
                                        if (this.matches(root, searchPattern)) {
                                            results.add((IDiagnosis)root);
                                        }
                                        if ((children = root.getChildren()) == null) continue;
                                        for (IDiagnosisTree child : children) {
                                            if (!this.matches(child, searchPattern)) continue;
                                            results.add((IDiagnosis)child);
                                        }
                                    }
                                }
                                context.ungetService(ref);
                                break block11;
                            }
                            context.ungetService(ref);
                            ++n2;
                        }
                        break block11;
                    }
                    System.err.println("DiagnosesManager: No ICodeElementServiceContribution services found");
                }
                catch (Exception e) {
                    System.err.println("DiagnosesManager: Could not access TI-Code via ICodeElementServiceContribution: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private boolean matches(IDiagnosisTree diagnosis, String pattern) {
        if (diagnosis == null) {
            return false;
        }
        String codeStr = diagnosis.getCode();
        String text = diagnosis.getText();
        return codeStr != null && codeStr.toLowerCase().contains(pattern) || text != null && text.toLowerCase().contains(pattern);
    }
}

