/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.tardoc.services;

import ch.elexis.base.ch.arzttarife.tardoc.ITardocLeistung;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.ungrad.tardoc.services.TardocConfig;
import ch.elexis.ungrad.tardoc.services.TardocManager;
import ch.elexis.ungrad.tardoc.views.TardocKonsView;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class BillingsManager {
    private IEncounter kons;
    private TardocKonsView tkv;
    private TardocConfig config;
    private TardocConfig.DignityConfig activeDignityConfig;
    private String activeDignityCode;
    private int autoBillingCount = 0;
    private long lastBilledMinute = -1L;
    BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    private TardocManager manager = TardocManager.getInstance();

    public BillingsManager(TardocKonsView view) {
        this.tkv = view;
        this.config = TardocConfig.load();
        this.updateActiveDignityConfig();
    }

    private void updateActiveDignityConfig() {
        if (this.config == null || this.config.getDignityConfigs() == null) {
            return;
        }
        for (String dignityCode : this.config.getDignityConfigs().keySet()) {
            if (!this.manager.mandatorHasDignity(dignityCode)) continue;
            this.activeDignityConfig = this.config.getDignityConfig(dignityCode);
            this.activeDignityCode = dignityCode;
            System.out.println("BillingsManager: Active dignity " + dignityCode + ", autobilling " + (this.activeDignityConfig.isAutobillingEnabled() ? "enabled" : "disabled"));
            break;
        }
    }

    public TardocConfig getConfig() {
        return this.config;
    }

    public TardocConfig.DignityConfig getActiveDignityConfig() {
        return this.activeDignityConfig;
    }

    public String getActiveDignityCode() {
        return this.activeDignityCode;
    }

    public void setEncounter(IEncounter kons) {
        this.kons = kons;
    }

    public boolean isToday() {
        LocalDate konsDate = this.kons.getDate();
        return konsDate.isEqual(LocalDate.now());
    }

    public void autobill(long minutesElapsed) {
        if (this.kons == null) {
            return;
        }
        if (this.activeDignityConfig == null) {
            System.out.println("BillingsManager: No active dignity configuration, skipping autostart");
            return;
        }
        if (!this.activeDignityConfig.isAutobillingEnabled()) {
            System.out.println("BillingsManager: Autobilling disabled for dignity " + this.activeDignityCode);
            return;
        }
        List billed = this.kons.getBilled();
        if (billed == null || billed.isEmpty()) {
            String initialBillingCode = this.activeDignityConfig.getInitialBilling();
            if (initialBillingCode == null || initialBillingCode.trim().isEmpty()) {
                System.err.println("BillingsManager: No initial billing code configured for dignity " + this.activeDignityCode);
                return;
            }
            ITardocLeistung initialBilling = this.manager.getLeistungByCode(initialBillingCode, this.bundleContext);
            if (initialBilling != null) {
                BillingServiceHolder.get().bill((IBillable)initialBilling, this.kons, 1.0);
                this.autoBillingCount = 1;
                this.lastBilledMinute = (int)minutesElapsed;
                System.out.println("BillingsManager: Applied initial billing " + initialBillingCode + " for dignity " + this.activeDignityCode);
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.kons);
            } else {
                System.err.println("BillingsManager: Initial billing code " + initialBillingCode + " not found in Tardoc");
            }
            return;
        }
        int numBilled = 0;
        for (IBilled ib : billed) {
            if (ib.isDeleted()) continue;
            numBilled = (int)((double)numBilled + ib.getAmount());
            String text = this.getStopTimerText(ib);
            if (text == null) continue;
            this.tkv.insertTextAtEndOfKons(text);
            this.stopAutoBilling();
            return;
        }
        if (this.autoBillingCount < numBilled) {
            System.out.println("BillingsManager: Manual billing detected, skipping autobill");
            this.stopAutoBilling();
            return;
        }
        TardocConfig.FollowupBilling followup = this.activeDignityConfig.getFollowupBilling();
        if (followup.getCode() == null || followup.getCode().trim().isEmpty()) {
            return;
        }
        int afterMinutes = followup.getAfter();
        int everyMinutes = followup.getEvery();
        int maxCount = followup.getMax();
        if (minutesElapsed >= (long)afterMinutes && this.autoBillingCount < maxCount + 1) {
            long minutesSinceThreshold = minutesElapsed - (long)afterMinutes;
            long currentMinute = minutesElapsed;
            if (minutesSinceThreshold % (long)everyMinutes == 0L && this.lastBilledMinute != currentMinute) {
                this.lastBilledMinute = currentMinute;
                ITardocLeistung followupBilling = this.manager.getLeistungByCode(followup.getCode(), this.bundleContext);
                if (followupBilling == null) {
                    System.err.println("BillingsManager: Followup billing code " + followup.getCode() + " not found in Tardoc");
                    return;
                }
                BillingServiceHolder.get().bill((IBillable)followupBilling, this.kons, 1.0);
                ++this.autoBillingCount;
                ContextServiceHolder.get().postEvent("info/elexis/model/update", (Object)this.kons);
                if (this.autoBillingCount >= maxCount + 1) {
                    System.out.println("BillingsManager: Reached max followup billings (" + maxCount + "), stopping timer");
                    this.stopAutoBilling();
                }
            }
        }
    }

    private void stopAutoBilling() {
        this.tkv.encounterTimer.pause();
    }

    public String getStopTimerText(IBilled billed) {
        if (billed == null || this.activeDignityConfig == null) {
            return null;
        }
        Map<String, String> stopTimer = this.activeDignityConfig.getStopTimer();
        if (stopTimer == null || stopTimer.isEmpty()) {
            return null;
        }
        String billedCode = billed.getCode();
        if (billedCode == null) {
            return null;
        }
        return stopTimer.get(billedCode);
    }
}

