/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.QR_Outputter;

import ch.elexis.TarmedRechnung.XMLExporter;
import ch.elexis.TarmedRechnung.XMLExporterUtil;
import ch.elexis.base.ch.arzttarife.xml.exporter.Tarmed45Exporter;
import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.ResultAdapter;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.RnOutputDialog;
import ch.elexis.core.utils.PlatformHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Rechnung;
import ch.elexis.pdfBills.ElexisPDFGenerator;
import ch.elexis.pdfBills.OutputterUtil;
import ch.elexis.pdfBills.PdfUtil;
import ch.elexis.pdfBills.TarmedXmlUtil;
import ch.elexis.ungrad.Mailer;
import ch.elexis.ungrad.QR_Outputter.Messages;
import ch.elexis.ungrad.QR_Outputter.QR_SettingsControl;
import ch.elexis.ungrad.Resolver;
import ch.elexis.ungrad.pdf.Manager;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Result;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.jdom2.Document;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.LoggerFactory;

public class QrRnOutputter
implements IRnOutputter {
    public static final String PDFDIR = "pdfdir";
    public static final String PLUGIN_ID = "ch.elexis.pdfBills";
    public static final String XMLDIR = "xmldir";
    public static final String CFG_ROOT = "qrpdf-output/";
    public static final String CFG_MARGINLEFT = "margin.left";
    public static final String CFG_MARGINRIGHT = "margin.right";
    public static final String CFG_MARGINTOP = "margin.top";
    public static final String CFG_MARGINBOTTOM = "margin.bottom";
    public static final String CFG_BESR_MARGIN_VERTICAL = "margin.besr.vertical";
    public static final String CFG_BESR_MARGIN_HORIZONTAL = "margin.besr.horizontal";
    public static final String CFG_ESR_HEADER_1 = "qrpdf-output/esr.header.line1";
    public static final String CFG_ESR_HEADER_2 = "qrpdf-output/esr.header.line2";
    public static final String CFG_PRINT_DIRECT = "qrpdf-output/print.direct";
    public static final String CFG_PRINT_PRINTER = "qrpdf-output/print.printer";
    public static final String CFG_PRINT_TRAY = "qrpdf-output/print.tray";
    public static final String CFG_ESR_PRINT_PRINTER = "qrpdf-output/esr.print.printer";
    public static final String CFG_ESR_PRINT_TRAY = "qrpdf-output/esr.print.tray";
    public static final String CFG_PRINT_COMMAND = "qrpdf-output/print.command";
    public static final String CFG_PRINT_USE_SCRIPT = "qrpdf-output/print.usescript";
    protected static final String CFG_MAIL_CPY = "mail.copy";
    protected static final String CFG_MAIL_MANDANT_ACCOUNT = "mail.mandant.account";
    public static final String CFG_MSGTEXT_TP_M0 = "qrpdf-output/pdf.txt.tp";
    public static final String CFG_MSGTEXT_TG_M0 = "qrpdf-output/pdf.txt.tg";
    public static final String CFG_MSGTEXT_TP_M1 = "qrpdf-output/pdf.txt.M1tp";
    public static final String CFG_MSGTEXT_TP_M2 = "qrpdf-output/pdf.txt.M2tp";
    public static final String CFG_MSGTEXT_TP_M3 = "qrpdf-output/pdf.txt.M3tp";
    public static final String CFG_MSGTEXT_TG_M1 = "qrpdf-output/pdf.txt.M1tg";
    public static final String CFG_MSGTEXT_TG_M2 = "qrpdf-output/pdf.txt.M2tg";
    public static final String CFG_MSGTEXT_TG_M3 = "qrpdf-output/pdf.txt.M3tg";
    private QR_SettingsControl qrs;
    private Manager pdfManager = new Manager();
    String mailPref;
    Mailer mailer;
    private boolean modifyInvoiceState;
    private boolean noPrint;
    private boolean pdfOnly;
    private RnOutputDialog rnOutputDialog;
    private Button buttonOpen;
    private IConfigService cfg = ConfigServiceHolder.get();

    public String getDescription() {
        return Messages.QrRnOutputter_Description;
    }

    public QrRnOutputter() {
        this.mailPref = this.cfg.get("ch.elexis.ungrad/qrbills/sendByMailVaseVar", "");
        this.mailer = new Mailer();
        this.mailer.showSuccess(false);
    }

    private String[] shouldMail(Rechnung bill) {
        Fall fall = bill.getFall();
        String mailaddr = "";
        String mailbody = this.cfg.get("ch.elexis.ungrad/qrbills/mailbody", "");
        if (!StringTool.isNothing((Object)this.mailPref)) {
            mailaddr = fall.getInfoString(this.mailPref);
            if (!StringTool.isMailAddress((String)mailaddr)) {
                return null;
            }
            String altBody = fall.getInfoString("Mailtext");
            if (!StringTool.isNothing((Object)altBody)) {
                mailbody = altBody;
            }
            return new String[]{mailaddr, mailbody};
        }
        return null;
    }

    public Result<Rechnung> doOutput(final IRnOutputter.TYPE type, final Collection<Rechnung> rnn, Properties props) {
        if (!props.isEmpty()) {
            this.initSelectedFromProperties(props);
        } else {
            this.modifyInvoiceState = true;
            this.noPrint = false;
        }
        if (StringUtils.isEmpty((CharSequence)OutputterUtil.getXmlOutputDir((String)CFG_ROOT))) {
            String msg = Messages.QrRnOutputter_NoXMLDir;
            SWTHelper.showError((String)Messages.QrRnOutputter_ErrorTitle, (String)msg);
            return new Result(Result.SEVERITY.ERROR, 2, msg, null, true);
        }
        if (!OutputterUtil.isPdfOutputDirValid((String)CFG_ROOT)) {
            String msg = Messages.QrRnOutputter_NoPDFDir;
            SWTHelper.showError((String)Messages.QrRnOutputter_ErrorTitle, (String)msg);
            return new Result(Result.SEVERITY.ERROR, 2, msg, null, true);
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        Result res = new Result();
        final File rsc = new File(PlatformHelper.getBasePath((String)PLUGIN_ID), "rsc");
        try {
            progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.QrRnOutputter_ExportingInvoices, rnn.size() * 10);
                    int errors = 0;
                    for (Rechnung rn : rnn) {
                        block20: {
                            IInvoice invoice = (IInvoice)CoreModelServiceHolder.get().load(rn.getId(), IInvoice.class).orElseThrow(() -> new IllegalStateException("Could not load invoice [" + rn.getId() + "]"));
                            XMLExporter ex = new XMLExporter();
                            Document dRn = ex.doExport(rn, null, type, true);
                            dRn = TarmedXmlUtil.setPrintAtIntermediate((Document)dRn, (boolean)false);
                            monitor.worked(1);
                            if (invoice.getState() == InvoiceState.DEFECTIVE) {
                                ++errors;
                                continue;
                            }
                            String fname = OutputterUtil.getXmlOutputDir((String)QrRnOutputter.CFG_ROOT) + File.separator + invoice.getNumber() + ".xml";
                            try {
                                String[] mailing;
                                OutputStream fout = VirtualFilesystemServiceHolder.get().of(fname).openOutputStream();
                                OutputStreamWriter cout = new OutputStreamWriter(fout, "UTF-8");
                                XMLOutputter xout = new XMLOutputter(Format.getPrettyFormat());
                                xout.output(dRn, (Writer)cout);
                                cout.close();
                                fout.close();
                                ElexisPDFGenerator epdf = new ElexisPDFGenerator(fname, invoice.getNumber(), invoice.getState());
                                if (QrRnOutputter.this.pdfOnly || QrRnOutputter.this.noPrint) {
                                    epdf.setPrint(false);
                                }
                                Tarmed45Exporter.EsrType outputEsrType = ex.getEsrTypeOrFallback(invoice);
                                if ("5.0".equals(epdf.getBillVersion())) {
                                    epdf.printQrBill(rsc);
                                } else if ("4.5".equals(epdf.getBillVersion()) && outputEsrType != Tarmed45Exporter.EsrType.esr9) {
                                    epdf.printQrBill(rsc);
                                } else {
                                    LoggerFactory.getLogger(this.getClass()).warn("Fallback to ESR9 for xml version [" + epdf.getBillVersion() + "] and esrType [" + String.valueOf(outputEsrType) + "]");
                                    epdf.printBill(rsc);
                                }
                                if (QrRnOutputter.this.modifyInvoiceState) {
                                    int status_vorher = invoice.getState().numericValue();
                                    if (status_vorher == InvoiceState.OPEN.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_1.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_2.numericValue() || status_vorher == InvoiceState.DEMAND_NOTE_3.numericValue()) {
                                        invoice.setState(InvoiceState.fromState((int)(status_vorher + 1)));
                                    }
                                    invoice.addTrace("Ausgegeben", QrRnOutputter.this.getDescription() + ": " + invoice.getState().getLocaleText());
                                    CoreModelServiceHolder.get().save((Identifiable)invoice);
                                }
                                List printed = epdf.getPrintedBill();
                                if (epdf.isCopy()) {
                                    for (File pdfFile : printed) {
                                        PdfUtil.addCopyWatermark((File)pdfFile);
                                    }
                                }
                                if ((mailing = QrRnOutputter.this.shouldMail(rn)) != null) {
                                    ArrayList toMail = new ArrayList();
                                    printed.stream().forEach(f -> {
                                        if (f.exists()) {
                                            toMail.add(f.getAbsolutePath());
                                        }
                                    });
                                    HashMap<String, Object> replacer = new HashMap<String, Object>();
                                    replacer.put("Adressat", rn.getFall().getInvoiceRecipient());
                                    replacer.put("Mandant", rn.getFall().getRechnungssteller());
                                    replacer.put("Patient", rn.getFall().getPatient());
                                    replacer.put("Rechnung", rn);
                                    Resolver resolver = new Resolver(replacer, true);
                                    String subject = resolver.resolve(QrRnOutputter.this.cfg.get("ch.elexis.ungrad/qrbills/mailsubject", "Rechnung"));
                                    String body = resolver.resolve(mailing[1]);
                                    QrRnOutputter.this.mailer.defaultMail(mailing[0], subject, body, toMail.toArray(new String[toMail.size()]));
                                    rn.addTrace("Ausgegeben", Messages.QrRnOutputter_ByMailTo.replace("{0}", mailing[0]));
                                    try {
                                        TimeUnit.MILLISECONDS.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    break block20;
                                }
                                boolean doPrint = QrRnOutputter.this.cfg.getLocal("ch.elexis.ungrad/qrbills/do_print", true);
                                if (!doPrint) break block20;
                                for (File pdfFile : printed) {
                                    if (!pdfFile.exists()) continue;
                                    QrRnOutputter.this.pdfManager.printFromPDF(pdfFile, QrRnOutputter.this.qrs.selectedPrinter);
                                }
                            }
                            catch (IllegalStateException e) {
                                ExHandler.handle((Throwable)e);
                                SWTHelper.showError((String)Messages.QrRnOutputter_ErrorTitle, (String)Messages.QrRnOutputter_WriteError.replace("{0}", e.getMessage()));
                                invoice.reject(InvoiceState.REJECTCODE.INTERNAL_ERROR, "write error: " + fname);
                                CoreModelServiceHolder.get().save((Identifiable)invoice);
                                continue;
                            }
                            catch (Exception e1) {
                                ExHandler.handle((Throwable)e1);
                                SWTHelper.showError((String)Messages.QrRnOutputter_ErrorTitle, (String)Messages.QrRnOutputter_CouldNotWrite.replace("{0}", fname).replace("{1}", e1.getMessage()));
                                invoice.reject(InvoiceState.REJECTCODE.INTERNAL_ERROR, "write error: " + fname);
                                CoreModelServiceHolder.get().save((Identifiable)invoice);
                                continue;
                            }
                        }
                        monitor.worked(1);
                    }
                    QrRnOutputter.this.pdfOnly = false;
                    monitor.done();
                    if (errors > 0) {
                        SWTHelper.alert((String)Messages.QrRnOutputter_TransmissionError, (String)Messages.QrRnOutputter_DefectiveInvoices.replace("{0}", Integer.toString(errors)));
                    } else {
                        SWTHelper.showInfo((String)Messages.QrRnOutputter_TransmissionComplete, (String)Messages.QrRnOutputter_NoErrors);
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            res.add(Result.SEVERITY.ERROR, 2, ex.getMessage(), null, true);
            Display.getDefault().syncExec(() -> ErrorDialog.openError(null, (String)Messages.QrRnOutputter_OutputError, (String)Messages.QrRnOutputter_CouldNotStart, (IStatus)ResultAdapter.getResultAsStatus((Result)res)));
        }
        return res;
    }

    private void initSelectedFromProperties(Properties props) {
        String value;
        LoggerFactory.getLogger(this.getClass()).warn("Initializing with properties " + props.toString());
        this.modifyInvoiceState = true;
        if (props.get("OutputModifyInvoiceState") instanceof String) {
            value = (String)props.get("OutputModifyInvoiceState");
            this.modifyInvoiceState = Boolean.parseBoolean(value);
        }
        if (props.get("OutputWithEsr") instanceof String) {
            value = (String)props.get("OutputWithEsr");
            LocalConfigService.set((String)"qrpdf-output/print.besr", (boolean)Boolean.parseBoolean(value));
        }
        if (props.get("OutputWithReclaim") instanceof String) {
            value = (String)props.get("OutputWithReclaim");
            LocalConfigService.set((String)"qrpdf-output/print.rf", (boolean)Boolean.parseBoolean(value));
        }
        if (props.get("OutputWithMail") instanceof String) {
            value = (String)props.get("OutputWithMail");
            LocalConfigService.set((String)"qrpdf-output/mail.copy", (boolean)Boolean.parseBoolean(value));
        }
        if (props.get("OutputNoPrint") instanceof String) {
            value = (String)props.get("OutputNoPrint");
            this.noPrint = Boolean.parseBoolean(value);
        }
    }

    private Kontakt getGuarantor(Rechnung rn) {
        IContact ret;
        IPatient patient;
        ICoverage coverage = CoreModelServiceHolder.get().load(rn.getFall().getId(), ICoverage.class).orElse(null);
        if (coverage != null && (patient = (IPatient)CoreModelServiceHolder.get().load(rn.getFall().getPatient().getId(), IPatient.class).orElse(null)) != null && (ret = XMLExporterUtil.getGuarantor((String)"TP", (IPatient)patient, (ICoverage)coverage)) != null) {
            return Kontakt.load((String)ret.getId());
        }
        return null;
    }

    private boolean shouldSendCopyMail(Rechnung rn) {
        Kontakt guarantor = this.getGuarantor(rn);
        if (guarantor != null) {
            Fall fall = rn.getFall();
            return !fall.getInvoiceRecipient().equals((Object)guarantor);
        }
        return false;
    }

    public boolean canStorno(Rechnung rn) {
        return false;
    }

    public boolean canBill(Fall fall) {
        return true;
    }

    public Object createSettingsControl(Object parent) {
        this.qrs = new QR_SettingsControl((Composite)parent);
        return this.qrs;
    }

    public void customizeDialog(Object dialog) {
        if (dialog instanceof RnOutputDialog) {
            this.rnOutputDialog = (RnOutputDialog)dialog;
            this.rnOutputDialog.setOkButtonText(Messages.Core_Print);
            this.buttonOpen = this.rnOutputDialog.addCustomButton(Messages.Core_Open);
            RowData rowData = new RowData();
            rowData.width = 91;
            rowData.height = 26;
            this.buttonOpen.setLayoutData((Object)rowData);
            this.buttonOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QrRnOutputter.this.pdfOnly = true;
                    QrRnOutputter.this.rnOutputDialog.customButtonPressed(0);
                }
            });
            this.rnOutputDialog.redrawLayout();
        }
    }

    public void saveComposite() {
        this.qrs.doSave();
        LocalConfigService.set((String)"qrpdf-output/print.besr", (boolean)this.qrs.cbQRPage.getSelection());
        LocalConfigService.set((String)"qrpdf-output/print.rf", (boolean)this.qrs.cbTarmedForm.getSelection());
        if (!OutputterUtil.useGlobalOutputDirs()) {
            LocalConfigService.set((String)"qrpdf-output/xmldir", (String)this.qrs.tOutdirXML.getText());
            LocalConfigService.set((String)"qrpdf-output/pdfdir", (String)this.qrs.tOutdirPDF.getText());
        }
        LocalConfigService.flush();
    }

    public void openOutput(IInvoice invoice, LocalDateTime timestamp, InvoiceState invoiceState) {
        try {
            File esrFile = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)CFG_ROOT) + File.separator + invoice.getNumber() + "_esr.pdf").toFile().orElse(null);
            File rfFile = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)CFG_ROOT) + File.separator + invoice.getNumber() + "_rf.pdf").toFile().orElse(null);
            File qrFile = VirtualFilesystemServiceHolder.get().of(OutputterUtil.getPdfOutputDir((String)CFG_ROOT) + File.separator + invoice.getNumber() + "_qr.pdf").toFile().orElse(null);
            if (esrFile.exists()) {
                Program.launch((String)esrFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + esrFile.getAbsolutePath() + "] does not exist");
            }
            if (rfFile.exists()) {
                Program.launch((String)rfFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + rfFile.getAbsolutePath() + "] does not exist");
            }
            if (qrFile.exists()) {
                Program.launch((String)qrFile.getAbsolutePath());
            } else {
                LoggerFactory.getLogger(this.getClass()).info("File [" + qrFile.getAbsolutePath() + "] does not exist");
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error opening output", (Throwable)e);
        }
    }
}

