/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.pdf;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ch.BillingLaw;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.types.Gender;
import ch.elexis.data.PersistentObject;
import ch.elexis.ungrad.Util;
import ch.elexis.ungrad.pdf.Manager;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Medform {
    String form;
    Manager mgr = new Manager();
    IContextService contextService = ContextServiceHolder.get();
    Map<String, String> mapping = Stream.of({"patAddress", "topmostSubform[0].page1[0].patientS1Address[0].blockAddress[0]"}, {"patNameLine", "topmostSubform[0].page1[0].patientS1Address[0].condensedName[0]"}, {"patFirstname", "topmostSubform[0].page1[0].patientS1Address[0].firstName[0]"}, {"patLastname", "topmostSubform[0].page1[0].patientS1Address[0].lastName[0]"}, {"patBirthdate", "topmostSubform[0].page1[0].patientS1Address[0].birthDate[0]"}, {"patSex", "topmostSubform[0].page1[0].patientS1Address[0].sex[0]"}, {"patStreet", "topmostSubform[0].page1[0].patientS1Address[0].street[0]"}, {"patZip", "topmostSubform[0].page1[0].patientS1Address[0].zip[0]"}, {"patCity", "topmostSubform[0].page1[0].patientS1Address[0].city[0]"}, {"patAHV", "topmostSubform[0].page1[0].patientS1Address[0].ssn[0]"}, {"patPhone1", "topmostSubform[0].page1[0].patientS1Address[0].phone[0]"}, {"patPhone2", "topmostSubform[0].page1[0].patientS1Address[0].phone[1]"}, {"patMail", "topmostSubform[0].page1[0].patientS1Address[0].email[0]"}, {"docDate", "topmostSubform[0].page1[0].formS1Struct[0].modificationDate[0]"}, {"mandatorPhone1", "topmostSubform[0].page1[0].providerS1Address[0].phone[0]"}, {"mandatorMail", "topmostSubform[0].page1[0].providerS1Address[0].email[0]"}, {"mandatorFax", "topmostSubform[0].page1[0].providerS1Address[0].fax[0]"}, {"mandatorEAN", "topmostSubform[0].page1[0].providerS1Address[0].ean[0]"}, {"mandatorZSR", "topmostSubform[0].page1[0].providerS1Address[0].zsr[0]"}, {"mandatorNameLine", "topmostSubform[0].page2[0].providerS1Address[0].condensedName[0]"}, {"mandatorStreet", "topmostSubform[0].page2[0].providerS1Address[0].street[0]"}, {"mandatorZip", "topmostSubform[0].page2[0].providerS1Address[0].zip[0]"}, {"mandatorCity", "topmostSubform[0].page2[0].providerS1Address[0].city[0]"}, {"mandatorAddress", "topmostSubform[0].page1[0].providerS1Address[0].blockAddress[0]"}, {"insuranceCondensed", "topmostSubform[0].page1[0].insuranceS1Address[0].condensedName[0]"}, {"insuranceName", "topmostSubform[0].page1[0].insuranceS1Address[0].companyName[0]"}, {"insuranceStreet", "topmostSubform[0].page1[0].insuranceS1Address[0].street[0]"}, {"insuranceZip", "topmostSubform[0].page1[0].insuranceS1Address[0].zip[0]"}, {"insuranceCity", "topmostSubform[0].page1[0].insuranceS1Address[0].city[0]"}, {"insuranceMail", "topmostSubform[0].page1[0].insuranceS1Address[0].email[0]"}, {"insuranceCaseNr", "topmostSubform[0].page1[0].lawS1Struct[0].insuredID[0]"}, {"insuranceLaw", "topmostSubform[0].page1[0].lawS1Struct[0].type[0]"}, {"receiverMail", "topmostSubform[0].page1[0].consumerS1Address[0].email[0]"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));

    public Medform(String formpath) {
        this.form = formpath;
    }

    public boolean isMedform() {
        String oid;
        block3: {
            try {
                oid = this.mgr.getFieldContents(this.form, "topmostSubform[0].page1[0].formS1Struct[0].oid[0]");
                if (oid == null || !oid.startsWith("medforms")) break block3;
                return true;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                return false;
            }
        }
        oid = this.mgr.getFieldContents(this.form, "topmostSubform[0].page2[0].formS1Struct[0].oid[0]");
        return oid != null && oid.startsWith("medforms");
    }

    public String create(String outPath, IPatient pat) throws Exception {
        ICoverage cov;
        IMandator mand;
        HashMap<String, String> m = new HashMap<String, String>();
        if (pat != null) {
            m.put(this.get("patAddress"), pat.getPostalAddress());
            m.put(this.get("patFirstname"), pat.getFirstName());
            m.put(this.get("patLastname"), pat.getLastName());
            m.put(this.get("patBirthdate"), new TimeTool(pat.getDateOfBirth()).toString(4));
            m.put(this.get("patSex"), pat.getGender() == Gender.FEMALE ? "F" : "M");
            m.put(this.get("patStreet"), pat.getStreet());
            m.put(this.get("patZip"), pat.getZip());
            m.put(this.get("patCity"), pat.getCity());
            String[] phones = this.getPhones((IContact)pat);
            m.put(this.get("patPhone1"), phones[0]);
            m.put(this.get("patPhone2"), phones[1]);
            m.put(this.get("patMail"), pat.getEmail());
            m.put(this.get("patAHV"), PersistentObject.checkNull((Object)Util.getSSN((IPatient)pat)));
            m.put(this.get("docDate"), new TimeTool().toString(4));
        }
        if ((mand = (IMandator)this.contextService.getActiveMandator().orElseThrow()) != null) {
            m.put(this.get("mandatorAddress"), mand.getPostalAddress());
            m.put(this.get("mandatorNameLine"), mand.getDescription1() + " " + mand.getDescription2());
            String ean = (String)mand.getExtInfo((Object)"EAN");
            if (ean == null) {
                ean = (String)mand.getExtInfo((Object)"GLN");
            }
            if (ean == null) {
                ean = "";
            }
            m.put(this.get("mandatorEAN"), ean);
            String ksk = (String)mand.getExtInfo((Object)"KSK");
            if (ksk == null && (ksk = (String)mand.getExtInfo((Object)"ZSR")) == null) {
                ksk = "";
            }
            m.put(this.get("mandatorZSR"), ksk);
            m.put(this.get("mandatorStreet"), mand.getStreet());
            m.put(this.get("mandatorZip"), mand.getZip());
            m.put(this.get("mandatorCity"), mand.getCity());
            m.put(this.get("mandatorPhone1"), mand.getPhone1());
            m.put(this.get("mandatorMail"), mand.getEmail());
        }
        if ((cov = (ICoverage)this.contextService.getActiveCoverage().orElseThrow()) != null) {
            IContact cb = cov.getCostBearer();
            if (cb != null) {
                Object insurance = cb.getDescription1();
                if (!StringTool.isNothing((Object)cb.getDescription2())) {
                    insurance = (String)insurance + " " + cb.getDescription2();
                } else if (!StringTool.isNothing((Object)cb.getDescription3())) {
                    insurance = (String)insurance + " " + cb.getDescription3();
                }
                m.put(this.get("insuranceName"), (String)insurance);
                m.put(this.get("insuranceCondensed"), (String)insurance);
                m.put(this.get("insuranceStreet"), StringTool.unNull((String)cb.getStreet()));
                m.put(this.get("insuranceZip"), StringTool.unNull((String)cb.getZip()));
                m.put(this.get("insuranceCity"), StringTool.unNull((String)cb.getCity()));
                m.put(this.get("insuranceMail"), StringTool.unNull((String)cb.getEmail()));
            }
            BillingLaw bl = cov.getBillingSystem().getLaw();
            String nr = cov.getInsuranceNumber();
            if (StringTool.isNothing((Object)nr)) {
                nr = (String)cov.getExtInfo((Object)"Versicherungsnummer");
            }
            if (StringTool.isNothing((Object)nr)) {
                nr = (String)cov.getExtInfo((Object)"Unfallnummer");
            }
            m.put(this.get("insuranceCaseNr"), StringTool.unNull((String)nr));
            m.put(this.get("insuranceLaw"), bl.toString());
        }
        return this.mgr.fillForm(this.form, outPath, m);
    }

    private String[] getPhones(IContact k) {
        String p1 = k.getPhone1();
        String p2 = k.getPhone2();
        String p3 = k.getMobile();
        String[] ret = new String[2];
        if (!StringTool.isNothing((Object)p3)) {
            ret[0] = p3;
            ret[1] = !StringTool.isNothing((Object)p1) && !p1.equals(p3) ? p1 : (!StringTool.isNothing((Object)p2) && !p2.equals(p3) ? p2 : "");
        } else if (!StringTool.isNothing((Object)p1)) {
            ret[0] = p1;
            ret[1] = !StringTool.isNothing((Object)p2) && !p1.equals(p2) ? p2 : "";
        } else {
            ret[1] = "";
            ret[0] = !StringTool.isNothing((Object)p3) ? p3 : "";
        }
        return ret;
    }

    public String get(String field) throws Exception {
        String ret = this.mapping.get(field);
        if (ret == null) {
            throw new Exception(field + " is not mapped");
        }
        return ret;
    }

    public String getFieldValue(String name) {
        try {
            String medformsField = this.get(name);
            return this.mgr.getFieldContents(this.form, medformsField);
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            return "";
        }
    }
}

