/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.pdf;

import ch.rgw.tools.StringTool;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaSizeName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.printing.PDFPrintable;

public class Manager {
    public String fillForm(String formpath, String outputPath, Map<String, String> fields) throws Exception {
        try (PDDocument pdfDoc = null;){
            FileInputStream resource = new FileInputStream(formpath);
            pdfDoc = PDDocument.load((InputStream)resource);
            PDDocumentCatalog docCatalog = pdfDoc.getDocumentCatalog();
            pdfDoc.getDocumentInformation().setCreator("Elexis Ungrad");
            pdfDoc.getDocumentInformation().setCustomMetadataValue("concern", "Forms");
            PDAcroForm acroForm = docCatalog.getAcroForm();
            for (Map.Entry<String, String> e : fields.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                PDField pdField = acroForm.getField(key);
                if (pdField == null) continue;
                try {
                    pdField.setValue(value);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            pdfDoc.save(outputPath);
            ((InputStream)resource).close();
            acroForm = null;
            String string = outputPath;
            return string;
        }
    }

    public String getFieldContents(String formPath, String fieldName) throws Exception {
        PDDocument pdfDoc = PDDocument.load((File)new File(formPath));
        PDDocumentCatalog docCatalog = pdfDoc.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        PDField pdField = acroForm.getField(fieldName);
        if (pdField != null) {
            try {
                String val = pdField.getValueAsString();
                return val;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public void createPDF(File inputHtml, File outputFile) throws FileNotFoundException, IOException, PrinterException {
        FileOutputStream fout = new FileOutputStream(outputFile);
        PdfRendererBuilder builder = ((PdfRendererBuilder)((PdfRendererBuilder)new PdfRendererBuilder().useFastMode()).withFile(inputHtml)).withProducer("Elexis Ungrad");
        builder.toStream((OutputStream)fout);
        builder.run();
        fout.close();
        builder = null;
    }

    public boolean printFromPDF(File pdfFile, String printer) throws IOException, PrinterException {
        PDDocument pdoc = PDDocument.load((File)pdfFile);
        PDFPrintable printable = new PDFPrintable(pdoc);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable((Printable)printable);
        boolean printed = false;
        if (!StringTool.isNothing((Object)printer)) {
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            int selectedService = 0;
            int i = 0;
            while (i < services.length) {
                if (services[i].getName().toLowerCase().contains(printer.toLowerCase())) {
                    selectedService = i;
                    services[i].getAttributes();
                    break;
                }
                ++i;
            }
            job.setPrintService(services[selectedService]);
            HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
            attrs.add(MediaSizeName.ISO_A4);
            job.print(attrs);
            printed = true;
        } else if (job.printDialog()) {
            job.print();
            printed = true;
        }
        pdoc.close();
        return printed;
    }

    public boolean printFromHTML(File htmlFle, String printer, boolean bKeepHtml, boolean bKeepPdf) {
        return false;
    }
}

