/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.views;

import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.Importer;
import ch.elexis.core.ui.util.Log;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.ungrad.labview.Messages;
import ch.elexis.ungrad.labview.controller.Controller;
import jakarta.inject.Inject;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LaborView
extends ViewPart
implements IRefreshable {
    Controller controller = new Controller(this);
    Log log = Log.get((String)"LaborView");
    CTabFolder cTabFolder;
    private IContextService ctx = ContextServiceHolder.get();
    private Action exportHtmlAction;
    private Action viewInBrowserAction;
    private Action importAction;
    private Action removeEmptyItemsAction;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener((ViewPart)this);

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (patient != null) {
                try {
                    this.controller.setPatient(patient);
                }
                catch (ElexisException e) {
                    e.printStackTrace();
                }
            }
        }, (Object)this.cTabFolder);
    }

    public void createPartControl(Composite parent) {
        this.cTabFolder = new CTabFolder(parent, 1024);
        this.cTabFolder.setLayoutData((Object)SWTHelper.getFillGridData());
        CTabItem ctSmart = new CTabItem(this.cTabFolder, 0);
        ctSmart.setText(Messages.LaborView_Tab_Compact);
        ctSmart.setControl(this.controller.createSmartControl(this.cTabFolder));
        CTabItem ctSummary = new CTabItem(this.cTabFolder, 0);
        ctSummary.setText(Messages.LaborView_Tab_Synopsis);
        CTabItem ctFull = new CTabItem(this.cTabFolder, 0);
        ctFull.setText(Messages.LaborView_Tab_Full);
        Control ctlSummary = this.controller.createSummaryControl(this.cTabFolder);
        ctSummary.setControl(ctlSummary);
        Control ctlFull = this.controller.createFullControl(this.cTabFolder);
        ctFull.setControl(ctlFull);
        this.cTabFolder.setSelection(ctSmart);
        this.makeActions();
        this.contributeToActionBars();
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
        this.controller.loadState();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.exportHtmlAction);
        manager.add((IAction)this.viewInBrowserAction);
        manager.add((IAction)this.importAction);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.exportHtmlAction);
        manager.add((IAction)this.removeEmptyItemsAction);
    }

    public void setFocus() {
    }

    public void refresh() {
        try {
            this.controller.setPatient(this.ctx.getActivePatient().orElse(null));
        }
        catch (ElexisException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        this.controller.dispose();
    }

    private void makeActions() {
        this.exportHtmlAction = new Action(){
            {
                this.setImageDescriptor(Images.IMG_WEB.getImageDescriptor());
                this.setToolTipText(Messages.LaborView_Action_Export_Tooltip);
            }

            public void run() {
                LaborView.this.controller.getExporter().createHTML((Composite)LaborView.this.getSite().getShell());
            }
        };
        this.viewInBrowserAction = new Action(){
            {
                this.setImageDescriptor(Images.IMG_EYE_WO_SHADOW.getImageDescriptor());
                this.setToolTipText(Messages.LaborView_Action_ViewBrowser_Tooltip);
            }

            public void run() {
                LaborView.this.controller.getExporter().runInBrowser();
            }
        };
        this.importAction = new Action(Messages.LaborView_Action_Import_Title){
            {
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
                this.setToolTipText(Messages.LaborView_Action_Import_Tooltip);
            }

            public void run() {
                Importer imp = new Importer(LaborView.this.getViewSite().getShell(), "ch.elexis.core.ui.LaborDatenImport");
                imp.create();
                imp.setMessage(Messages.LaborView_Action_Import_Message);
                imp.getShell().setText(Messages.LaborView_Action_Import_ShellTitle);
                imp.setTitle(Messages.LaborView_Action_Import_DialogTitle);
                imp.open();
            }
        };
        this.removeEmptyItemsAction = new Action(Messages.LaborView_Action_Cleanup_Title){
            {
                this.setToolTipText(Messages.LaborView_Action_Cleanup_Tooltip);
                Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/edit-clear24.png"), null);
                this.setImageDescriptor(ImageDescriptor.createFromURL((URL)url));
            }

            public void run() {
                if (SWTHelper.askYesNo((String)Messages.LaborView_Action_Cleanup_DialogTitle, (String)Messages.LaborView_Action_Cleanup_DialogMessage)) {
                    LaborView.this.controller.purgeLabItems();
                }
            }
        };
    }
}

