/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.model;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.util.Log;
import ch.elexis.data.PersistentObject;
import ch.elexis.ungrad.IObserver;
import ch.elexis.ungrad.Util;
import ch.elexis.ungrad.labview.model.Bucket;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.LabResultsRow;
import ch.elexis.ungrad.labview.model.Result;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class LabResultsSheet {
    Log log = Log.get((String)"LabResultSheet");
    private static final String queryItems = "SELECT ID, titel,kuerzel,Gruppe,prio,RefMann,RefFrauOrTx,Typ, Einheit FROM LABORITEMS WHERE deleted='0'";
    private static final String queryResults = "SELECT ID, ItemID, Datum, Zeit, Resultat, Kommentar FROM LABORWERTE where PatientID=? AND deleted='0'";
    IPatient pat;
    TimeTool[] dateArray;
    Map<Item, Bucket> recently;
    Map<Item, Bucket> lastYear;
    Map<Item, Bucket> older;
    JdbcLink j;
    Map<String, Item> allItemsByID;
    Map<String, List<Item>> groups;
    SortedMap<Item, LabResultsRow> itemsWithResults = new TreeMap<Item, LabResultsRow>();
    SortedSet<TimeTool> resultDates = new TreeSet<TimeTool>();
    List<IObserver> observers = new ArrayList<IObserver>();
    TimeTool oneMonth = new TimeTool();
    TimeTool oneYear = new TimeTool();

    public LabResultsSheet() {
        this.j = PersistentObject.getConnection();
        this.oneMonth.addDays(-30);
        this.oneYear.addDays(-365);
    }

    public void setPatient(IPatient pat) throws ElexisException {
        this.pat = pat;
        this.loadItems(false);
        if (pat == null) {
            this.dateArray = null;
            this.itemsWithResults = null;
        } else {
            this.fetch();
        }
        for (IObserver o : this.observers) {
            o.signal((Object)pat);
        }
    }

    public void reload() throws ElexisException {
        this.loadItems(true);
        this.setPatient(this.pat);
    }

    public String[] getAllGroups() {
        return this.groups.keySet().toArray(new String[0]);
    }

    public Item[] getAllItemsForGroup(String group) {
        Util.require((group != null ? 1 : 0) != 0, (String)"group must not be null");
        List<Item> items = this.groups.get(group);
        if (items == null) {
            return new Item[0];
        }
        Collections.sort(items);
        return items.toArray(new Item[0]);
    }

    public void addObserver(IObserver obs) {
        Util.require((obs != null ? 1 : 0) != 0, (String)"Observer must not be null");
        this.observers.add(obs);
    }

    public void removeObserver(IObserver obs) {
        Util.require((obs != null ? 1 : 0) != 0, (String)"Observer must not be null");
        this.observers.remove(obs);
    }

    public Item[] getItems() {
        if (this.allItemsByID == null) {
            try {
                this.loadItems(true);
            }
            catch (ElexisException e) {
                this.log.log((Throwable)e, "could not load LabItems", 2);
            }
        }
        ArrayList<Item> list = new ArrayList<Item>(this.allItemsByID.size());
        for (Item it : this.allItemsByID.values()) {
            list.add(it);
        }
        Collections.sort(list);
        return list.toArray(new Item[0]);
    }

    public LabResultsRow[] getLabResults() {
        return this.itemsWithResults == null ? null : this.itemsWithResults.values().toArray(new LabResultsRow[0]);
    }

    public Bucket getRecentBucket(Item item) {
        return this.recently.getOrDefault(item, new Bucket(item));
    }

    public Bucket getOneYearBucket(Item item) {
        return this.lastYear.getOrDefault(item, new Bucket(item));
    }

    public Bucket getOlderBucket(Item item) {
        return this.older.getOrDefault(item, new Bucket(item));
    }

    public Result getValue(int nRow, int nColumn) {
        if (nColumn < 0 || this.dateArray == null || nColumn >= this.dateArray.length) {
            return null;
        }
        TimeTool date = this.dateArray[nColumn];
        LabResultsRow row = (LabResultsRow)this.itemsWithResults.values().toArray()[nRow];
        for (Result res : row.results) {
            if (!res.get("datum").equals(date.toString(9))) continue;
            return res;
        }
        return null;
    }

    public TimeTool[] getDates() {
        return this.dateArray;
    }

    private void loadItems(boolean bReload) throws ElexisException {
        if (bReload) {
            this.allItemsByID = null;
        }
        if (this.allItemsByID == null) {
            PreparedStatement psItems = this.j.getPreparedStatement(queryItems);
            try {
                try {
                    ResultSet res = psItems.executeQuery();
                    this.allItemsByID = new HashMap<String, Item>();
                    this.groups = new TreeMap<String, List<Item>>();
                    while (res.next()) {
                        Item item = new Item(res);
                        List<Item> itemsInGroup = this.groups.get(item.get("gruppe"));
                        if (itemsInGroup == null) {
                            itemsInGroup = new ArrayList<Item>();
                        }
                        itemsInGroup.add(item);
                        this.groups.put(item.get("gruppe"), itemsInGroup);
                        this.allItemsByID.put(item.get("id"), item);
                    }
                }
                catch (SQLException ex) {
                    throw new ElexisException("can't fetch Lab Items", (Throwable)ex);
                }
            }
            finally {
                this.j.releasePreparedStatement(psItems);
            }
        }
    }

    private void fetch() throws ElexisException {
        this.loadItems(false);
        this.resultDates.clear();
        PreparedStatement ps = this.j.getPreparedStatement(queryResults);
        this.itemsWithResults = new TreeMap<Item, LabResultsRow>();
        this.recently = new TreeMap<Item, Bucket>();
        this.lastYear = new TreeMap<Item, Bucket>();
        this.older = new TreeMap<Item, Bucket>();
        if (this.pat != null) {
            try {
                try {
                    ps.setString(1, this.pat.getId());
                    ResultSet res = ps.executeQuery();
                    while (res.next()) {
                        Result result = new Result(res);
                        this.addResult(result);
                    }
                    this.dateArray = this.resultDates.toArray(new TimeTool[0]);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ElexisException("error reading database", (Throwable)e);
                }
            }
            finally {
                this.j.releasePreparedStatement(ps);
            }
        }
    }

    public void addResult(Result result) {
        Bucket bucket;
        Item item = this.allItemsByID.get(result.get("itemId"));
        if (item == null) {
            item = new Item("?");
        }
        TimeTool when = new TimeTool(result.get("datum"));
        this.resultDates.add(when);
        if (when.isBefore(this.oneYear)) {
            bucket = this.older.get(item);
            if (bucket == null) {
                bucket = new Bucket(item);
                this.older.put(item, bucket);
            }
        } else if (when.isBeforeOrEqual(this.oneMonth)) {
            bucket = this.lastYear.get(item);
            if (bucket == null) {
                bucket = new Bucket(item);
                this.lastYear.put(item, bucket);
            }
        } else {
            bucket = this.recently.get(item);
            if (bucket == null) {
                bucket = new Bucket(item);
                this.recently.put(item, bucket);
            }
        }
        bucket.addResult(result);
        LabResultsRow row = (LabResultsRow)this.itemsWithResults.get(item);
        if (row == null && this.pat != null) {
            row = new LabResultsRow(item, this.pat);
            this.itemsWithResults.put(item, row);
        }
        row.add(result);
    }

    public Object[] getGroups() {
        TreeSet groups = new TreeSet();
        this.itemsWithResults.keySet().forEach(key -> {
            String grp = key.get("gruppe");
            groups.add(grp != null ? grp : "-");
        });
        return groups.toArray();
    }

    @NonNull
    public Object[] getRowsForGroup(String group) {
        Util.require((group != null ? 1 : 0) != 0, (String)"group must not be null");
        ArrayList results = new ArrayList();
        this.itemsWithResults.keySet().forEach(key -> {
            if (key.get("gruppe").equals(group)) {
                LabResultsRow r = (LabResultsRow)this.itemsWithResults.get(key);
                if (r == null) {
                    this.log.log("Null value for " + key.get("Titel"), 2);
                } else {
                    results.add((LabResultsRow)this.itemsWithResults.get(key));
                }
            }
        });
        Collections.sort(results);
        return results.toArray();
    }

    public String getNormRange(Item item) {
        if (!this.pat.getGender().equals((Object)Gender.MALE)) {
            return item.get("refFrauOrTx");
        }
        return item.get("refMann");
    }

    public boolean isPathologic(Item item, Result result) {
        if (item == null || result == null || this.pat == null) {
            return false;
        }
        return item.isPathologic(this.pat, result.get("resultat"));
    }

    public Result getResultForDate(Item item, TimeTool date) {
        LabResultsRow row = (LabResultsRow)this.itemsWithResults.get(item);
        if (row == null) {
            return null;
        }
        return row.get(date);
    }
}

