/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.model;

import ch.elexis.core.model.IPatient;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.Result;
import ch.rgw.tools.TimeTool;
import java.util.SortedSet;
import java.util.TreeSet;

public class LabResultsRow
implements Comparable<LabResultsRow> {
    Item item;
    IPatient patient;
    SortedSet<Result> results;

    public LabResultsRow(Item item, IPatient pat) {
        this.item = item;
        this.results = new TreeSet<Result>();
        this.patient = pat;
    }

    public void add(Result result) {
        this.results.add(result);
    }

    public Result get(int index) {
        if (this.results.size() > index) {
            return (Result)this.results.toArray()[index];
        }
        return null;
    }

    public Result get(TimeTool date) {
        for (Result res : this.results) {
            if (!new TimeTool(res.get("datum")).isEqual(date)) continue;
            return res;
        }
        return null;
    }

    public Result[] getResults() {
        return this.results.toArray(new Result[0]);
    }

    public Item getItem() {
        return this.item;
    }

    public IPatient getPatient() {
        return this.patient;
    }

    @Override
    public int compareTo(LabResultsRow r) {
        return this.item.compareTo(r.item);
    }

    public boolean hasRelevantResults() {
        TimeTool now = new TimeTool();
        now.add(10, -8760);
        TimeTool cmp = new TimeTool();
        for (Result result : this.results) {
            if (!cmp.set(result.get("datum")) || !cmp.isAfter(now) || !this.item.isPathologic(this.patient, result.get("resultat"))) continue;
            return true;
        }
        return false;
    }

    public Result[] getBoundsBefore(TimeTool limit) {
        limit.toString(4);
        Result[] minmax = new Result[2];
        float min = Float.MAX_VALUE;
        float max = 0.0f;
        for (Result result : this.results) {
            TimeTool date = new TimeTool(result.get("datum"));
            date.toString(4);
            if (!date.isBefore(limit)) continue;
            float cmp = Item.makeFloat((String)result.get("resultat"));
            if (cmp > max) {
                max = cmp;
                minmax[1] = result;
            }
            if (!(cmp < min)) continue;
            min = cmp;
            minmax[0] = result;
        }
        return minmax;
    }
}

