/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.model;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.types.Gender;
import ch.elexis.ungrad.SimpleObject;
import ch.rgw.tools.StringTool;
import java.sql.ResultSet;

public class Item
extends SimpleObject
implements Comparable<Item> {
    static final int LOWER_BOUND_MALE = 0;
    static final int UPPER_BOUND_MALE = 1;
    static final int LOWER_BOUND_FEMALE = 2;
    static final int UPPER_BOUND_FEMALE = 3;
    private static final String[] fields = new String[]{"ID", "titel", "kuerzel", "Gruppe", "prio", "RefMann", "RefFrauOrTx", "Typ", "Einheit"};
    private float[] refBounds = new float[4];

    public String[] getFields() {
        return fields;
    }

    public float[] getRefRange() {
        return this.refBounds;
    }

    public Item(ResultSet res) {
        this.load(res);
        if (this.get("typ") == null) {
            this.set("typ", "NULL");
        }
        if (this.get("typ").equals("0")) {
            this.makeBounds(this.get("refMann"), 0);
            this.makeBounds(this.get("refFrauOrTx"), 2);
        }
    }

    public Item(String id) {
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            this.props.put(field.toLowerCase(), "?");
            ++n2;
        }
    }

    private void makeBounds(String val, int index) {
        if (!StringTool.isNothing((Object)val)) {
            String chopped = val.replaceAll("\\s", "");
            if (chopped.startsWith("<")) {
                this.refBounds[index] = 0.0f;
                this.refBounds[index + 1] = Item.makeFloat((String)chopped.substring(1));
            } else if (chopped.startsWith(">")) {
                this.refBounds[index] = Item.makeFloat((String)chopped.substring(1));
                this.refBounds[index + 1] = Float.MAX_VALUE;
            } else {
                String[] bounds = chopped.split("-");
                if (bounds.length > 0) {
                    this.refBounds[index] = Item.makeFloat((String)bounds[0]);
                    if (bounds.length == 2) {
                        this.refBounds[index + 1] = Item.makeFloat((String)bounds[1]);
                    }
                }
            }
        }
    }

    public boolean isPathologic(IPatient pat, String value) {
        if (value == null) {
            return false;
        }
        String chopped = value.trim();
        float val = 0.0f;
        val = chopped.startsWith("<") ? 0.0f : (chopped.startsWith(">") ? 2.1474836E9f : Item.makeFloat((String)chopped));
        int index = 0;
        if (!pat.getGender().equals((Object)Gender.MALE)) {
            index = 2;
        }
        return val < this.refBounds[index] || val > this.refBounds[index + 1];
    }

    @Override
    public int compareTo(Item o) {
        int gcomp = this.compare(o, "gruppe");
        return gcomp == 0 ? this.compare(o, "prio") : gcomp;
    }

    public boolean isEqual(Item o) {
        String u = this.get("einheit");
        String ou = o.get("einheit");
        if (u == null && ou != null) {
            return false;
        }
        if (u != null && ou == null) {
            return false;
        }
        if (o == null || o.equals(ou)) {
            int i = 0;
            while (i < this.refBounds.length) {
                if (this.refBounds[i] != o.refBounds[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

