/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.smart;

import ch.elexis.core.model.IPatient;
import ch.elexis.ungrad.IObserver;
import ch.elexis.ungrad.labview.controller.Controller;
import ch.elexis.ungrad.labview.controller.smart.SmartContentProvider;
import ch.elexis.ungrad.labview.controller.smart.SmartTreeColumns;
import ch.elexis.ungrad.labview.model.LabResultsSheet;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartViewController
implements IObserver {
    TreeViewer tvSmart;
    Controller controller;
    SmartTreeColumns stc;
    Logger log = LoggerFactory.getLogger(this.getClass());
    SmartContentProvider scp;

    public SmartViewController(Controller parent) {
        this.controller = parent;
        this.scp = new SmartContentProvider(this.controller.getLRS());
        LabResultsSheet lrs = this.controller.getLRS();
        lrs.addObserver(this);
    }

    public void signal(Object message) {
        if (message instanceof IPatient) {
            this.stc.saveColLayout();
            this.stc.reload(this.controller);
            this.tvSmart.setInput(message);
        }
    }

    public LabResultsSheet getLRS() {
        return this.controller.getLRS();
    }

    public Control createControl(Composite parent) {
        this.tvSmart = new TreeViewer(parent);
        this.tvSmart.setContentProvider((IContentProvider)this.scp);
        this.tvSmart.setUseHashlookup(true);
        Tree tree = this.tvSmart.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.stc = new SmartTreeColumns(this.tvSmart);
        this.tvSmart.setAutoExpandLevel(2);
        this.tvSmart.setInput((Object)this.scp);
        return tree;
    }

    public void dispose() {
        this.controller.getLRS().removeObserver(this);
    }

    public String getState() {
        this.stc.saveColLayout();
        StringBuilder ret = new StringBuilder();
        int[] nArray = this.stc.widths;
        int n = this.stc.widths.length;
        int n2 = 0;
        while (n2 < n) {
            int w = nArray[n2];
            ret.append(Integer.toString(w)).append(",");
            ++n2;
        }
        return ret.substring(0, ret.length() - 1);
    }

    public void setState(String parms) {
        if (parms != null && parms.length() > 1) {
            String[] cols = parms.split(",");
            int[] icols = new int[cols.length];
            int i = 0;
            while (i < cols.length) {
                try {
                    int size;
                    icols[i] = size = Integer.parseInt(cols[i]);
                }
                catch (NumberFormatException nex) {
                    this.log.error("Bad number format in saved state ", (Throwable)nex);
                }
                ++i;
            }
            this.stc.setColWidths(icols);
        }
    }
}

