/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.full;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.elexis.data.Query;
import ch.elexis.ungrad.IObserver;
import ch.elexis.ungrad.labview.controller.Controller;
import ch.elexis.ungrad.labview.controller.full.FullContentProvider;
import ch.elexis.ungrad.labview.controller.full.FullDisplayTreeColumns;
import ch.elexis.ungrad.labview.controller.full.LabItemPropertiesDlg;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.LabResultsSheet;
import ch.elexis.ungrad.labview.model.Result;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullViewController
implements IObserver {
    TreeViewer tvFull;
    Controller controller;
    FullDisplayTreeColumns fdtc;
    TreeViewerFocusCellManager focusManager;
    TextCellEditor tce;
    private Action organizeItemAction;
    private Action toGroupAction;
    private Action combineAction;
    private Action sortAction;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public FullViewController(Controller parent) {
        this.controller = parent;
        this.organizeItemAction = new Action("Eigenschaften"){
            {
                this.setImageDescriptor(Images.IMG_ARROWDOWNTORECT.getImageDescriptor());
                this.setToolTipText("Eigenschaften des Labor Items \u00e4ndern");
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)FullViewController.this.tvFull.getSelection();
                Item item = (Item)sel.getFirstElement();
                LabItemPropertiesDlg dlg = new LabItemPropertiesDlg(item);
                dlg.create();
                if (dlg.open() == 0) {
                    FullViewController.this.reload();
                }
            }
        };
        this.toGroupAction = new Action("Zu Gruppe..."){
            {
                this.setImageDescriptor(Images.IMG_MOVETOUPPERLIST.getImageDescriptor());
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)FullViewController.this.tvFull.getSelection();
                int num = sel.size();
                final String[] allGroups = FullViewController.this.getLRS().getAllGroups();
                InputDialog dlg = new InputDialog(FullViewController.this.tvFull.getTree().getShell(), "LaborItems verschieben", "Bitte Zielgruppe angeben (" + num + " Items gew\u00e4hlt)", "ZZ", new IInputValidator(){

                    public String isValid(String newText) {
                        int hits = 0;
                        String[] stringArray = allGroups;
                        int n = allGroups.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String group = stringArray[n2];
                            if (group.startsWith(newText)) {
                                ++hits;
                            }
                            ++n2;
                        }
                        if (hits == 0) {
                            return "Gruppe nicht vorhanden";
                        }
                        if (hits == 1) {
                            return null;
                        }
                        return "Gruppe nicht eindeutig.";
                    }
                });
                if (dlg.open() == 0) {
                    String result = dlg.getValue();
                    String[] stringArray = allGroups;
                    int n = allGroups.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String group = stringArray[n2];
                        if (group.startsWith(result)) {
                            FullViewController.this.doMove(sel.toArray(), group);
                        }
                        ++n2;
                    }
                    FullViewController.this.reload();
                }
            }
        };
        this.combineAction = new Action("Items zusammenf\u00fchren"){
            {
                this.setImageDescriptor(Images.IMG_MOVETOLOWERLIST.getImageDescriptor());
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)FullViewController.this.tvFull.getSelection();
                if (SWTHelper.askYesNo((String)"Items kombinieren", (String)("Wollen Sie wirklich diese " + sel.size() + " Items kombinieren?"))) {
                    FullViewController.this.doCombine(sel.toArray());
                    FullViewController.this.reload();
                }
            }
        };
        this.sortAction = new Action("Neu sortieren"){
            {
                this.setImageDescriptor(Images.IMG_SORT_STAR.getImageDescriptor());
                this.setToolTipText("Items dieser Gruppe neu sortieren");
            }

            public void run() {
                String group = (String)((IStructuredSelection)FullViewController.this.tvFull.getSelection()).getFirstElement();
                Item[] items = FullViewController.this.getLRS().getAllItemsForGroup(group);
                Arrays.sort(items, new Comparator<Item>(){

                    @Override
                    public int compare(Item o1, Item o2) {
                        int n = o1.get("titel").compareTo(o2.get("titel"));
                        if (n == 0) {
                            n = o2.get("kuerzel").compareTo(o2.get("kuerzel"));
                        }
                        return n;
                    }
                });
                int i = 0;
                while (i < items.length) {
                    String prio = StringTool.pad((int)1, (char)'0', (String)Integer.toString(10 * i + 10), (int)3);
                    LabItem li = LabItem.load((String)items[i].get("id"));
                    li.set("prio", prio);
                    ++i;
                }
                FullViewController.this.reload();
            }
        };
    }

    private void doMove(Object[] objects, String group) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Item item;
            String id;
            LabItem li;
            Object o = objectArray[n2];
            if (o instanceof Item && (li = LabItem.load((String)(id = (item = (Item)o).get("id")))) != null && li.isValid()) {
                li.set("Gruppe", group);
            }
            ++n2;
        }
        this.reload();
    }

    private void reload() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    FullViewController.this.getLRS().reload();
                }
                catch (ElexisException eex) {
                    FullViewController.this.log.error("could not reload LabItems " + eex.getMessage(), (Throwable)eex);
                }
            }
        });
    }

    private void doCombine(Object[] objects) {
        Item target = (Item)objects[0];
        LabItem targetLI = LabItem.load((String)target.get("id"));
        this.log.info("combining " + objects.length + " LabItems into " + targetLI.getLabel());
        if (targetLI != null && targetLI.isValid()) {
            int i = 1;
            while (i < objects.length) {
                Item it = (Item)objects[i];
                LabItem li = LabItem.load((String)it.get("id"));
                this.log.info("processing " + li.getLabel());
                Query qbe = new Query(LabResult.class);
                qbe.add("ItemID", "=", li.getId());
                List lrs = qbe.execute();
                if (SWTHelper.askYesNo((String)"Laborresultate zusammenf\u00fchren", (String)("Wirklich " + lrs.size() + " Resultate aus " + li.getLabel() + " nach " + targetLI.getLabel() + " verschieben?"))) {
                    for (LabResult lr : lrs) {
                        this.log.debug("converting " + lr.getLabel());
                        lr.set("ItemID", targetLI.getId());
                    }
                    li.delete();
                }
                ++i;
            }
        }
    }

    public LabResultsSheet getLRS() {
        return this.controller.getLRS();
    }

    public Control createControl(Composite parent) {
        this.tvFull = new TreeViewer(parent);
        Tree tree = this.tvFull.getTree();
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.tvFull.setContentProvider((IContentProvider)new FullContentProvider(this.controller.getLRS()));
        this.fdtc = new FullDisplayTreeColumns(this);
        this.tce = new TextCellEditor((Composite)tree);
        this.focusManager = new TreeViewerFocusCellManager(this.tvFull, new FocusCellHighlighter((ColumnViewer)this.tvFull){});
        this.controller.getLRS().addObserver(this);
        this.tvFull.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)FullViewController.this.tvFull.getSelection();
                FullViewController.this.organizeItemAction.setEnabled(false);
                FullViewController.this.toGroupAction.setEnabled(false);
                FullViewController.this.combineAction.setEnabled(false);
                FullViewController.this.sortAction.setEnabled(false);
                if (sel.size() == 1) {
                    if (sel.getFirstElement() instanceof String) {
                        FullViewController.this.sortAction.setEnabled(true);
                    } else {
                        FullViewController.this.organizeItemAction.setEnabled(true);
                        FullViewController.this.toGroupAction.setEnabled(true);
                    }
                } else if (sel.size() == 2) {
                    if (!FullViewController.this.hasGroup(sel.toArray()).booleanValue()) {
                        FullViewController.this.toGroupAction.setEnabled(true);
                        FullViewController.this.combineAction.setEnabled(true);
                    }
                } else {
                    Object[] objects = sel.toArray();
                    Item cmb = null;
                    boolean tgPossible = true;
                    boolean cmPossible = true;
                    if (FullViewController.this.hasGroup(objects).booleanValue()) {
                        tgPossible = false;
                        cmPossible = false;
                    } else {
                        Object[] objectArray = objects;
                        int n = objects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object o = objectArray[n2];
                            Item item = (Item)o;
                            if (cmb != null && !cmb.isEqual(item)) {
                                cmPossible = false;
                                break;
                            }
                            cmb = item;
                            ++n2;
                        }
                    }
                    if (tgPossible) {
                        FullViewController.this.toGroupAction.setEnabled(true);
                    }
                    if (cmPossible) {
                        FullViewController.this.combineAction.setEnabled(true);
                    }
                }
            }
        });
        this.tvFull.getTree().setMenu(this.createContextMenu((Control)this.tvFull.getTree()));
        return tree;
    }

    private Boolean hasGroup(Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void signal(Object message) {
        if (message instanceof IPatient) {
            this.fdtc.reload();
            this.tvFull.setInput(message);
        }
    }

    private Menu createContextMenu(Control parent) {
        final MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                mgr.add((IAction)FullViewController.this.sortAction);
                mgr.add((IAction)FullViewController.this.organizeItemAction);
                mgr.add((IAction)FullViewController.this.toGroupAction);
                mgr.add((IAction)FullViewController.this.combineAction);
            }
        });
        return mgr.createContextMenu(parent);
    }

    EditingSupport createEditingSupportFor(TreeViewerColumn tvc, final TimeTool colDate) {
        return new EditingSupport((ColumnViewer)this.tvFull){

            protected void setValue(Object element, Object value) {
                if (element instanceof Item) {
                    Result result = FullViewController.this.getLRS().getResultForDate((Item)element, colDate);
                    if (result == null) {
                        result = new Result(0.0f);
                    }
                    result.set("resultat", (String)value);
                    result.set("ItemID", ((Item)element).get("ID"));
                    result.set("Datum", colDate.toString(9));
                    result.set("Zeit", colDate.toString(3));
                    FullViewController.this.getLRS().addResult(result);
                    FullViewController.this.tvFull.update(element, null);
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof Item) {
                    Result result = FullViewController.this.getLRS().getResultForDate((Item)element, colDate);
                    if (result == null) {
                        result = new Result(0.0f);
                    }
                    return result.get("resultat");
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return FullViewController.this.tce;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Item;
            }
        };
    }

    public void dispose() {
        this.controller.getLRS().removeObserver(this);
    }

    public String getState() {
        return "";
    }

    public void setState(String string) {
    }
}

