/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.full;

import ch.elexis.ungrad.labview.controller.DateResultLabelProvider;
import ch.elexis.ungrad.labview.controller.ItemRangeLabelProvider;
import ch.elexis.ungrad.labview.controller.ItemTextLabelProvider;
import ch.elexis.ungrad.labview.controller.full.FullViewController;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.widgets.TreeColumn;

public class FullDisplayTreeColumns {
    TreeViewerColumn[] cols;
    String[] headings = new String[]{"Parameter", "Referenz"};
    int[] widths = new int[]{150, 120};
    FullViewController ctl;

    public FullDisplayTreeColumns(FullViewController controller) {
        this.ctl = controller;
    }

    public void reload() {
        TreeColumn[] treeColumnArray = this.ctl.tvFull.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn tc = treeColumnArray[n2];
            tc.dispose();
            ++n2;
        }
        TimeTool[] dates = this.ctl.getLRS().getDates();
        this.cols = new TreeViewerColumn[dates.length + 2];
        int i = 0;
        while (i < 2) {
            this.cols[i] = new TreeViewerColumn(this.ctl.tvFull, 0);
            this.cols[i].getColumn().setText(this.headings[i]);
            this.cols[i].getColumn().setWidth(this.widths[i]);
            ++i;
        }
        this.cols[0].setLabelProvider((CellLabelProvider)new ItemTextLabelProvider());
        this.cols[1].setLabelProvider((CellLabelProvider)new ItemRangeLabelProvider(this.ctl.getLRS()));
        i = dates.length - 1;
        while (i > -1) {
            this.cols[i + 2] = new TreeViewerColumn(this.ctl.tvFull, 0);
            this.cols[i + 2].getColumn().setText(dates[i].toString(4));
            this.cols[i + 2].getColumn().setWidth(80);
            this.cols[i + 2].setLabelProvider((CellLabelProvider)new DateResultLabelProvider(this.ctl.controller, dates[i]));
            this.cols[i + 2].setEditingSupport(this.ctl.createEditingSupportFor(this.cols[i + 2], dates[i]));
            --i;
        }
    }
}

