/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.condensed;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.ungrad.labview.controller.ItemRangeLabelProvider;
import ch.elexis.ungrad.labview.controller.ItemTextLabelProvider;
import ch.elexis.ungrad.labview.controller.condensed.CondensedViewController;
import ch.elexis.ungrad.labview.controller.condensed.CondensedViewLabelProvider;
import ch.elexis.ungrad.labview.controller.condensed.LabSummaryContentProvider;
import ch.elexis.ungrad.labview.controller.condensed.LatestResultLabelProvider;
import ch.elexis.ungrad.labview.model.LabResultsSheet;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeColumn;

public class LabSummaryTreeColumns {
    public static final int COL_LATEST = 2;
    public static final int COL_RECENT = 3;
    public static final int COL_LASTYEAR = 4;
    public static final int COL_OLDER = 5;
    private final int num = 6;
    private final String[] captions = new String[]{"Parameter", "Referenz", "", "letzter Monat", "letzte 12 Monate", "\u00e4lter"};
    private int[] widths = new int[]{150, 150, 100, 130, 130, 130};
    private LatestResultLabelProvider lrlp = new LatestResultLabelProvider();
    private CellLabelProvider[] labelProviders = new CellLabelProvider[]{new ItemTextLabelProvider(), new ItemRangeLabelProvider(), this.lrlp, new CondensedViewLabelProvider(this, 3), new CondensedViewLabelProvider(this, 4), new CondensedViewLabelProvider(this, 5)};
    private CondensedViewController controller;
    TreeViewerColumn[] cols;
    private Font smallerFont;

    public LabSummaryTreeColumns(CondensedViewController ctl) {
        this.controller = ctl;
        Display display = Display.getDefault();
        FontData[] fontData = this.getDefaultFont().getFontData();
        int i = 0;
        while (i < fontData.length) {
            float h = (float)fontData[i].getHeight() * 3.0f / 4.0f;
            fontData[i].setHeight(Math.round(h));
            ++i;
        }
        this.smallerFont = new Font((Device)display, fontData);
        this.cols = new TreeViewerColumn[6];
        i = 0;
        while (i < 6) {
            this.cols[i] = new TreeViewerColumn(ctl.getViewer(), 0);
            this.defineColumn(this.cols[i], this.captions[i], this.widths[i], this.labelProviders[i]);
            ++i;
        }
    }

    public void dispose() {
        this.smallerFont.dispose();
    }

    public int getColumnWidth(int column) {
        if (column < 0 || column > this.cols.length) {
            return 0;
        }
        return this.cols[column].getColumn().getWidth();
    }

    public LabResultsSheet getLabResultsSheet() {
        return this.controller.lcp.getLRS();
    }

    public Font getDefaultFont() {
        return UiDesk.getFont((String)"anwender/stdfont");
    }

    public Font getSmallerFont() {
        return this.smallerFont;
    }

    public void reload(LabSummaryContentProvider lcp) {
        TimeTool[] dates = lcp.getLRS().getDates();
        if (dates != null && dates.length > 0) {
            TimeTool date = dates[dates.length - 1];
            this.cols[2].getColumn().setText(date.toString(4));
            this.lrlp.setDate(date);
        } else {
            this.cols[2].getColumn().setText("-");
            this.lrlp.setDate(null);
        }
    }

    private void defineColumn(TreeViewerColumn tvc, String title, int width, CellLabelProvider lp) {
        TreeColumn tc = tvc.getColumn();
        tc.setText(title);
        tc.setWidth(width);
        tc.setResizable(true);
        tvc.setLabelProvider(lp);
    }
}

