/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller.condensed;

import ch.elexis.core.data.util.PlatformHelper;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.Resolver;
import ch.elexis.ungrad.labview.Preferences;
import ch.elexis.ungrad.labview.controller.condensed.LabSummaryContentProvider;
import ch.elexis.ungrad.labview.model.Bucket;
import ch.elexis.ungrad.labview.model.LabResultsRow;
import ch.elexis.ungrad.labview.model.Result;
import ch.rgw.io.FileTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class Exporter {
    private Resolver resolver = new Resolver();
    private LabSummaryContentProvider lcp;
    Logger log = Logger.getLogger(this.getClass().getName());

    public Exporter(LabSummaryContentProvider lcp) {
        this.lcp = lcp;
    }

    public boolean runInBrowser() {
        try {
            String userHome = System.getProperty("user.home");
            Path userHomePath = Paths.get(userHome, new String[0]);
            Path appTempDir = Files.createTempDirectory(userHomePath, "ungrad-html-", new FileAttribute[0]);
            File tmp = new File(appTempDir.toFile(), "output.html");
            tmp.deleteOnExit();
            appTempDir.toFile().deleteOnExit();
            String output = this.makeHtml();
            FileTool.writeTextFile((File)tmp, (String)output);
            Program.launch((String)tmp.getAbsolutePath());
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.log(Level.SEVERE, "could not create HTML " + ex.getMessage());
            return false;
        }
    }

    public boolean createHTML(Composite parent) {
        FileDialog fd = new FileDialog(parent.getShell(), 8192);
        String file = fd.open();
        if (file != null) {
            try {
                String output = this.makeHtml();
                FileTool.writeTextFile((File)new File(file), (String)output);
                return true;
            }
            catch (Exception e) {
                this.log.severe("Could not create HTML " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    private String makeHtml() throws Exception {
        StringBuilder html = new StringBuilder("<table>");
        TimeTool[] dates = this.lcp.getLRS().getDates();
        html.append(this.makeFullGrid(dates));
        html.append("</table>");
        String fallback = PlatformHelper.getBasePath((String)"ch.elexis.ungrad.labview") + File.separator + "doc" + File.separator + "laborblatt_beispiel.html";
        File tmpl = new File(Preferences.cfg.get("ch.elexis.ungrad.labview.template", fallback));
        if (!tmpl.exists() || !tmpl.canRead()) {
            SWTHelper.showError((String)"Vorlage fehlt", (String)"Die Vorlagendatei f\u00fcr den HTML Export wurde nicht gefunden. Bitte unter 'Einstellungen' nachpr\u00fcfen");
        }
        String rawTemplate = FileTool.readTextFile((File)tmpl);
        String template = this.resolver.resolve(rawTemplate);
        String output = template.replace("[Laborwerte]", html.toString());
        return output;
    }

    private String makeFullGrid(TimeTool[] dates) {
        String[] exclusions = Preferences.cfg.get("ch.elexis.ungrad.labview.exclusions", "00,?").split(",");
        StringBuilder ret = new StringBuilder("<table class=\"fullgrid\">");
        ret.append("<tr><th class=\"rowheader\">Parameter</th><th class=\"ref\">Referenz</th>");
        int lim = dates.length > 8 ? dates.length - 8 : -1;
        int i = dates.length - 1;
        while (i > lim) {
            ret.append("<th>").append(dates[i].toString(4)).append("</th>");
            --i;
        }
        if (lim > -1) {
            ret.append("<th>fr\u00fcher</td>");
        }
        ret.append("</tr>");
        Object[] objectArray = this.lcp.getElements(this);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (!this.isExcluded(o.toString(), exclusions)) {
                ret.append("<tr><th class=\"group\" colspan=\"" + dates.length + "2\">").append(o.toString()).append("</th></tr>");
                Object[] objectArray2 = this.lcp.getChildren(o);
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    LabResultsRow lr;
                    Object l = objectArray2[n4];
                    if (l instanceof LabResultsRow && !this.isExcluded((lr = (LabResultsRow)l).getItem().get("titel"), exclusions)) {
                        ret.append("<tr>");
                        ret.append("<td class=\"rowheader\">").append(lr.getItem().get("titel")).append("</td><td class=\"ref\">").append(lr.getItem().get("refMann")).append("</td>");
                        int i2 = dates.length - 1;
                        while (i2 > lim) {
                            Result res = lr.get(dates[i2]);
                            if (res == null) {
                                ret.append("<td></td>");
                            } else {
                                ret.append("<td>").append(this.make(lr, res)).append("</td>");
                            }
                            --i2;
                        }
                        if (lim > -1) {
                            Bucket bucket = this.lcp.getLRS().getOlderBucket(lr.getItem());
                            ret.append("<td>").append(bucket.getMinResult()).append(" - ").append(bucket.getMaxResult()).append("</td>");
                        }
                        ret.append("</tr>");
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return ret.toString();
    }

    private boolean isExcluded(String value, String[] exclusions) {
        String[] stringArray = exclusions;
        int n = exclusions.length;
        int n2 = 0;
        while (n2 < n) {
            String excl = stringArray[n2];
            if (value.contains(excl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String make(LabResultsRow lr, Result res) {
        String raw = res.get("resultat").replaceAll("\\s+", "");
        if (raw.startsWith("-")) {
            return "-";
        }
        if (lr.getItem().isPathologic(lr.getPatient(), raw)) {
            return "<span class=\"pathologic\">" + raw + "</span>";
        }
        return raw;
    }
}

