/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labview.controller;

import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPerson;
import ch.elexis.ungrad.Util;
import ch.elexis.ungrad.labview.model.Item;
import ch.elexis.ungrad.labview.model.LabResultsRow;
import ch.elexis.ungrad.labview.model.LabResultsSheet;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Display;

public class ItemRangeLabelProvider
extends CellLabelProvider {
    private LabResultsSheet lrs;

    public ItemRangeLabelProvider(LabResultsSheet lrs) {
        this.lrs = lrs;
    }

    public ItemRangeLabelProvider() {
    }

    public void update(ViewerCell cell) {
        if (cell.getElement() instanceof LabResultsRow) {
            LabResultsRow results = (LabResultsRow)cell.getElement();
            Item item = results.getItem();
            IPatient pat = results.getPatient();
            if (Util.isFemale((IPerson)pat)) {
                cell.setText(item.get("RefFrauOrTx"));
            } else {
                cell.setText(item.get("refMann"));
            }
        } else if (cell.getElement() instanceof Item) {
            cell.setText(this.lrs.getNormRange((Item)cell.getElement()));
        } else {
            cell.setBackground(Display.getDefault().getSystemColor(15));
            cell.setText("");
        }
    }
}

