/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.labenter.views;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.LabItem;
import ch.elexis.ungrad.labenter.Messages;
import ch.rgw.io.Settings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LabEntryTable {
    TableViewer viewer;
    Element[] elements;

    LabEntryTable(Composite parent) {
        Settings settings = CoreHub.globalCfg;
        String[] itemlist = settings.getStringArray("ch.elexis.ungrad.labenter/items");
        this.elements = new Element[itemlist.length];
        int i = 0;
        while (i < itemlist.length) {
            this.elements[i] = new Element(itemlist[i]);
            ++i;
        }
        Table table = new Table(parent, 0);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)SWTHelper.getFillGridData());
        this.viewer = new TableViewer(table);
        this.createColumns(parent, this.viewer);
        TableViewerEditor.create((TableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer), (int)40);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    int idx = LabEntryTable.this.viewer.getTable().getSelectionIndex();
                    LabEntryTable.this.viewer.editElement(LabEntryTable.this.viewer.getElementAt(idx), 1);
                }
            }
        });
        this.viewer.setInput((Object)this.elements);
    }

    private TableViewerColumn createColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        return viewerColumn;
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn tvc = this.createColumn(Messages.LabEntryTable_Column_Parameter, 300, 0);
        tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Element)element).label;
            }
        });
        tvc = this.createColumn(Messages.LabEntryTable_Column_Value, 50, 1);
        tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((Element)cell.getElement()).value);
            }
        });
        tvc.setEditingSupport((EditingSupport)new LabValueEditingSupport(viewer));
    }

    class Element {
        LabItem item;
        String label;
        String value;

        Element(String itemId) {
            this.item = LabItem.load((String)itemId);
            this.label = this.item.getKuerzel() + " (" + this.item.getReferenceMale() + ") " + this.item.getUnit();
            this.value = "";
        }
    }

    class LabValueEditingSupport
    extends EditingSupport {
        private final TableViewer viewer;
        private final CellEditor editor;

        public LabValueEditingSupport(final TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.editor = new TextCellEditor((Composite)viewer.getTable());
            this.editor.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int idx = viewer.getTable().getSelectionIndex();
                    switch (e.keyCode) {
                        case 9: 
                        case 13: 
                        case 0x1000002: {
                            if (idx >= ((LabValueEditingSupport)LabValueEditingSupport.this).LabEntryTable.this.elements.length - 2) break;
                            e.doit = true;
                            viewer.editElement(viewer.getElementAt(idx + 1), 1);
                            break;
                        }
                        case 0x1000001: {
                            if (idx <= 0) break;
                            e.doit = true;
                            viewer.editElement(viewer.getElementAt(idx - 1), 1);
                        }
                    }
                }
            });
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((Element)element).value;
        }

        protected void setValue(Object element, Object userInputValue) {
            ((Element)element).value = String.valueOf(userInputValue);
            this.viewer.update(element, null);
        }
    }
}

