/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.buchhaltung.kassenbuch.KassenbuchEintrag;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.ungrad.pdf.Manager;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;

public class PdfPrinter {
    public static void createSummary(TimeTool von, TimeTool bis, File outputPath, String fileName) throws FileNotFoundException, IOException, PrinterException {
        Manager pdfManager = new Manager();
        SortedSet<KassenbuchEintrag> liste = KassenbuchEintrag.getBookings(von, bis);
        File htmlFile = new File(System.getProperty("java.io.tmpdir"), "kassenbuch_summary.html");
        File output = new File(outputPath, fileName);
        String template = PdfPrinter.readTemplate();
        StringBuilder rowsHtml = new StringBuilder();
        Money totalIncome = new Money();
        Money totalExpense = new Money();
        Money finalBalance = new Money();
        HashMap<String, CategorySum> categoryMap = new HashMap<String, CategorySum>();
        for (KassenbuchEintrag entry : liste) {
            CategorySum catSum;
            Money amount = entry.getAmount();
            Money saldo = entry.getSaldo();
            String kategorie = entry.getKategorie();
            if (StringTool.isNothing((Object)kategorie)) {
                kategorie = "Sonstiges";
            }
            if ((catSum = (CategorySum)categoryMap.get(kategorie)) == null) {
                catSum = new CategorySum();
                categoryMap.put(kategorie, catSum);
            }
            rowsHtml.append("\t\t\t<tr>\n");
            rowsHtml.append("\t\t\t\t<td>").append(entry.getDate()).append("</td>\n");
            rowsHtml.append("\t\t\t\t<td>").append(entry.getBelegNr()).append("</td>\n");
            rowsHtml.append("\t\t\t\t<td>").append(PdfPrinter.htmlEscape(entry.getText())).append("</td>\n");
            if (amount.isNegative()) {
                Money expense = new Money(amount).negate();
                rowsHtml.append("\t\t\t\t<td></td>\n");
                rowsHtml.append("\t\t\t\t<td>").append(expense.getAmountAsString()).append("</td>\n");
                totalExpense.addMoney(expense);
                catSum.expense.addMoney(expense);
            } else {
                rowsHtml.append("\t\t\t\t<td>").append(amount.getAmountAsString()).append("</td>\n");
                rowsHtml.append("\t\t\t\t<td></td>\n");
                totalIncome.addMoney(amount);
                catSum.income.addMoney(amount);
            }
            rowsHtml.append("\t\t\t\t<td>").append(saldo.getAmountAsString()).append("</td>\n");
            rowsHtml.append("\t\t\t</tr>\n");
            finalBalance = saldo;
        }
        StringBuilder categoryRowsHtml = new StringBuilder();
        for (Map.Entry catEntry : categoryMap.entrySet()) {
            CategorySum catSum = (CategorySum)catEntry.getValue();
            Money categorySaldo = new Money(catSum.income);
            categorySaldo.subtractMoney(catSum.expense);
            categoryRowsHtml.append("\t\t\t<tr>\n");
            categoryRowsHtml.append("\t\t\t\t<td>").append(PdfPrinter.htmlEscape((String)catEntry.getKey())).append("</td>\n");
            categoryRowsHtml.append("\t\t\t\t<td>").append(catSum.income.getAmountAsString()).append("</td>\n");
            categoryRowsHtml.append("\t\t\t\t<td>").append(catSum.expense.getAmountAsString()).append("</td>\n");
            categoryRowsHtml.append("\t\t\t\t<td>").append(categorySaldo.getAmountAsString()).append("</td>\n");
            categoryRowsHtml.append("\t\t\t</tr>\n");
        }
        String html = template;
        html = html.replace("[from]", von != null ? von.toString(4) : "Anfang");
        html = html.replace("[until]", bis != null ? bis.toString(4) : "Heute");
        html = html.replace("[rows]", rowsHtml.toString());
        html = html.replace("[total_income]", totalIncome.getAmountAsString());
        html = html.replace("[total_expense]", totalExpense.getAmountAsString());
        html = html.replace("[final_balance]", finalBalance.getAmountAsString());
        html = html.replace("[category_rows]", categoryRowsHtml.toString());
        Object object = null;
        Object var17_18 = null;
        try (FileWriter writer = new FileWriter(htmlFile, StandardCharsets.UTF_8);){
            writer.write(html);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        pdfManager.createPDF(htmlFile, output);
    }

    private static String readTemplate() throws IOException {
        File templateFile;
        String userTemplate = CoreHub.localCfg.get("kassenbuch/html_template", null);
        if (userTemplate != null && !userTemplate.trim().isEmpty() && (templateFile = new File(userTemplate)).exists() && templateFile.canRead()) {
            StringBuilder sb = new StringBuilder();
            Throwable throwable = null;
            Object var4_8 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(templateFile, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return sb.toString();
        }
        InputStream is = PdfPrinter.class.getResourceAsStream("/rsc/summary.html");
        if (is == null) {
            throw new FileNotFoundException("Template file rsc/summary.html not found");
        }
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var4_10 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return sb.toString();
    }

    private static String htmlEscape(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    private static class CategorySum {
        Money income = new Money();
        Money expense = new Money();

        private CategorySum() {
        }
    }
}

