/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionInfo;
import java.util.SortedSet;
import java.util.TreeSet;

public class KassenbuchEintrag
extends PersistentObject
implements Comparable<KassenbuchEintrag> {
    private static final String TABLENAME = "CH_ELEXIS_KASSENBUCH";
    public static final String VERSION = "1.2.0";
    public static final String CATEGORIES = "ChElexisKassenbuchKategorien";
    public static final String CATEGORY_SEPARATOR = "##";
    private static final String createDB = "CREATE TABLE CH_ELEXIS_KASSENBUCH(ID\t\t\tVARCHAR(25) primary key,deleted \tCHAR(1) default '0',Nr\t    \tVARCHAR(25),Category\tVARCHAR(80),Date   \tCHAR(8),Amount \tCHAR(8),Total  \tCHAR(8),Entry  \tVARCHAR(80));INSERT INTO CH_ELEXIS_KASSENBUCH (ID,Nr,Date,Entry) VALUES ('1','-','" + new TimeTool().toString(9) + "','1.2.0');";

    static {
        KassenbuchEintrag.addMapping((String)TABLENAME, (String[])new String[]{"Betrag=Amount", "Text=Entry", "Datum=S:D:Date", "Saldo=Total", "BelegNr=Nr", "Kategorie=Category", "PaymentMode"});
        KassenbuchEintrag version = KassenbuchEintrag.load("1");
        if (!version.exists()) {
            KassenbuchEintrag.createOrModifyTable((String)createDB);
        } else {
            VersionInfo vi = new VersionInfo(version.getText());
            if (vi.isOlder(VERSION)) {
                if (vi.isOlder("1.0.0")) {
                    KassenbuchEintrag.getConnection().exec("ALTER TABLE CH_ELEXIS_KASSENBUCH ADD deleted CHAR(1) default '0';");
                }
                if (vi.isOlder("1.1.0")) {
                    KassenbuchEintrag.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_KASSENBUCH ADD Category VARCHAR(80);");
                }
                if (vi.isOlder(VERSION)) {
                    KassenbuchEintrag.createOrModifyTable((String)"ALTER TABLE CH_ELEXIS_KASSENBUCH ADD lastupdate BIGINT, ADD PaymentMode VARCHAR(250)");
                }
                version.set("Text", VERSION);
            }
        }
    }

    public KassenbuchEintrag(String beleg, String date, Money amount, String text) {
        this.create(null);
        this.set(new String[]{"BelegNr", "Datum", "Betrag", "Text"}, new String[]{beleg, date, amount.getCentsAsString(), text});
        KassenbuchEintrag.recalc();
    }

    public static String nextNr(KassenbuchEintrag kbe) {
        Object ret = "1";
        if (kbe != null) {
            String prev = kbe.getBelegNr().split("[^0-9]", 2)[0];
            if (prev.matches("[0-9]+")) {
                int num = Integer.parseInt(prev);
                ret = Integer.toString(num + 1);
            } else {
                ret = kbe.getBelegNr() + " a";
            }
        }
        return ret;
    }

    public KassenbuchEintrag(String beleg, String date, Money amount, String text, KassenbuchEintrag last) {
        this.create(null);
        Money sum = new Money(amount);
        if (last != null) {
            sum.addMoney(last.getSaldo());
        }
        if (date == null) {
            date = new TimeTool().toString(4);
        }
        if (StringTool.isNothing((Object)beleg) || !((String)beleg).matches("[0-9]+.*")) {
            beleg = KassenbuchEintrag.nextNr(last) + (String)beleg;
        }
        this.set(new String[]{"BelegNr", "Datum", "Betrag", "Text", "Saldo"}, new String[]{beleg, date, amount.getCentsAsString(), text, sum.getCentsAsString()});
    }

    public String getBelegNr() {
        return KassenbuchEintrag.checkNull((Object)this.get("BelegNr"));
    }

    public String getDate() {
        return KassenbuchEintrag.checkNull((Object)this.get("Datum"));
    }

    public Money getAmount() {
        return new Money(KassenbuchEintrag.checkZero((Object)this.get("Betrag")));
    }

    public Money getSaldo() {
        return new Money(KassenbuchEintrag.checkZero((Object)this.get("Saldo")));
    }

    public String getText() {
        return this.get("Text");
    }

    public static KassenbuchEintrag recalc() {
        KassenbuchEintrag ret = null;
        Money sum = new Money();
        SortedSet<KassenbuchEintrag> all = KassenbuchEintrag.getBookings(null, null);
        if (all != null) {
            for (KassenbuchEintrag kb : all) {
                sum.addMoney(kb.getAmount());
                kb.set("Saldo", sum.getCentsAsString());
                ret = kb;
            }
        }
        return ret;
    }

    public static SortedSet<KassenbuchEintrag> getBookings(TimeTool from, TimeTool until) {
        Query qbe = new Query(KassenbuchEintrag.class);
        qbe.add("BelegNr", "<>", "-");
        if (from != null) {
            qbe.add("Datum", ">=", from.toString(9));
        }
        if (until != null) {
            qbe.add("Datum", "<=", until.toString(9));
        }
        TreeSet ts = new TreeSet();
        return (SortedSet)qbe.execute(ts);
    }

    public String getLabel() {
        return this.getAmount().getAmountAsString() + " " + this.getText();
    }

    public String getKategorie() {
        return this.get("Kategorie");
    }

    public void setKategorie(String cat) {
        KassenbuchEintrag.addKategorie(cat);
        this.set("Kategorie", cat);
    }

    protected String getTableName() {
        return TABLENAME;
    }

    public static KassenbuchEintrag load(String id) {
        return new KassenbuchEintrag(id);
    }

    protected KassenbuchEintrag() {
    }

    protected KassenbuchEintrag(String id) {
        super(id);
    }

    public static String[] getCategories() {
        String cats = CoreHub.globalCfg.get(CATEGORIES, "");
        return cats.split(CATEGORY_SEPARATOR);
    }

    public static void addKategorie(String cat) {
        String oldcats = CoreHub.globalCfg.get(CATEGORIES, "");
        String[] cats = oldcats.split(CATEGORY_SEPARATOR);
        if (StringTool.getIndex((String[])cats, (String)cat) == -1) {
            String ncats = oldcats + CATEGORY_SEPARATOR + cat;
            CoreHub.globalCfg.set(CATEGORIES, ncats);
        }
    }

    @Override
    public int compareTo(KassenbuchEintrag k2) {
        String[] s1 = this.getBelegNr().split("[^0-9]", 2);
        String[] s2 = k2.getBelegNr().split("[^0-9]", 2);
        int res = 0;
        res = s1[0].matches("[0-9]+") && s2[0].matches("[0-9]+") ? Integer.parseInt(s1[0]) - Integer.parseInt(s2[0]) : s1[0].compareTo(s2[0]);
        if (res == 0) {
            if (s1.length > s2.length) {
                return 1;
            }
            if (s1.length < s2.length) {
                return -1;
            }
            if (s1.length > 1) {
                return s1[1].compareTo(s2[1]);
            }
            return 0;
        }
        return res;
    }
}

