/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.buchhaltung.kassenbuch.KassenbuchEintrag;
import ch.elexis.buchhaltung.kassenbuch.Messages;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.ui.text.ITextPlugin;
import ch.elexis.core.ui.text.TextContainer;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.rgw.tools.Money;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.SortedSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class KassenbuchDruckDialog
extends Dialog
implements ITextPlugin.ICallback {
    TimeTool ttVon;
    TimeTool ttBis;
    Hashtable<String, Money> mCategories = new Hashtable();

    public KassenbuchDruckDialog(Shell shell, TimeTool von, TimeTool bis) {
        super(shell);
        this.ttVon = von;
        this.ttBis = bis;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new FillLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        TextContainer text = new TextContainer(this.getShell());
        text.getPlugin().createContainer(ret, (ITextPlugin.ICallback)this);
        text.getPlugin().showMenu(false);
        text.getPlugin().showToolbar(false);
        Kontakt activeUser = Kontakt.load((String)((IContact)ContextServiceHolder.get().getActiveUserContact().get()).getId());
        text.createFromTemplateName(null, "Liste", "Allg.", activeUser, "Kassenbuch");
        SortedSet<KassenbuchEintrag> set = KassenbuchEintrag.getBookings(this.ttVon, this.ttBis);
        if (set == null) {
            return ret;
        }
        KassenbuchEintrag[] lines = set.toArray(new KassenbuchEintrag[0]);
        String[][] table = new String[lines.length + 1][];
        table[0] = new String[]{Messages.KassenbuchDruckDialog_ColumnNr, Messages.KassenbuchDruckDialog_ColumnDate, Messages.KassenbuchDruckDialog_ColumnDebit, Messages.KassenbuchDruckDialog_ColumnCredit, Messages.KassenbuchDruckDialog_ColumnAmount, Messages.KassenbuchDruckDialog_ColumnText};
        int i = 1;
        while (i <= lines.length) {
            Money mKat;
            table[i] = new String[6];
            KassenbuchEintrag kb = lines[i - 1];
            String kategorie = kb.getKategorie();
            if (StringTool.isNothing((Object)kategorie)) {
                kategorie = Messages.KassenbuchDruckDialog_Miscellaneous;
            }
            if ((mKat = this.mCategories.get(kategorie)) == null) {
                mKat = new Money();
                this.mCategories.put(kategorie, mKat);
            }
            Money betrag = kb.getAmount();
            mKat.addMoney(betrag);
            table[i][0] = kb.get("BelegNr");
            table[i][1] = kb.getDate();
            table[i][2] = betrag.isNegative() ? new Money(betrag).negate().getAmountAsString() : "";
            table[i][3] = betrag.isNegative() ? "" : betrag.getAmountAsString();
            table[i][4] = kb.getSaldo().getAmountAsString();
            table[i][5] = kb.getText();
            ++i;
        }
        text.getPlugin().setFont("Helvetica", 0, 9.0f);
        text.getPlugin().insertTable("[Liste]", 1, table, new int[]{5, 15, 15, 15, 20, 30});
        Enumeration<String> keys = this.mCategories.keys();
        Object cursor = text.getPlugin().insertText("##end##", "", 16384);
        while (keys.hasMoreElements()) {
            String cat = keys.nextElement();
            Money betrag = this.mCategories.get(cat);
            StringBuilder sb = new StringBuilder();
            sb.append("\n").append(cat).append("\t\t\t").append(betrag.getAmountAsString());
            cursor = text.getPlugin().insertText(cursor, sb.toString(), 16384);
        }
        return ret;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.KassenbuchDruckDialog_ShellTitle);
        this.getShell().setSize(800, 700);
    }

    protected void okPressed() {
        super.okPressed();
    }

    public void save() {
    }

    public boolean saveAs() {
        return false;
    }
}

