/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.buchhaltung.kassenbuch.BuchungsDialog;
import ch.elexis.buchhaltung.kassenbuch.DatumEingabeDialog;
import ch.elexis.buchhaltung.kassenbuch.EditCatsDialog;
import ch.elexis.buchhaltung.kassenbuch.KassenbuchEintrag;
import ch.elexis.buchhaltung.kassenbuch.Messages;
import ch.elexis.buchhaltung.kassenbuch.PdfPrinter;
import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.Heartbeat;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import java.awt.Desktop;
import java.io.File;
import java.text.MessageFormat;
import java.util.SortedSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class KassenView
extends ViewPart
implements IActivationListener,
Heartbeat.HeartListener {
    Form form;
    FormToolkit tk;
    TableViewer tv;
    TableColumn[] tc;
    TimeTool ttVon;
    TimeTool ttBis;
    String[] tableHeaders = new String[]{Messages.KassenView_ColumnBeleg, Messages.KassenView_ColumnDatum, Messages.KassenView_ColumnSoll, Messages.KassenView_ColumnHaben, Messages.KassenView_ColumnSaldo, Messages.KassenView_ColumnKategorie, Messages.KassenView_ColumnText};
    int[] tableCols = new int[]{50, 80, 60, 60, 60, 100, 400};
    private IAction addAction;
    private IAction subtractAction;
    private IAction stornoAction;
    private IAction saldoAction;
    private IAction dateAction;
    private IAction printAction;
    private IAction editCatAction;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        this.tk = UiDesk.getToolkit();
        this.form = this.tk.createForm(parent);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new FillLayout());
        this.form.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tc = new TableColumn[this.tableHeaders.length];
        Table table = new Table(body, 66052);
        int i = 0;
        while (i < this.tc.length) {
            this.tc[i] = new TableColumn(table, 0);
            this.tc[i].setText(this.tableHeaders[i]);
            this.tc[i].setWidth(this.tableCols[i]);
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tv = new TableViewer(table);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                SortedSet<KassenbuchEintrag> set = KassenbuchEintrag.getBookings(KassenView.this.ttVon, KassenView.this.ttBis);
                if (set != null) {
                    return set.toArray();
                }
                return new KassenbuchEintrag[0];
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new KBLabelProvider());
        this.tv.setUseHashlookup(true);
        this.makeActions();
        ViewMenus menu = new ViewMenus(this.getViewSite());
        menu.createToolbar(new IAction[]{this.addAction, this.subtractAction, this.saldoAction});
        menu.createViewerContextMenu((StructuredViewer)this.tv, new IAction[]{this.stornoAction});
        menu.createMenu(new IAction[]{this.dateAction, this.printAction, null, this.editCatAction});
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)KassenView.this.tv.getSelection();
                if (!sel.isEmpty()) {
                    KassenbuchEintrag kbe = (KassenbuchEintrag)sel.getFirstElement();
                    if (new BuchungsDialog(KassenView.this.getSite().getShell(), kbe).open() == 0) {
                        KassenView.this.tv.refresh();
                    }
                }
            }
        });
        this.tv.setInput((Object)this);
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.setFormText();
    }

    private void setFormText() {
        if (this.ttVon == null) {
            this.form.setText(Messages.KassenView_DisplayAllBookings);
        } else {
            this.form.setText(MessageFormat.format(Messages.KassenView_DisplayFromTo, this.ttVon.toString(4), this.ttBis.toString(4)));
        }
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        super.dispose();
    }

    public void setFocus() {
    }

    private void makeActions() {
        this.addAction = new Action(Messages.KassenView_Action_Income_Title){
            {
                this.setImageDescriptor(Images.IMG_ADDITEM.getImageDescriptor());
                this.setToolTipText(Messages.KassenView_Action_Income_Tooltip);
            }

            public void run() {
                new BuchungsDialog(KassenView.this.getSite().getShell(), true).open();
                KassenView.this.tv.refresh();
            }
        };
        this.subtractAction = new Action(Messages.KassenView_Action_Expense_Title){
            {
                this.setImageDescriptor(Images.IMG_REMOVEITEM.getImageDescriptor());
                this.setToolTipText(Messages.KassenView_Action_Expense_Tooltip);
            }

            public void run() {
                new BuchungsDialog(KassenView.this.getSite().getShell(), false).open();
                KassenView.this.tv.refresh();
            }
        };
        this.stornoAction = new Action(Messages.KassenView_Action_Storno_Title){
            {
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.KassenView_Action_Storno_Tooltip);
            }

            public void run() {
                IStructuredSelection sel = (IStructuredSelection)KassenView.this.tv.getSelection();
                if (!sel.isEmpty()) {
                    KassenbuchEintrag kb = (KassenbuchEintrag)sel.getFirstElement();
                    kb.delete();
                    KassenbuchEintrag.recalc();
                    KassenView.this.tv.refresh();
                }
            }
        };
        this.saldoAction = new Action(Messages.KassenView_Action_Balance_Title){
            {
                this.setImageDescriptor(KassenView.getPluginImageDescriptor("icons/sigma.ico"));
                this.setToolTipText(Messages.KassenView_Action_Balance_Tooltip);
            }

            public void run() {
                InputDialog inp = new InputDialog(KassenView.this.getSite().getShell(), Messages.KassenView_Balance_DialogTitle, Messages.KassenView_Balance_DialogMessage, Messages.KassenView_Balance_DefaultValue, null);
                if (inp.open() == 0) {
                    try {
                        Money money = new Money(inp.getValue());
                        if (!money.isZero()) {
                            KassenbuchEintrag last = KassenbuchEintrag.recalc();
                            Money soll = last.getSaldo();
                            Money diff = money.subtractMoney(soll);
                            new KassenbuchEintrag(KassenbuchEintrag.nextNr(last) + " " + Messages.KassenView_Balance_Check, new TimeTool().toString(4), diff, diff.isNegative() ? Messages.KassenView_Balance_Shortage : Messages.KassenView_Balance_Surplus);
                            KassenView.this.tv.refresh();
                        }
                    }
                    catch (Exception ex) {
                        ExHandler.handle((Throwable)ex);
                        SWTHelper.alert((String)Messages.KassenView_Error_Title, (String)Messages.KassenView_Error_InvalidAmount);
                    }
                }
            }
        };
        this.dateAction = new Action(Messages.KassenView_Action_Period_Title){
            {
                this.setImageDescriptor(KassenView.getPluginImageDescriptor("icons/calendar.png"));
                this.setToolTipText(Messages.KassenView_Action_Period_Tooltip);
            }

            public void run() {
                DatumEingabeDialog ded = new DatumEingabeDialog(KassenView.this.getViewSite().getShell(), KassenView.this.ttVon, KassenView.this.ttBis);
                if (ded.open() == 0) {
                    KassenView.this.ttVon = ded.ttVon;
                    KassenView.this.ttBis = ded.ttBis;
                } else {
                    KassenView.this.ttVon = null;
                    KassenView.this.ttBis = null;
                }
                KassenView.this.setFormText();
                KassenView.this.tv.refresh();
            }
        };
        this.printAction = new Action(Messages.KassenView_Action_Print_Title){
            {
                this.setImageDescriptor(Images.IMG_PRINTER.getImageDescriptor());
                KassenView.this.setTitleToolTip(Messages.KassenView_Action_Print_Tooltip);
            }

            public void run() {
                try {
                    FileDialog fd = new FileDialog(KassenView.this.getSite().getShell(), 8192);
                    fd.setFilterExtensions(new String[]{"*.pdf"});
                    fd.setFilterNames(new String[]{"PDF Dokumente (*.pdf)"});
                    fd.setFileName("kassenbuch_summary.pdf");
                    String selectedPath = fd.open();
                    if (selectedPath != null) {
                        File outputFile = new File(selectedPath);
                        System.out.println("Creating PDF file " + outputFile.getAbsolutePath());
                        PdfPrinter.createSummary(KassenView.this.ttVon, KassenView.this.ttBis, outputFile.getParentFile(), outputFile.getName());
                        System.out.println("PDF file created.");
                        if (outputFile.exists()) {
                            Desktop desktop;
                            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN)) {
                                desktop.open(outputFile);
                            }
                        } else {
                            SWTHelper.alert((String)Messages.KassenView_Error_Title, (String)(Messages.KassenView_Error_PrintFailed + ": File not found after creation."));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ExHandler.handle((Throwable)e);
                    SWTHelper.alert((String)Messages.KassenView_Error_Title, (String)(Messages.KassenView_Error_PrintFailed + ": " + e.getMessage()));
                }
            }
        };
        this.editCatAction = new Action(Messages.KassenView_Action_EditCategories_Title){
            {
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                KassenView.this.setTitleToolTip(Messages.KassenView_Action_EditCategories_Tooltip);
            }

            public void run() {
                new EditCatsDialog(KassenView.this.getSite().getShell()).open();
            }
        };
    }

    public static ImageDescriptor getPluginImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"ch.elexis.kassenbuch", (String)path);
    }

    public void activation(boolean mode) {
    }

    public void visible(boolean mode) {
        if (mode) {
            this.tv.refresh();
            CoreHub.heart.addListener((Heartbeat.HeartListener)this);
        } else {
            CoreHub.heart.removeListener((Heartbeat.HeartListener)this);
        }
    }

    public void heartbeat() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                KassenView.this.tv.refresh();
            }
        });
    }

    class KBLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        KBLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            KassenbuchEintrag kb = (KassenbuchEintrag)element;
            Money betrag = kb.getAmount();
            switch (columnIndex) {
                case 0: {
                    return kb.get("BelegNr");
                }
                case 1: {
                    return kb.getDate();
                }
                case 2: {
                    return betrag.isNegative() ? new Money(betrag).negate().getAmountAsString() : "";
                }
                case 3: {
                    return betrag.isNegative() ? "" : betrag.getAmountAsString();
                }
                case 4: {
                    return kb.getSaldo().getAmountAsString();
                }
                case 5: {
                    return kb.getKategorie();
                }
                case 6: {
                    return kb.getText();
                }
            }
            return "?";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (columnIndex == 4) {
                KassenbuchEintrag kb = (KassenbuchEintrag)element;
                if (kb.getSaldo().isNegative()) {
                    return UiDesk.getColor((String)"rot");
                }
                return UiDesk.getColor((String)"schwarz");
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }
    }
}

