/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.buchhaltung.kassenbuch;

import ch.elexis.buchhaltung.kassenbuch.KassenbuchEintrag;
import ch.elexis.buchhaltung.kassenbuch.Messages;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BuchungsDialog
extends TitleAreaDialog {
    boolean bType;
    LabeledInputField liBeleg;
    LabeledInputField liDate;
    LabeledInputField liBetrag;
    Text text;
    KassenbuchEintrag last;
    KassenbuchEintrag act;
    Combo cbCats;

    BuchungsDialog(Shell shell, boolean mode) {
        super(shell);
        this.bType = mode;
        this.act = null;
    }

    BuchungsDialog(Shell shell, KassenbuchEintrag kbe) {
        super(shell);
        this.act = kbe;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        Composite top = new Composite(ret, 2048);
        top.setLayout((Layout)new FillLayout());
        top.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.liBeleg = new LabeledInputField(top, Messages.BuchungsDialog_Label_Beleg);
        this.liDate = new LabeledInputField(top, Messages.BuchungsDialog_Label_Date, LabeledInputField.Typ.OBSOLETE_DATE);
        this.liBetrag = new LabeledInputField(top, Messages.BuchungsDialog_Label_Amount, LabeledInputField.Typ.MONEY);
        Composite cCats = new Composite(ret, 0);
        cCats.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        cCats.setLayout((Layout)new GridLayout(2, false));
        new Label(cCats, 0).setText(Messages.BuchungsDialog_Label_Category);
        this.cbCats = new Combo(cCats, 4);
        this.cbCats.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        this.cbCats.setItems(KassenbuchEintrag.getCategories());
        new Label(ret, 0).setText(Messages.BuchungsDialog_Label_Text);
        this.text = new Text(ret, 2048);
        this.text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        if (this.act == null) {
            this.last = KassenbuchEintrag.recalc();
            this.liBeleg.setText(KassenbuchEintrag.nextNr(this.last));
        } else {
            this.liBeleg.setText(this.act.getBelegNr());
            this.liDate.setText(this.act.getDate());
            this.liBetrag.setText(this.act.getAmount().getAmountAsString());
            this.cbCats.setText(this.act.getKategorie());
            this.text.setText(this.act.getText());
        }
        return ret;
    }

    public void create() {
        super.create();
        if (this.act == null) {
            if (this.bType) {
                this.setTitle(Messages.BuchungsDialog_Income_Title);
            } else {
                this.setTitle(Messages.BuchungsDialog_Expense_Title);
            }
        } else {
            this.setTitle(Messages.BuchungsDialog_Edit_Title);
        }
        this.setMessage(Messages.BuchungsDialog_Message);
        this.getShell().setText(Messages.BuchungsDialog_ShellTitle);
        this.liBetrag.getControl().setFocus();
    }

    protected void okPressed() {
        Money money = new Money();
        try {
            money.addAmount(this.liBetrag.getText());
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
        TimeTool tt = new TimeTool(this.liDate.getText());
        String bt = this.text.getText();
        if (this.act == null) {
            if (!this.bType) {
                money = money.negate();
            }
            this.act = new KassenbuchEintrag(this.liBeleg.getText(), tt.toString(4), money, bt, this.last);
        } else {
            this.act.set(new String[]{"BelegNr", "Datum", "Betrag", "Text"}, new String[]{this.liBeleg.getText(), tt.toString(4), money.getCentsAsString(), this.text.getText()});
            KassenbuchEintrag.recalc();
        }
        this.act.setKategorie(this.cbCats.getText());
        super.okPressed();
    }
}

