/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.inbox.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.ungrad.IMAPMail;
import ch.elexis.ungrad.MBox;
import ch.elexis.ungrad.inbox.model.Controller;
import ch.elexis.ungrad.inbox.model.DocumentDescriptor;
import ch.elexis.ungrad.inbox.model.FilenameMatcher;
import ch.elexis.ungrad.inbox.ui.ImportDocumentDialog;
import ch.elexis.ungrad.inbox.ui.Messages;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class View
extends ViewPart {
    TableViewer tv;
    Controller controller = new Controller();
    FilenameMatcher fmatch = new FilenameMatcher();
    private IAction addAction;
    private IAction deleteAction;
    private IAction execAction;
    private IAction reloadAction;
    private IAction loadMailAction;
    private String[] whitelist;

    public View() {
        String senders = CoreHub.localCfg.get("ch.elexis.ungrad.inbox.whiteleist", "");
        this.whitelist = StringTool.isNothing((Object)senders) ? new String[0] : senders.split("\\n");
    }

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.tv = new TableViewer(parent);
        this.tv.setLabelProvider((IBaseLabelProvider)this.controller);
        this.tv.setContentProvider((IContentProvider)this.controller);
        this.tv.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return View.this.controller.getColumnText(e1, 0).compareTo(View.this.controller.getColumnText(e2, 0));
            }
        });
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData());
        this.tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)View.this.tv.getSelection();
                View.this.addAction.setEnabled(!sel.isEmpty());
                View.this.deleteAction.setEnabled(!sel.isEmpty());
                View.this.execAction.setEnabled(!sel.isEmpty());
            }
        });
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                View.this.launchViewer(View.this.getSelection());
            }
        });
        ViewMenus menus = new ViewMenus(this.getViewSite());
        menus.createToolbar(new IAction[]{this.addAction, this.execAction, this.loadMailAction, this.reloadAction, null, this.deleteAction});
        this.addAction.setEnabled(false);
        this.deleteAction.setEnabled(false);
        this.execAction.setEnabled(false);
        if (CoreHub.localCfg.get("ch.elexis.ungrad.inbox.mailmode", "none").equals("none")) {
            this.loadMailAction.setEnabled(false);
        }
        this.tv.setInput((Object)CoreHub.localCfg.get("ch.elexis.ungrad.inbox.dir", ""));
    }

    public void setFocus() {
        this.reload();
    }

    public File getSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return (File)sel.getFirstElement();
    }

    public void reload() {
        UiDesk.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                View.this.tv.refresh();
            }
        });
    }

    void launchViewer(File sel) {
        try {
            String ext = FileTool.getExtension((String)sel.getName());
            Program proggie = Program.findProgram((String)ext);
            String arg = sel.getAbsolutePath();
            if (proggie != null) {
                proggie.execute(arg);
            } else if (!Program.launch((String)sel.getAbsolutePath())) {
                Runtime.getRuntime().exec(arg);
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)Messages.View_Error_CouldNotStart, (String)ex.getMessage());
        }
    }

    private void makeActions() {
        this.loadMailAction = new Action(Messages.View_Action_FetchMail_Title){
            private IMAPMail.INotifier notifier;
            {
                this.setToolTipText(Messages.View_Action_FetchMail_Tooltip);
                this.setImageDescriptor(Images.IMG_MAIL.getImageDescriptor());
                this.notifier = new IMAPMail.INotifier(){
                    File dir = new File(CoreHub.localCfg.get("ch.elexis.ungrad.inbox.dir", ""));

                    public void documentFound(String name, byte[] doc, String sender, String subject) {
                        try {
                            FileTool.writeFile((File)new File(this.dir, name), (byte[])doc);
                            FileTool.writeTextFile((File)new File(this.dir, name + ".meta"), (String)(sender + "," + subject));
                            View.this.reload();
                        }
                        catch (Exception exception) {
                            SWTHelper.alert((String)Messages.View_Error_Writing, (String)MessageFormat.format(Messages.View_Error_Writing, name));
                        }
                    }
                };
            }

            public void run() {
                try {
                    String mailMode = CoreHub.localCfg.get("ch.elexis.ungrad.inbox.mailmode", "none");
                    if (mailMode.equals("mbox")) {
                        String mbox = CoreHub.localCfg.get("ch.elexis.ungrad.inbox.mboxfile", "");
                        new MBox(mbox, View.this.whitelist).readMessages(this.notifier);
                    } else if (mailMode.equals("imap")) {
                        new IMAPMail(View.this.whitelist, this.notifier).fetch();
                    }
                }
                catch (Exception e) {
                    SWTHelper.alert((String)Messages.View_Error_FetchingMail, (String)e.getLocalizedMessage());
                    ExHandler.handle((Throwable)e);
                }
            }
        };
        this.addAction = new Action(Messages.View_Action_Assign_Title){
            {
                this.setToolTipText(Messages.View_Action_Assign_Tooltip);
                this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
            }

            public void run() {
                try {
                    DocumentDescriptor dd;
                    ImportDocumentDialog idlg;
                    File sel = View.this.getSelection();
                    if (sel != null && (idlg = new ImportDocumentDialog(View.this, dd = View.this.fmatch.analyze(sel))).open() == 0) {
                        if (dd.concerns()) {
                            View.this.controller.moveFileToDocbase(dd.concerns_id, sel, idlg.getValue(), idlg.bUseKI);
                            View.this.reload();
                        } else {
                            SWTHelper.alert((String)Messages.ImportDocumentDialog_ErrorNoPatient, (String)Messages.ImportDocumentDialog_ErrorNoPatient);
                        }
                    }
                }
                catch (Exception ex) {
                    SWTHelper.showError((String)Messages.View_Error_Moving, (String)ex.getMessage());
                }
            }
        };
        this.deleteAction = new Action(Messages.View_Action_Delete_Title){
            {
                this.setToolTipText(Messages.View_Action_Delete_Tooltip);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
            }

            public void run() {
                File sel = View.this.getSelection();
                if (SWTHelper.askYesNo((String)Messages.Plugin_PreferencesName, (String)MessageFormat.format("{0} wirklich l\u00f6schen?", sel.getName()))) {
                    File meta = new File(sel.getAbsolutePath() + ".meta");
                    if (meta.exists()) {
                        meta.delete();
                    }
                    sel.delete();
                    View.this.reload();
                }
            }
        };
        this.execAction = new Action(Messages.View_Action_Open_Title){
            {
                this.setToolTipText(Messages.View_Action_Open_Tooltip);
                this.setImageDescriptor(Images.IMG_EYE_WO_SHADOW.getImageDescriptor());
            }

            public void run() {
                View.this.launchViewer(View.this.getSelection());
            }
        };
        this.reloadAction = new Action(Messages.View_Action_Reload_Title){
            {
                this.setToolTipText(Messages.View_Action_Reload_Tooltip);
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                View.this.reload();
            }
        };
    }
}

