/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.inbox.ui;

import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.Person;
import ch.elexis.ungrad.AIUtil;
import ch.elexis.ungrad.inbox.model.DocumentDescriptor;
import ch.elexis.ungrad.inbox.ui.Messages;
import ch.elexis.ungrad.inbox.ui.View;
import ch.rgw.io.FileTool;
import java.io.File;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ImportDocumentDialog
extends TitleAreaDialog {
    DocumentDescriptor dd;
    Text text;
    Button cbUseKI;
    String result = "";
    boolean bUseKI = AIUtil.useAI();
    private View view;

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData());
        ret.setLayout((Layout)new GridLayout(2, false));
        Button bSelect = new Button(ret, 8);
        bSelect.setText(Messages.ImportDocumentDialog_AssignPatient);
        bSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KontaktSelektor ksl = new KontaktSelektor(ImportDocumentDialog.this.getShell(), Person.class, Messages.ImportDocumentDialog_SelectPatientTitle, Messages.ImportDocumentDialog_SelectPatientMessage, null);
                if (ksl.open() == 0) {
                    Person pat = (Person)ksl.getSelection();
                    ImportDocumentDialog.this.setErrorMessage(null);
                    ImportDocumentDialog.this.setMessage(pat.getLabel());
                    ImportDocumentDialog.this.dd.concern(pat);
                }
            }
        });
        Button bFileSystem = new Button(ret, 8);
        bFileSystem.setText(Messages.ImportDocumentDialog_Directory);
        bFileSystem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ImportDocumentDialog.this.getShell(), 8192);
                fd.setText(Messages.ImportDocumentDialog_SelectFileTitle);
                fd.setFileName(ImportDocumentDialog.this.dd.filename);
                String fn = fd.open();
                if (fn != null && FileTool.copyFile((File)ImportDocumentDialog.this.dd.file, (File)new File(fn), (int)2)) {
                    ImportDocumentDialog.this.dd.file.delete();
                    ImportDocumentDialog.this.view.reload();
                    ImportDocumentDialog.this.cancelPressed();
                }
            }
        });
        if (!this.dd.concerns()) {
            this.setErrorMessage(Messages.ImportDocumentDialog_ErrorNoPatient);
        } else {
            this.setMessage(Patient.load((String)this.dd.concerns_id).getLabel());
        }
        Composite cText = new Composite(ret, 0);
        cText.setLayoutData((Object)SWTHelper.getFillGridData((int)2, (boolean)true, (int)1, (boolean)false));
        cText.setLayout((Layout)new GridLayout(2, false));
        this.text = new Text(cText, 2048);
        this.text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
        Button bView = new Button(cText, 8);
        bView.setImage(Images.IMG_EYE_WO_SHADOW.getImage());
        bView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDocumentDialog.this.view.launchViewer(ImportDocumentDialog.this.dd.file);
            }
        });
        this.text.setText(this.dd.filename);
        if (this.bUseKI) {
            Composite cUseKI = new Composite(ret, 0);
            cUseKI.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)false, (int)1, (boolean)true));
            cUseKI.setLayout((Layout)new FillLayout());
            this.cbUseKI = new Button(cUseKI, 32);
            this.cbUseKI.setSelection(this.bUseKI);
            Label lUseKI = new Label(cUseKI, 0);
            lUseKI.setText(Messages.ImportDocumentDialog_UseAI);
        }
        return ret;
    }

    public void create() {
        super.create();
        super.getShell().setText(Messages.ImportDocumentDialog_ShellTitle);
        this.setTitle(Messages.ImportDocumentDialog_Title);
    }

    public ImportDocumentDialog(View view, DocumentDescriptor dd) {
        super(view.getSite().getShell());
        this.view = view;
        this.dd = dd;
    }

    protected void okPressed() {
        if (this.cbUseKI != null) {
            this.bUseKI = this.cbUseKI.getSelection();
        }
        this.result = this.text.getText();
        super.okPressed();
    }

    public String getValue() {
        return this.result;
    }
}

