/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.inbox.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.data.Person;
import ch.elexis.data.Query;
import ch.elexis.ungrad.inbox.model.DocumentDescriptor;
import ch.elexis.ungrad.inbox.model.FilenameMapper;
import ch.elexis.ungrad.lucinda.Client3;
import ch.rgw.io.FileTool;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilenameMatcher {
    Pattern datePattern = Pattern.compile("\\d{1,4}[\\.-]\\d?\\d[\\.-]\\d{1,4}");
    Pattern datePattern2;

    private String cut(String in, String frag) {
        int idx = in.indexOf(frag);
        if (idx == -1) {
            return in;
        }
        String ret = in.substring(0, idx) + in.substring(idx + frag.length());
        return ret;
    }

    private String cutDate(String in, TimeTool date) {
        String ret = this.cut(in, date.toString(4));
        if (ret.equals(in)) {
            ret = this.cut(in, date.toString(6));
        }
        return ret;
    }

    private Person findKontakt(String text) {
        if (!StringTool.isNothing((Object)text)) {
            String[] words;
            LinkedList<TimeTool> dates = new LinkedList<TimeTool>();
            Matcher m = this.datePattern.matcher(text);
            while (m.find()) {
                TimeTool t = new TimeTool(m.group());
                dates.add(t);
            }
            for (TimeTool tt : dates) {
                Person p = this.checkBirthdate(text, tt);
                if (p != null) {
                    return p;
                }
                text = this.cutDate(text, tt).trim();
            }
            Query qbe = new Query(Person.class);
            String[] stringArray = words = text.split("[^\\w\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8]+");
            int n = words.length;
            int n2 = 0;
            while (n2 < n) {
                String word = stringArray[n2];
                if (word.matches("[\\w\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00e9\u00e0\u00e8]+")) {
                    qbe.clear();
                    qbe.add("Name", "=", word);
                    List result = qbe.execute();
                    if (result.size() > 0) {
                        for (Person p : result) {
                            String vn = p.getVorname();
                            if (!text.contains(vn)) continue;
                            return p;
                        }
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private void analyzeMappings(DocumentDescriptor dd) throws Exception {
        File mapfile;
        String mapfilename = CoreHub.localCfg.get("ch.elexis.ungrad.inbox.mappingfile", null);
        if (mapfilename != null && (mapfile = new File(mapfilename)).exists() && mapfile.canRead()) {
            FilenameMapper fmap = new FilenameMapper(mapfile);
            fmap.map(dd);
            if (!dd.concerns()) {
                List result;
                Query qbe = new Query(Person.class);
                if (dd.dob != null) {
                    qbe.add("Geburtsdatum", "=", dd.dob.toString(9));
                }
                if (dd.firstname != null) {
                    qbe.startGroup();
                    qbe.add("Vorname", "=", dd.firstname);
                    qbe.or();
                    qbe.add("Name", "=", dd.firstname);
                    qbe.endGroup();
                }
                if (dd.lastname != null) {
                    qbe.and();
                    qbe.startGroup();
                    qbe.add("Name", "=", dd.lastname);
                    qbe.or();
                    qbe.add("Vorname", "=", dd.lastname);
                    qbe.endGroup();
                }
                if ((result = qbe.execute()).size() == 1) {
                    dd.concern((Person)result.get(0));
                }
            }
        }
    }

    public void analyzeContents(final DocumentDescriptor dd) throws Exception {
        if (CoreHub.localCfg.get("ch.elexis.ungrad.inbox.analyzeContents", false)) {
            Client3 client = new Client3();
            client.analyzeFile(FileTool.readFile((File)dd.file), new Client3.INotifier(){

                public boolean received(String text) {
                    Person p;
                    if (!StringTool.isNothing((Object)text) && text.length() > 3 && (p = FilenameMatcher.this.checkBirthdate(text, null)) != null) {
                        dd.concern(p);
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    public DocumentDescriptor analyze(File file) throws Exception {
        DocumentDescriptor dd = new DocumentDescriptor(new TimeTool(), file, file.getName());
        File meta = new File(file.getAbsolutePath() + ".meta");
        if (meta.exists() && meta.canRead()) {
            String[] metadata = FileTool.readTextFile((File)meta).split(",", 2);
            dd.sender = metadata[0].split("@")[0];
            if (metadata.length > 1) {
                dd.subject = metadata[1];
            }
        }
        dd.concern(this.findKontakt(dd.subject));
        this.analyzeMappings(dd);
        if (!dd.concerns()) {
            dd.concern(this.findKontakt(dd.filename));
        }
        if (dd.docDate == null) {
            this.findDates(dd);
        }
        if (!dd.concerns()) {
            this.analyzeContents(dd);
        }
        this.makeFilename(dd);
        return dd;
    }

    private void makeFilename(DocumentDescriptor dd) {
        String ext;
        int extpos = dd.filename.lastIndexOf(46);
        String string = ext = extpos == -1 ? "" : dd.filename.substring(extpos);
        if (dd.docname == null) {
            if (extpos != -1) {
                dd.filename = dd.filename.substring(0, extpos);
            }
            dd.docname = this.cutDate(dd.filename, dd.docDate);
            if (dd.concerns()) {
                Person p = Person.load((String)dd.concerns_id);
                dd.docname = this.cutDate(dd.docname, new TimeTool(p.getGeburtsdatum()));
                dd.docname = this.cut(dd.docname, p.get("Name"));
                dd.docname = this.cut(dd.docname, p.get("Vorname"));
            }
            dd.docname = dd.docname.replaceAll("[,':;]", " ");
            dd.docname = dd.docname.replaceAll("\\s+", "_");
            while (dd.docname.startsWith("-") || dd.docname.startsWith("_")) {
                dd.docname = dd.docname.substring(1);
            }
            dd.docname = dd.docname.replaceAll("\\(\\)", "").replaceAll("__+", "_");
        }
        if (dd.sender != null) {
            dd.docname = dd.docname.trim() + "_" + dd.sender;
        }
        dd.docname = dd.docDate.toString(6) + "_" + dd.docname.trim();
        while (dd.docname.endsWith("-") || dd.docname.endsWith("_")) {
            dd.docname = dd.docname.substring(0, dd.docname.length() - 1);
        }
        dd.filename = dd.docname + ext.toLowerCase();
    }

    public void findDates(DocumentDescriptor dd) {
        TimeTool now = new TimeTool();
        TimeTool cand = new TimeTool();
        Matcher m = this.datePattern.matcher(dd.filename);
        while (m.find()) {
            TimeTool t = new TimeTool(m.group());
            if (this.checkBirthdate(dd, t) || !t.isBeforeOrEqual(now) || !cand.isEqual(now) && !t.isAfter(cand)) continue;
            cand = t;
        }
        dd.docDate = new TimeTool(cand);
    }

    private boolean checkBirthdate(DocumentDescriptor dd, TimeTool cand) {
        if (!dd.concerns()) {
            dd.concern(this.checkBirthdate(dd.filename, cand));
            if (dd.concerns()) {
                dd.dob = new TimeTool(Person.load((String)dd.concerns_id).getGeburtsdatum());
            }
        }
        return dd.dob != null ? cand.isEqual(dd.dob) : false;
    }

    private Person checkBirthdate(String text, TimeTool cand) {
        Query qbe;
        List result;
        if (StringTool.isNothing((Object)text)) {
            return null;
        }
        if (cand == null) {
            Matcher m = this.datePattern.matcher(text);
            if (m.find()) {
                cand = new TimeTool(m.group());
            } else {
                return null;
            }
        }
        if ((result = (qbe = new Query(Person.class, "Geburtsdatum", cand.toString(9))).execute()).size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return (Person)result.get(0);
        }
        String[] pp = new String[]{"Name", "Vorname"};
        String[] hits = new String[2];
        for (Person hit : result) {
            hit.get(pp, hits);
            if (!text.contains(hits[0]) || !text.contains(hits[1])) continue;
            return hit;
        }
        return null;
    }
}

