/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.inbox.model;

import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.TableLabelProvider;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.ungrad.AIUtil;
import ch.elexis.ungrad.StorageController;
import ch.elexis.ungrad.inbox.ui.Messages;
import ch.elexis.ungrad.lucinda.Client3;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.VersionedResource;
import jakarta.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.viewers.IStructuredContentProvider;

public class Controller
extends TableLabelProvider
implements IStructuredContentProvider {
    private StorageController sc = new StorageController();
    @Inject
    UISynchronize sync;

    public Object[] getElements(Object dirname) {
        Object[] files;
        File dir = new File((String)dirname);
        if (dir.exists() && (files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(".meta");
            }
        })) != null) {
            return files;
        }
        return new File[0];
    }

    public String getColumnText(Object element, int columnIndex) {
        return ((File)element).getName();
    }

    public void moveFileToDocbase(String concerns_id, File f, String destName, boolean bUseKI) throws Exception {
        File dir = this.sc.getOutputDirFor(concerns_id, true);
        File dest = new File(dir, destName);
        FileTool.copyFile((File)f, (File)dest, (int)2);
        File meta = new File(f.getAbsolutePath() + ".meta");
        if (meta.exists()) {
            meta.delete();
        }
        f.delete();
        if (bUseKI) {
            Job job = Job.create((String)"KI Analyze", monitor -> {
                try {
                    final Patient pat = Patient.load((String)concerns_id);
                    Client3 client = new Client3();
                    client.analyzeFile(FileTool.readFile((File)dest), new Client3.INotifier(){
                        StringBuilder sb = new StringBuilder();

                        public boolean received(String text) {
                            if (!StringTool.isNothing((Object)text) && text.length() > 3) {
                                this.sb.append(text);
                            } else {
                                try {
                                    String model = "gemma3:12b";
                                    String prompt = "Bitte erstelle eine Zusammenfassung aus folgendem Text: ";
                                    String response = AIUtil.sendPrompt((String)model, (String)(prompt + this.sb.toString()));
                                    Controller.this.addToEintrag(pat, response);
                                }
                                catch (Exception e) {
                                    ExHandler.handle((Throwable)e);
                                }
                            }
                            return false;
                        }
                    });
                }
                catch (Exception ex) {
                    SWTHelper.showError((String)Messages.Controller_Error_AICall, (String)ex.getMessage());
                }
            });
            job.schedule();
        }
    }

    private void addToEintrag(Patient pat, String text) throws Exception {
        Fall currentCase = pat.getLastKonsultation().getFall();
        Konsultation k = currentCase.neueKonsultation();
        VersionedResource eintrag = k.getEintrag();
        Samdas samdas = new Samdas(text);
        eintrag.update(samdas.toString(), "summary added by AI");
        k.setEintrag(eintrag, false);
    }
}

