/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.forms.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.dialogs.KontaktSelektor;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Query;
import ch.elexis.ungrad.forms.Activator;
import ch.elexis.ungrad.forms.model.Controller;
import ch.elexis.ungrad.forms.model.Template;
import ch.elexis.ungrad.forms.ui.DetailDisplay;
import ch.elexis.ungrad.forms.ui.DocumentList;
import ch.elexis.ungrad.forms.ui.Messages;
import ch.elexis.ungrad.forms.ui.SelectTemplateDialog;
import ch.elexis.ungrad.pdf.MappedForm;
import ch.elexis.ungrad.pdf.Medform;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class View
extends ViewPart
implements IActivationListener {
    private Controller controller = Activator.getController();
    private Action createNewAction;
    private Action showListAction;
    private Action showDetailAction;
    private Action printAction;
    private Action mailAction;
    private Action deleteAction;
    private Action signAction;
    private DocumentList docList;
    private DetailDisplay detail;
    private Composite container;
    private StackLayout stack = new StackLayout();
    private Template currentTemplate;
    private boolean bHasSignature;
    private IPatient currentPatient;
    @Inject
    private IContextService ctx;

    @Inject
    void activePatient(@Optional IPatient patient) {
        CoreUiUtil.runAsyncIfActive(() -> {
            if (patient != null) {
                this.setPatient(patient);
            }
        }, (Object)this.container);
    }

    public View() {
        String signature = CoreHub.localCfg.get("ch.elexis.ungrad.forms/signatureFile", null);
        if (signature != null && new File(signature).exists()) {
            this.bHasSignature = true;
        }
    }

    void setPatient(IPatient pat) {
        this.currentPatient = pat;
        this.docList.setPatient(pat);
        this.stack.topControl = this.docList;
        this.detail.clear();
        this.container.layout();
        this.setItemActions(this.docList.getSelection() != null);
    }

    private void setItemActions(boolean bMode) {
        this.printAction.setEnabled(bMode);
        this.mailAction.setEnabled(bMode);
        this.deleteAction.setEnabled(bMode);
        this.showDetailAction.setEnabled(bMode);
        this.signAction.setEnabled(bMode);
    }

    public void createPartControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)this.stack);
        this.docList = new DocumentList(this.container, this.controller);
        this.detail = new DetailDisplay(this.container, this.controller);
        this.makeActions();
        this.contributeToActionBars();
        this.stack.topControl = this.docList;
        this.container.layout();
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    public void dispose() {
        GlobalEventDispatcher.removeActivationListener((IActivationListener)this, (IWorkbenchPart)this);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IAction)this.createNewAction);
        toolbar.add((IContributionItem)new Separator());
        toolbar.add((IAction)this.showListAction);
        toolbar.add((IAction)this.showDetailAction);
        toolbar.add((IContributionItem)new Separator());
        if (this.bHasSignature) {
            toolbar.add((IAction)this.signAction);
        }
        toolbar.add((IAction)this.printAction);
        toolbar.add((IAction)this.mailAction);
        menu.add((IAction)this.createNewAction);
        menu.add((IAction)this.printAction);
        menu.add((IAction)this.mailAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.deleteAction);
        this.printAction.setEnabled(false);
        this.showDetailAction.setEnabled(false);
        this.mailAction.setEnabled(false);
        this.signAction.setEnabled(false);
        this.docList.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = event.getStructuredSelection();
                View.this.setItemActions(!sel.isEmpty());
            }
        });
        this.docList.addDoubleclickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                View.this.showDetailAction.run();
            }
        });
    }

    private String fillPdf(File templateFile) throws Error, Exception, IOException {
        File outDir = this.controller.getStorageController().getOutputDirFor(this.currentPatient.getId(), true);
        if (!outDir.exists() && !outDir.mkdirs()) {
            throw new Error(Messages.View_CantCreateOutputDir + outDir.getAbsolutePath());
        }
        String basename = "A_" + new TimeTool().toString(6) + "_" + templateFile.getName();
        File outFile = new File(outDir, basename);
        Medform medform = new Medform(templateFile.getAbsolutePath());
        Kontakt kRecipient = null;
        String outfilePath = "";
        if (medform.isMedform()) {
            outfilePath = medform.create(outFile.getAbsolutePath(), this.currentPatient);
            String recipient = medform.getFieldValue("receiverMail");
            Query qbe = new Query(Kontakt.class, "E-Mail", recipient);
            List found = qbe.execute();
            if (found.size() > 0) {
                kRecipient = (Kontakt)found.get(0);
            }
        } else {
            File mappingFile = new File(templateFile.getParent(), FileTool.getNakedFilename((String)templateFile.getName()) + ".map");
            if (mappingFile.exists()) {
                String raw = FileTool.readTextFile((File)mappingFile);
                MappedForm mapped = new MappedForm(templateFile.getAbsolutePath());
                outfilePath = mapped.create(outFile.getAbsolutePath(), raw);
            }
        }
        this.controller.createLinksWithElexis(outFile.getAbsolutePath(), kRecipient);
        return outfilePath;
    }

    private void makeActions() {
        this.createNewAction = new Action(Messages.View_Create){
            {
                this.setToolTipText(Messages.View_CreateNewDocument);
                this.setImageDescriptor(Images.IMG_NEW.getImageDescriptor());
                this.setText(Messages.View_New);
            }

            public void run() {
                SelectTemplateDialog std = new SelectTemplateDialog(View.this.getViewSite().getShell());
                if (std.open() == 0) {
                    File templateFile = std.result;
                    try {
                        if (templateFile.getName().endsWith("pdf")) {
                            String outFile = View.this.fillPdf(templateFile);
                            View.this.controller.launchPDFViewerFor(outFile);
                        } else {
                            Kontakt adressat = null;
                            String html = FileTool.readTextFile((File)templateFile);
                            if (templateFile.getName().endsWith("pug")) {
                                String dir = templateFile.getParent();
                                html = View.this.controller.convertPug(html, dir);
                            }
                            if (html.contains("[Adressat")) {
                                KontaktSelektor ksd = new KontaktSelektor(View.this.getSite().getShell(), Kontakt.class, Messages.View_Receiver, Messages.View_PleaseSelectReceiver, new String[]{"Bezeichnung1", "Bezeichnung2"});
                                if (ksd.open() != 0) {
                                    return;
                                }
                                adressat = (Kontakt)ksd.getSelection();
                            }
                            View.this.currentTemplate = new Template(html, adressat);
                            View.this.detail.show(View.this.currentTemplate);
                            View.this.printAction.setEnabled(true);
                            View.this.mailAction.setEnabled(true);
                            View.this.stack.topControl = View.this.detail;
                            View.this.container.layout();
                        }
                        View.this.docList.setPatient(View.this.currentPatient);
                    }
                    catch (Exception e) {
                        ExHandler.handle((Throwable)e);
                        SWTHelper.showError((String)Messages.View_OutputError, (String)e.getMessage());
                    }
                }
            }
        };
        this.showListAction = new Action(Messages.View_Doclist){
            {
                this.setText(Messages.View_Documents);
                this.setImageDescriptor(Images.IMG_DOCUMENT_STACK.getImageDescriptor());
                this.setToolTipText(Messages.View_ShowListOfDocuments);
            }

            public void run() {
                View.this.stack.topControl = View.this.docList;
                View.this.setItemActions(View.this.docList.getSelection() != null);
                View.this.container.layout();
            }
        };
        this.showDetailAction = new Action(Messages.View_Form){
            {
                this.setText(Messages.View_Completion);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.View_ShowCurrentForm);
            }

            public void run() {
                try {
                    File dir = View.this.controller.getStorageController().getOutputDirFor(null, true);
                    File document = new File(dir, View.this.docList.getSelection() + ".html");
                    if (document.exists()) {
                        String html = FileTool.readTextFile((File)document);
                        View.this.currentTemplate = new Template(html, null);
                        View.this.currentTemplate.setFilename(document.getAbsolutePath());
                        View.this.stack.topControl = View.this.detail;
                        View.this.detail.show(View.this.currentTemplate);
                    } else {
                        View.this.stack.topControl = View.this.docList;
                        View.this.controller.showPDF(null, View.this.docList.getSelection());
                    }
                }
                catch (Exception ex) {
                    SWTHelper.showError((String)Messages.View_ErrorProcessing, (String)ex.getMessage());
                }
                View.this.signAction.setEnabled(false);
                View.this.printAction.setEnabled(true);
                View.this.mailAction.setEnabled(true);
                View.this.container.layout();
            }
        };
        this.printAction = new Action(Messages.View_Output_Heading){
            {
                this.setText(Messages.View_Output_Text);
                this.setImageDescriptor(Images.IMG_DOCUMENT_PDF.getImageDescriptor());
                this.setToolTipText(Messages.View_CreateAndOutput);
            }

            public void run() {
                if (View.this.stack.topControl.equals((Object)View.this.detail)) {
                    View.this.detail.output();
                } else if (View.this.stack.topControl.equals((Object)View.this.docList)) {
                    View.this.docList.output();
                }
            }
        };
        this.mailAction = new Action(Messages.View_SendByMail){
            {
                this.setText(Messages.View_Send_Header);
                this.setImageDescriptor(Images.IMG_MAIL_SEND.getImageDescriptor());
                this.setToolTipText(Messages.View_SendAsPDFByMail);
            }

            public void run() {
                if (View.this.stack.topControl.equals((Object)View.this.detail)) {
                    View.this.detail.sendMail();
                } else if (View.this.stack.topControl.equals((Object)View.this.docList)) {
                    View.this.docList.sendMail();
                }
            }
        };
        this.signAction = new Action("Unterschreiben"){
            {
                this.setText("Dokument signieren");
                this.setImageDescriptor(Images.IMG_PERSON_OK.getImageDescriptor());
                this.setToolTipText("Das ausgew\u00e4hlte DOkument unterschreiben");
            }

            public void run() {
                if (View.this.stack.topControl.equals((Object)View.this.docList)) {
                    View.this.docList.sign();
                }
            }
        };
        this.deleteAction = new Action(Messages.View_Delete_Header){
            {
                this.setText(Messages.View_Delete_Text);
                this.setImageDescriptor(Images.IMG_DELETE.getImageDescriptor());
                this.setToolTipText(Messages.View_DeleteDocument);
            }

            public void run() {
                try {
                    String sel = View.this.docList.getSelection();
                    if (SWTHelper.askYesNo((String)Messages.View_PleaseConfirm, (String)(sel + Messages.View_ReallyDelete))) {
                        View.this.controller.delete(sel, View.this.currentPatient);
                        View.this.docList.setPatient(View.this.currentPatient);
                    }
                }
                catch (Exception e) {
                    ExHandler.handle((Throwable)e);
                    SWTHelper.showError((String)Messages.View_ErrorDeleting, (String)e.getMessage());
                }
            }
        };
    }

    public void setFocus() {
    }

    public void activation(boolean mode) {
        if (mode) {
            IPatient sel = this.ctx.getActivePatient().orElse(null);
            if (sel == null || this.currentPatient == null || sel.getId() != this.currentPatient.getId()) {
                this.setPatient(sel);
            }
        } else {
            try {
                if (this.stack.topControl.equals((Object)this.detail)) {
                    this.detail.saveHtml();
                }
            }
            catch (Exception ex) {
                SWTHelper.showError((String)Messages.View_ErrorSaving, (String)ex.getMessage());
            }
        }
    }

    public void visible(boolean mode) {
        System.out.print("Visible " + mode);
    }
}

