/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.forms.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.DefaultLabelProvider;
import ch.elexis.ungrad.forms.ui.Messages;
import ch.rgw.io.FileTool;
import ch.rgw.tools.StringTool;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectTemplateDialog
extends TitleAreaDialog {
    TableViewer tv;
    File result;
    String templateDir = CoreHub.localCfg.get("ch.elexis.ungrad.forms/templateDir", "");
    Text tFilter;

    public SelectTemplateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new GridLayout());
        final Filter filter = new Filter();
        this.tFilter = new Text(ret, 2176);
        this.tFilter.setLayoutData((Object)SWTHelper.getFillGridData());
        this.tFilter.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                filter.setText(SelectTemplateDialog.this.tFilter.getText());
                super.keyReleased(e);
                SelectTemplateDialog.this.tv.refresh();
            }
        });
        this.tv = new TableViewer(ret, 512);
        this.tv.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object dir) {
                Object[] templates = ((File)dir).list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String ext = FileTool.getExtension((String)name).toLowerCase();
                        return ext.equals("pug") || ext.equals("html") || ext.equals("pdf");
                    }
                });
                if (templates == null) {
                    return new String[0];
                }
                return templates;
            }
        });
        this.tv.setLabelProvider((IBaseLabelProvider)new DefaultLabelProvider());
        this.tv.setComparator(new ViewerComparator());
        this.tv.addFilter((ViewerFilter)filter);
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectTemplateDialog.this.okPressed();
            }
        });
        this.tv.setInput((Object)new File(this.templateDir));
        return ret;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.SelectTemplateDialog_SelectForm);
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.tv.getSelection();
        if (sel != null && !sel.isEmpty()) {
            this.result = new File(this.templateDir, (String)sel.getFirstElement());
        }
        super.okPressed();
    }

    class Filter
    extends ViewerFilter {
        private String filterText;

        Filter() {
        }

        void setText(String text) {
            this.filterText = text.toLowerCase();
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (StringTool.isNothing((Object)this.filterText)) {
                return true;
            }
            String ob = ((String)element).toLowerCase();
            return ob.contains(this.filterText);
        }
    }
}

