/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.forms.ui;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.common.ui.MailUI;
import ch.elexis.ungrad.forms.model.Controller;
import ch.elexis.ungrad.forms.model.Template;
import ch.elexis.ungrad.forms.ui.Messages;
import ch.elexis.ungrad.pdf.Medform;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import java.io.File;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DocumentList
extends Composite {
    private TableViewer tv;
    private Controller controller;
    private IContextService contextService = ContextServiceHolder.get();

    public DocumentList(Composite parent, Controller controller) {
        super(parent, 0);
        this.controller = controller;
        this.setLayoutData(SWTHelper.getFillGridData());
        this.setLayout((Layout)new GridLayout());
        this.tv = new TableViewer((Composite)this);
        this.tv.setContentProvider((IContentProvider)controller);
        this.tv.setLabelProvider((IBaseLabelProvider)controller);
        this.tv.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((String)e2).compareTo((String)e1);
            }
        });
        if (this.contextService.getActivePatient().isPresent()) {
            this.tv.setInput(this.contextService.getActivePatient().get());
        }
        this.tv.getControl().setLayoutData((Object)SWTHelper.getFillGridData());
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        this.tv.addSelectionChangedListener(listener);
    }

    public void addDoubleclickListener(IDoubleClickListener listener) {
        this.tv.addDoubleClickListener(listener);
    }

    public String getSelection() {
        IStructuredSelection sel = this.tv.getStructuredSelection();
        if (sel.isEmpty()) {
            return null;
        }
        return (String)sel.getFirstElement();
    }

    public void sign() {
        String sel = this.getSelection();
        if (sel != null) {
            try {
                File dir = this.controller.getStorageController().getOutputDirFor(null, false);
                File file = new File(dir, sel + ".pdf");
                this.controller.signPDF(file);
                this.tv.refresh();
            }
            catch (Exception e) {
                SWTHelper.showError((String)"Fehler beim Signieren", (String)e.getMessage());
                ExHandler.handle((Throwable)e);
            }
        }
    }

    public void sendMail() {
        IStructuredSelection sel = this.tv.getStructuredSelection();
        if (!sel.isEmpty()) {
            String selected = (String)sel.getFirstElement();
            try {
                File dir = this.controller.getStorageController().getOutputDirFor(null, false);
                if (dir.exists()) {
                    File outfile = new File(dir, selected + ".pdf");
                    File templateFile = new File(dir, selected + ".html");
                    String subject = selected;
                    String body = CoreHub.localCfg.get("ch.elexis.ungrad.forms/defaultMailBody", Messages.DocumentList_MessageBodyDefault);
                    String recipient = "";
                    if (templateFile.exists()) {
                        Template template = new Template(FileTool.readTextFile((File)templateFile), null);
                        subject = template.getMailSubject();
                        body = template.getMailBody();
                        recipient = template.getMailRecipient();
                    } else if (outfile.exists()) {
                        Medform medform = new Medform(outfile.getAbsolutePath());
                        recipient = medform.getFieldValue("receiverMail");
                    }
                    MailUI mailer = new MailUI(this.getShell());
                    mailer.sendMail(subject, body, recipient, outfile.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.DocumentList_PrintError, (String)ex.getMessage());
            }
        }
    }

    public String output() {
        String selected = this.getSelection();
        if (selected != null) {
            try {
                this.controller.showPDF(null, selected);
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.DocumentList_CreateError, (String)ex.getMessage());
            }
        }
        return null;
    }

    void setPatient(IPatient pat) {
        this.tv.setInput((Object)pat);
    }
}

