/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.forms.ui;

import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.common.ui.MailUI;
import ch.elexis.ungrad.forms.model.Controller;
import ch.elexis.ungrad.forms.model.Template;
import ch.elexis.ungrad.forms.ui.Messages;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DetailDisplay
extends Composite {
    ScrolledForm form;
    Composite inlay;
    Template template;
    Controller controller;

    public DetailDisplay(Composite parent, Controller controller) {
        super(parent, 0);
        this.controller = controller;
        this.setLayoutData(SWTHelper.getFillGridData());
        this.setLayout((Layout)new FillLayout());
        FormToolkit tk = new FormToolkit(this.getDisplay());
        this.form = tk.createScrolledForm((Composite)this);
        Composite body = this.form.getBody();
        body.setLayout((Layout)new GridLayout());
        this.inlay = new Composite(body, 512);
        this.inlay.setLayoutData((Object)SWTHelper.getFillGridData());
        body.setBackground(new Color((Device)this.getDisplay(), 100, 100, 100));
        this.inlay.setBackground(new Color((Device)this.getDisplay(), 200, 200, 200));
        this.inlay.setLayout((Layout)new GridLayout());
    }

    void clear() {
        Control[] controlArray = this.inlay.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.form.setText("");
    }

    void show(Template template) {
        this.template = template;
        this.clear();
        this.form.setText(template.getTitle());
        for (Map.Entry<String, String> e : template.getInputs().entrySet()) {
            Label label = new Label(this.inlay, 0);
            label.setText(e.getKey());
            label.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)false));
            Text text = new Text(this.inlay, 2050);
            text.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
            String val = e.getValue();
            val = val.replace("<br />", "\n");
            text.setText(val);
            text.setData("input", (Object)e.getKey());
        }
        this.inlay.layout();
    }

    File saveHtml() throws Exception {
        Control[] controlArray = this.inlay.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            Object k = c.getData("input");
            if (k instanceof String) {
                String val = ((Text)c).getText().replaceAll("\n", "<br />");
                this.template.setInput((String)k, val);
            }
            ++n2;
        }
        return this.controller.writeHTML(this.template);
    }

    public String output() {
        try {
            File htmlFile = this.saveHtml();
            String pdffile = this.controller.createPDF(htmlFile, this.template);
            this.controller.launchPDFViewerFor(pdffile);
            return pdffile;
        }
        catch (Exception e) {
            SWTHelper.showError((String)Messages.DetailDisplay_OutputError, (String)e.getMessage());
            ExHandler.handle((Throwable)e);
            return null;
        }
    }

    public void sendMail() {
        MailUI mailer = new MailUI(this.getShell());
        String subject = this.template.getMailSubject();
        String body = this.template.getMailBody();
        String recipient = this.template.getMailRecipient();
        mailer.sendMail(subject, body, recipient, this.output());
    }
}

