/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.forms.model;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.LocalLockServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.TableLabelProvider;
import ch.elexis.data.Anwender;
import ch.elexis.data.Brief;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Query;
import ch.elexis.data.User;
import ch.elexis.ungrad.StorageController;
import ch.elexis.ungrad.forms.model.Messages;
import ch.elexis.ungrad.forms.model.Template;
import ch.elexis.ungrad.pdf.Manager;
import ch.elexis.ungrad.pdf.Signer;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public class Controller
extends TableLabelProvider
implements IStructuredContentProvider {
    IContextService contextService = ContextServiceHolder.get();
    StorageController sc = new StorageController();
    IConfigService cfg = ConfigServiceHolder.get();

    public Object[] getElements(Object inputElement) {
        IPatient pat = (IPatient)inputElement;
        if (pat == null) {
            return new String[0];
        }
        try {
            File dir = this.sc.getOutputDirFor(pat.getId(), true);
            String[] files = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (name.startsWith("A_")) {
                        String ext = FileTool.getExtension((String)name);
                        return ext.equalsIgnoreCase("pdf") || ext.equalsIgnoreCase("html");
                    }
                    return false;
                }
            });
            if (files == null) {
                return new String[0];
            }
            LinkedHashSet<String> deduplicated = new LinkedHashSet<String>();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                deduplicated.add(FileTool.getNakedFilename((String)file));
                ++n2;
            }
            Object[] ret = deduplicated.toArray(new String[0]);
            return ret;
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            return new String[]{Messages.Controller_ErrorReadingDirectory};
        }
    }

    public String getColumnText(Object element, int columnIndex) {
        return (String)element;
    }

    public StorageController getStorageController() {
        return this.sc;
    }

    public Brief getCorrespondingBrief(String item, IPatient patient) {
        Pattern pat = Pattern.compile("A_([0-9]{4,4}-[0-1][0-9]-[0-3][0-9])_(.+)");
        Matcher m = pat.matcher(item);
        if (m.matches()) {
            String date = m.group(1).replace("-", Messages.Controller_6);
            String title = m.group(2);
            Query qbe = new Query(Brief.class);
            qbe.add("Betreff", "=", title);
            qbe.add("Datum", "=", date);
            qbe.add("PatientID", "=", patient.getId());
            List briefe = qbe.execute();
            if (briefe.size() > 0) {
                return (Brief)briefe.get(0);
            }
        }
        return null;
    }

    public File writeHTML(Template tmpl) throws Exception {
        File htmlFile;
        Object filename = tmpl.getFilename();
        Object prefix = Messages.Controller_7;
        if (StringTool.isNothing((Object)filename)) {
            Kontakt adressat;
            String doctitle;
            String doctype = tmpl.getDoctype();
            if (!StringTool.isNothing((Object)doctype)) {
                tmpl.replace("Doctype", doctype);
            }
            if (!StringTool.isNothing((Object)(doctitle = tmpl.getTitle()))) {
                tmpl.replace("Doctitle", doctitle);
            }
            filename = new TimeTool().toString(5);
            prefix = "A_" + new TimeTool().toString(6) + Messages.Controller_11;
            if (!StringTool.isNothing((Object)tmpl.getTitle())) {
                prefix = (String)prefix + tmpl.getTitle() + Messages.Controller_12;
            }
            if ((adressat = tmpl.getAdressat()) != null) {
                filename = (String)prefix + adressat.get("Bezeichnung1") + Messages.Controller_13 + adressat.get("Bezeichnung2");
            } else {
                String name = Messages.Controller_Output;
                filename = (String)prefix + name;
            }
            IPatient pat = (IPatient)this.contextService.getActivePatient().get();
            File dir = this.sc.getOutputDirFor(pat.getId(), true);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new Exception(Messages.Controller_CouldNotCreateDir + dir.getAbsolutePath());
            }
            htmlFile = new File(dir, (String)filename + ".html");
        } else {
            htmlFile = new File((String)filename);
        }
        String content = tmpl.getXml();
        FileTool.writeTextFile((File)htmlFile, (String)content);
        return htmlFile;
    }

    public String createPDF(File htmlFile, Template template) throws Exception {
        Manager pdf = new Manager();
        File pdfFile = new File(htmlFile.getParent(), FileTool.getNakedFilename((String)htmlFile.getName()) + ".pdf");
        pdf.createPDF(htmlFile, pdfFile);
        String outputFile = pdfFile.getAbsolutePath();
        Brief meta = template.getBrief();
        if (meta == null) {
            meta = this.createLinksWithElexis(outputFile, template.getAdressat());
            template.setBrief(meta);
        } else {
            meta.save(FileTool.readFile((File)pdfFile), "pdf");
        }
        return outputFile;
    }

    public String showPDF(IPatient pat, String title) throws Exception {
        File outfile;
        File dir;
        if (pat == null) {
            pat = (IPatient)this.contextService.getActivePatient().get();
        }
        if ((dir = this.sc.getOutputDirFor(pat.getId(), false)).exists() && (outfile = new File(dir, title + ".pdf")).exists()) {
            Brief brief = this.getCorrespondingBrief(title, pat);
            if (brief != null && brief.exists()) {
                long lBrief = brief.getLastUpdate();
                long lPdf = outfile.lastModified();
                if (lPdf - lBrief > 1000L) {
                    brief.save(FileTool.readFile((File)outfile), "pdf");
                }
            }
            String filepath = outfile.getAbsolutePath();
            String viewer = this.cfg.getLocal("ch.elexis.ungrad.forms/pdfViewer", Messages.Controller_21);
            if (!StringTool.isNothing((Object)viewer)) {
                this.asyncRunViewer(viewer, outfile, brief);
            } else {
                Program.launch((String)filepath);
            }
            return filepath;
        }
        return null;
    }

    public Brief createLinksWithElexis(String filepath, Kontakt adressat) throws Exception {
        String briefTitle = FileTool.getNakedFilename((String)filepath);
        if (briefTitle.matches("A_[0-9]{4,4}-[0-1][0-9]-[0-3][0-9]_.+")) {
            briefTitle = briefTitle.substring(13);
        }
        IUser user = (IUser)this.contextService.getActiveUser().get();
        User u = User.load((String)user.getId());
        Anwender actUser = u.getAssignedContact();
        Optional current = this.contextService.getTyped(IEncounter.class);
        if (current.isEmpty()) {
            throw new Exception("Konsultation w\u00e4hlen, zu der dieses Formular geh\u00f6rt");
        }
        Konsultation kons = Konsultation.load((String)((IEncounter)current.get()).getId());
        Brief metadata = new Brief(briefTitle, new TimeTool(), (Kontakt)actUser, adressat, kons, "Formular");
        metadata.save(FileTool.readFile((File)new File(filepath)), "pdf");
        this.addFormToKons(metadata, kons);
        return metadata;
    }

    private void addFormToKons(Brief brief, Konsultation kons) {
        LockResponse lr;
        if (kons != null && (lr = LocalLockServiceHolder.get().acquireLockBlocking((Object)kons, 1, (IProgressMonitor)new NullProgressMonitor())).isOk()) {
            String label = "[ " + brief.getLabel().replace("_", " ") + " ]";
            kons.addXRef("ch.elexis.ungrad.Forms", brief.getId(), -1, label);
            LocalLockServiceHolder.get().releaseLock((Object)kons);
        }
    }

    public String convertPug(String pug, String dir) throws Exception {
        String line;
        dir = (String)dir + File.separator + "x";
        String pugbin = this.cfg.getLocal("ch.elexis.ungrad.forms/pugCompiler", "pug");
        Process process = new ProcessBuilder(new String[]{pugbin, "-p", dir}).start();
        InputStreamReader err = new InputStreamReader(process.getErrorStream());
        BufferedReader burr = new BufferedReader(err);
        InputStreamReader ir = new InputStreamReader(process.getInputStream());
        BufferedReader br = new BufferedReader(ir);
        OutputStreamWriter ow = new OutputStreamWriter(process.getOutputStream());
        ow.write(pug);
        ow.close();
        StringBuilder sb = new StringBuilder();
        StringBuilder serr = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        while ((line = burr.readLine()) != null) {
            serr.append(line);
        }
        String errmsg = serr.toString();
        if (StringTool.isNothing((Object)errmsg)) {
            return sb.toString();
        }
        throw new Error(errmsg);
    }

    public void delete(String item, IPatient pat) throws Exception {
        Brief brief;
        File dir = this.sc.getOutputDirFor(pat.getId(), false);
        if (dir.exists()) {
            File htmlFile = new File(dir, item + ".html");
            File pdfFile = new File(dir, item + ".pdf");
            if (pdfFile.exists()) {
                pdfFile.delete();
            }
            if (htmlFile.exists()) {
                htmlFile.delete();
            }
        }
        if ((brief = this.getCorrespondingBrief(item, pat)) != null && brief.exists()) {
            Konsultation k = Konsultation.load((String)brief.get("BehandlungsID"));
            if (k.exists()) {
                k.removeXRef("ch.elexis.ungrad.Forms", brief.getId());
            }
            brief.delete();
        }
    }

    public void delete(Brief brief) throws Exception {
        TimeTool tt = new TimeTool(brief.getDatum());
        String basename = "A_" + tt.toString(6) + "_" + brief.getBetreff();
        this.delete(basename, (IPatient)brief.getPatient());
    }

    void asyncRunViewer(final String viewer, final File pdf, final Brief brief) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    pdf.lastModified();
                    Runtime.getRuntime().exec(new String[]{viewer, pdf.getAbsolutePath()});
                    if (brief != null && brief.isValid()) {
                        brief.save(FileTool.readFile((File)pdf), "pdf");
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.showError((String)Messages.Controller_CouldNotCreateFile, (String)ex.getMessage());
                }
            }
        });
    }

    public void launchPDFViewerFor(String pdf) throws Exception {
        String viewer = this.cfg.getLocal("ch.elexis.ungrad.forms/pdfViewer", Messages.Controller_21);
        if (!StringTool.isNothing((Object)viewer)) {
            this.asyncRunViewer(viewer, new File(pdf), null);
        }
    }

    public void signPDF(File pdfFile) throws Exception {
        Signer signer = new Signer();
        String imgFile = CoreHub.localCfg.get("ch.elexis.ungrad.forms/signatureFile", null);
        int x = CoreHub.localCfg.get("ch.elexis.ungrad.forms/signatureX", 10);
        int y = CoreHub.localCfg.get("ch.elexis.ungrad.forms/signatureY", 30);
        if (imgFile != null) {
            signer.sign(pdfFile.getAbsolutePath(), imgFile, x, y);
        }
    }
}

