/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.lucinda.omnivore;

import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.ungrad.lucinda.Activator;
import ch.elexis.ungrad.lucinda.Preferences;
import ch.elexis.ungrad.lucinda.controller.IProgressController;
import ch.elexis.ungrad.lucinda.model.Customer;
import ch.elexis.ungrad.lucinda.model.Sender;
import ch.elexis.ungrad.lucinda.omnivore.DocHandle;
import ch.rgw.tools.JdbcLink;
import ch.rgw.tools.TimeTool;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmnivoreIndexer
implements Customer {
    Logger log = LoggerFactory.getLogger(OmnivoreIndexer.class);
    private boolean cont = false;
    private boolean bMove = false;
    private IProgressController pc;
    Long progressHandle;
    private long lastCheck;

    public void setActive(boolean bActive) {
        this.cont = bActive;
    }

    public void start(IProgressController pc) {
        this.pc = pc;
        try {
            this.lastCheck = Long.parseLong(Preferences.get((String)"ch.rgw.docmgr-lucinda.omniLast", (String)"0"));
        }
        catch (NumberFormatException numberFormatException) {
            this.lastCheck = 0L;
        }
        this.bMove = Preferences.is((String)"ch.rgw.docmgr-lucinda.omnivore_MoveFiles");
        StringBuilder querySQL = new StringBuilder("SELECT ID FROM ").append("CH_ELEXIS_OMNIVORE_DATA").append(" WHERE lastupdate >=").append(this.lastCheck);
        String excludes = Preferences.get((String)"ch.rgw.docmgr-lucinda.omnivore_excludeCat", (String)"");
        if (excludes.length() > 0) {
            String[] ex;
            String[] stringArray = ex = excludes.split(",");
            int n = ex.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                querySQL.append(" AND Category <>").append(JdbcLink.wrap((String)e));
                ++n2;
            }
        }
        querySQL.append(" AND deleted='0' ORDER BY ").append("lastupdate");
        Query qbe = new Query(DocHandle.class);
        Collection docs = qbe.queryExpression(querySQL.toString(), new LinkedList());
        this.progressHandle = pc.initProgress(docs.size());
        this.setActive(true);
        Sender sender = new Sender((Customer)this, (List)docs, this.bMove);
        sender.schedule();
    }

    public Map specify(PersistentObject po) {
        DocHandle dh = (DocHandle)po;
        if (this.cont) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            Patient patient = dh.getPatient();
            String bdRaw = this.getSafe((PersistentObject)patient, "Geburtsdatum");
            String lastname = this.getSafe((PersistentObject)patient, "Name");
            String firstname = this.getSafe((PersistentObject)patient, "Vorname");
            String birthdate = new TimeTool(bdRaw).toString(4);
            String docdate = new TimeTool(dh.getCreationDate()).toString(9);
            if (dh.getLastUpdate() > this.lastCheck) {
                this.lastCheck = dh.getLastUpdate();
                Preferences.set((String)"ch.rgw.docmgr-lucinda.omniLast", (String)Long.toString(this.lastCheck));
            }
            StringBuilder concern = new StringBuilder().append(lastname).append("_").append(firstname).append("_").append(birthdate);
            meta.put("lastname", lastname);
            meta.put("firstname", firstname);
            meta.put("birthdate", birthdate);
            meta.put("date", docdate);
            meta.put("category", dh.getCategory());
            meta.put("keywords", dh.getKeywords());
            meta.put("concern", concern.toString());
            meta.put("payload", dh.getContents());
            meta.put("concern", concern.toString());
            meta.put("title", dh.getTitle());
            meta.put("type", Preferences.OMNIVORE_NAME);
            meta.put("filetype", dh.getMimetype());
            this.pc.addProgress(this.progressHandle, 1);
            return meta;
        }
        this.pc.addProgress(this.progressHandle, Integer.MAX_VALUE);
        return null;
    }

    private String getSafe(PersistentObject po, String field) {
        String ret = po.get(field);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public void finished(List<Map<String, Object>> messages) {
        Activator.getDefault().addMessages(messages);
        Preferences.cfg.flush();
    }

    public void success(String id) {
        DocHandle dh;
        if (this.bMove && (dh = DocHandle.load(id)) != null && dh.isValid()) {
            dh.delete();
        }
    }
}

