/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.lucinda.omnivore;

import ch.elexis.core.exceptions.ElexisException;
import ch.elexis.core.exceptions.PersistenceException;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.omnivore.data.Messages;
import ch.elexis.omnivore.data.Preferences;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import org.eclipse.swt.program.Program;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocHandle
extends PersistentObject {
    private static final String CATEGORY_MIMETYPE = "text/category";
    private static Logger log = LoggerFactory.getLogger(DocHandle.class);
    private TimeTool toStringTool = new TimeTool();
    private static final String FLD_CAT = "Cat";
    private static final String FLD_TITLE = "Titel";
    private static final String FLD_MIMETYPE = "Mimetype";
    private static final String FLD_DOC = "Doc";
    public static final String FLD_PATH = "Path";
    private static final String FLD_KEYWORDS = "Keywords";
    private static final String FLD_PATID = "PatID";
    private static final String FLD_CREATION_DATE = "CreationDate";
    static final String TABLENAME = "CH_ELEXIS_OMNIVORE_DATA";

    static {
        DocHandle.addMapping((String)TABLENAME, (String[])new String[]{FLD_PATID, "Cat=Category", "Datum=S:D:Datum", "CreationDate=S:D:CreationDate", "Titel=Title", FLD_KEYWORDS, FLD_PATH, FLD_DOC, FLD_MIMETYPE});
        DocHandle.load("1");
    }

    public String getTableName() {
        return TABLENAME;
    }

    public DocHandle(String id) {
        super(id);
    }

    public DocHandle() {
    }

    public static DocHandle load(String id) {
        return new DocHandle(id);
    }

    private File getStorageFile(boolean force) {
        if (force || Preferences.storeInFilesystem()) {
            File dir;
            String pathname = Preferences.getBasepath();
            if (pathname != null && (dir = new File(pathname)).isDirectory()) {
                Patient pat = Patient.load((String)this.get(FLD_PATID));
                File subdir = new File(dir, pat.getPatCode());
                if (!subdir.exists()) {
                    subdir.mkdir();
                }
                File file = new File(subdir, this.getId() + "." + FileTool.getExtension((String)this.get(FLD_MIMETYPE)));
                return file;
            }
            if (Preferences.storeInFilesystem()) {
                log.warn("config error");
            }
        }
        return null;
    }

    private String getCategoryName() {
        return DocHandle.checkNull((Object)this.get(FLD_CAT));
    }

    private boolean isCategory() {
        return this.get(FLD_MIMETYPE).equals(CATEGORY_MIMETYPE);
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        String date = this.get("Datum");
        if (date != null && !date.isEmpty()) {
            sb.append(this.get("Datum"));
            sb.append(" ");
        }
        sb.append(this.get(FLD_TITLE));
        return sb.toString();
    }

    String getTitle() {
        return this.get(FLD_TITLE);
    }

    String getKeywords() {
        return this.get(FLD_KEYWORDS);
    }

    public String getDate() {
        String date = this.get("Datum");
        this.toStringTool.set(date);
        return this.toStringTool.toString(4);
    }

    public String getCreationDate() {
        String date = this.get(FLD_CREATION_DATE);
        this.toStringTool.set(date);
        return this.toStringTool.toString(4);
    }

    byte[] getContents() {
        File file;
        byte[] ret = this.getBinary(FLD_DOC);
        if (ret == null && (file = this.getStorageFile(true)) != null) {
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(file.toURI()));
                if (!Preferences.storeInFilesystem()) {
                    try {
                        this.setBinary(FLD_DOC, bytes);
                    }
                    catch (PersistenceException pe) {
                        SWTHelper.showError((String)Messages.DocHandle_readErrorCaption, (String)(Messages.DocHandle_importErrorText + "; " + pe.getMessage()));
                    }
                }
                return bytes;
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.DocHandle_readErrorHeading, (String)Messages.DocHandle_importError2, (String)MessageFormat.format(Messages.DocHandle_importErrorText2 + ex.getMessage(), file.getAbsolutePath()));
            }
        }
        return ret;
    }

    public void execute() {
        try {
            String ext = " ";
            File temp = this.createTemporaryFile(this.getTitle());
            log.debug("execute {} readable {}", (Object)temp.getAbsolutePath(), (Object)Files.isReadable(temp.toPath()));
            Program proggie = Program.findProgram((String)ext);
            if (proggie != null) {
                proggie.execute(temp.getAbsolutePath());
            } else if (!Program.launch((String)temp.getAbsolutePath())) {
                Runtime.getRuntime().exec(temp.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)"Kann Dokument nicht \u00f6ffnen", (String)ex.getMessage());
        }
    }

    public File createTemporaryFile(String title) {
        String fileExtension = FileTool.getExtension((String)this.get(FLD_TITLE));
        if (fileExtension == null) {
            fileExtension = "";
        }
        try {
            String cleanTitle;
            Path tmpDir = Files.createTempDirectory("elexis", new FileAttribute[0]);
            File temp = File.createTempFile("omni", "tmp");
            temp = title != null && !title.isEmpty() ? (!(cleanTitle = title.replaceAll(Matcher.quoteReplacement("[\\:/:*?()+,';\"\r\t\n\u00b4`<>]"), "_")).toLowerCase().contains("." + fileExtension.toLowerCase()) ? new File(tmpDir.toString(), cleanTitle + "." + fileExtension) : new File(tmpDir.toString(), cleanTitle)) : Files.createTempFile(tmpDir, "omni_", "_vore." + fileExtension, new FileAttribute[0]).toFile();
            tmpDir.toFile().deleteOnExit();
            temp.deleteOnExit();
            byte[] b = this.getContents();
            if (b == null) {
                SWTHelper.showError((String)Messages.DocHandle_readErrorCaption2, (String)Messages.DocHandle_loadErrorText);
                return temp;
            }
            Throwable throwable = null;
            Object var7_10 = null;
            try (FileOutputStream fos = new FileOutputStream(temp);){
                fos.write(b);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            log.debug("createTemporaryFile {} size {} ext {} ", new Object[]{temp.getAbsolutePath(), Files.size(temp.toPath()), fileExtension});
            return temp;
        }
        catch (FileNotFoundException e) {
            log.debug("File not found " + String.valueOf(e), (Object)3);
        }
        catch (IOException e) {
            log.debug("Error creating file " + String.valueOf(e), (Object)3);
        }
        return null;
    }

    public String getMimetype() {
        return this.get(FLD_MIMETYPE);
    }

    public String getCategory() {
        return this.getCategoryName();
    }

    public String getMimeType() {
        return DocHandle.checkNull((Object)this.get(FLD_MIMETYPE));
    }

    public Patient getPatient() {
        return Patient.load((String)this.get(FLD_PATID));
    }

    public InputStream getContentsAsStream() throws ElexisException {
        return new ByteArrayInputStream(this.getContents());
    }

    public byte[] getContentsAsBytes() throws ElexisException {
        return this.getContents();
    }

    public String getGUID() {
        return this.getId();
    }
}

