/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.lucinda.view;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.ui.actions.GlobalEventDispatcher;
import ch.elexis.core.ui.actions.IActivationListener;
import ch.elexis.core.ui.actions.RestrictedAction;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.ungrad.lucinda.Activator;
import ch.elexis.ungrad.lucinda.IDocumentHandler;
import ch.elexis.ungrad.lucinda.Preferences;
import ch.elexis.ungrad.lucinda.controller.Controller;
import ch.elexis.ungrad.lucinda.view.Messages;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class GlobalView
extends ViewPart
implements IActivationListener {
    private Controller controller;
    private Action doubleClickAction;
    private Action filterCurrentPatAction;
    private Action showInboxAction;
    private Action rescanAction;
    private Action showDirectoryAction;
    private Action[] aquireActions;
    private List<IDocumentHandler> addons;
    private List<IAction> addonActions = new ArrayList<IAction>();
    @Inject
    private IConfigService cfg;
    @Inject
    private IContextService ctx = ContextServiceHolder.get();

    @Inject
    void selectedPatient(@Optional IPatient pat) {
        if (pat != null) {
            CoreUiUtil.runAsyncIfActive(() -> this.controller.changePatient(java.util.Optional.of(pat)), (Object)this.controller.getTopControl());
        }
    }

    public GlobalView() {
        this.controller = new Controller();
        this.addons = Activator.getDefault().getAddons();
    }

    public void createPartControl(Composite parent) {
        if (!(this.is("ch.rgw.docmgr-lucinda.showConsultation") || this.is("ch.rgw.docmgr-lucinda.showInbox") || this.is("ch.rgw.docmgr-lucinda.showOmnivore"))) {
            this.save("ch.rgw.docmgr-lucinda.showConsultation", true);
            this.save("ch.rgw.docmgr-lucinda.showOmnivore", true);
            this.save("ch.rgw.docmgr-lucinda.showInbox", true);
        }
        this.makeActions();
        this.controller.createView(parent);
        this.contributeToActionBars();
        String colWidths = this.load("ch.rgw.docmgr-lucinda.columnWidths");
        this.controller.setColumnWidths(colWidths);
        GlobalEventDispatcher.addActivationListener((IActivationListener)this, (IWorkbenchPart)this);
        this.visible(true);
    }

    public void visible(boolean mode) {
        this.controller.reload();
        if (!mode) {
            this.save("ch.rgw.docmgr-lucinda.columnWidths", this.controller.getColumnWidths());
        }
    }

    public void setFocus() {
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        IToolBarManager toolbar = bars.getToolBarManager();
        if (CoreHub.localCfg.get("ch.rgw.docmgr-lucinda.commonDir", false)) {
            toolbar.add((IAction)this.showDirectoryAction);
            toolbar.add((IContributionItem)new Separator());
        }
        toolbar.add((IAction)this.filterCurrentPatAction);
        toolbar.add((IAction)this.showInboxAction);
        for (IDocumentHandler dh : this.addons) {
            IAction menuAction;
            IAction toolbarAction = dh.getFilterAction(this.controller);
            if (toolbarAction != null) {
                toolbar.add(toolbarAction);
                this.addonActions.add(toolbarAction);
            }
            if ((menuAction = dh.getSyncAction(this.controller)) == null) continue;
            menu.add(menuAction);
        }
        menu.add((IAction)this.rescanAction);
        if (this.aquireActions.length == 1) {
            toolbar.add((IContributionItem)new Separator());
            toolbar.add((IAction)this.aquireActions[0]);
        } else if (this.aquireActions.length > 1) {
            MenuManager popup = new MenuManager("Scanner");
            int i = 0;
            while (i < this.aquireActions.length) {
                popup.add((IAction)this.aquireActions[i]);
                ++i;
            }
            menu.add((IContributionItem)popup);
        }
    }

    public void createViewerContextMenu(StructuredViewer viewer, final List<IContributionItem> contributionItems) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GlobalView.this.fillContextMenu(manager, contributionItems);
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void fillContextMenu(IMenuManager manager, List<IContributionItem> contributionItems) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        for (IContributionItem contributionItem : contributionItems) {
            ActionContributionItem ac;
            if (contributionItem == null) {
                manager.add((IContributionItem)new Separator());
                continue;
            }
            if (contributionItem instanceof ActionContributionItem && (ac = (ActionContributionItem)contributionItem).getAction() instanceof RestrictedAction) {
                ((RestrictedAction)ac.getAction()).reflectRight();
            }
            contributionItem.update();
            manager.add(contributionItem);
        }
    }

    private void makeActions() {
        this.showDirectoryAction = new Action(Messages.GlobalView_Directory, 2){
            {
                this.setToolTipText(Messages.GlobalView_CommonDirectory);
                this.setImageDescriptor(Images.IMG_FOLDER.getImageDescriptor());
            }

            public void run() {
                boolean off = !this.isChecked();
                GlobalView.this.rescanAction.setEnabled(off);
                GlobalView.this.filterCurrentPatAction.setEnabled(off);
                GlobalView.this.showInboxAction.setEnabled(off);
                for (IAction ac : GlobalView.this.addonActions) {
                    ac.setEnabled(off);
                }
                if (this.isChecked()) {
                    GlobalView.this.controller.setDirView();
                } else {
                    GlobalView.this.controller.setLucindaView();
                }
                GlobalView.this.save("ch.rgw.docmgr-lucinda.useCommonDir", this.isChecked());
            }
        };
        this.showDirectoryAction.setChecked(this.is("ch.rgw.docmgr-lucinda.useCommonDir"));
        this.rescanAction = new Action(Messages.GlobalView_Rescan){
            {
                this.setToolTipText(Messages.GlobalView_Rescan_Tooltip);
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                GlobalView.this.controller.doRescan();
            }
        };
        this.filterCurrentPatAction = new Action(Messages.GlobalView_actPatient_name, 2){
            {
                this.setToolTipText(Messages.GlobalView_actPatient_tooltip);
                this.setImageDescriptor(Images.IMG_PERSON.getImageDescriptor());
            }

            public void run() {
                GlobalView.this.controller.restrictToCurrentPatient(this.isChecked());
                GlobalView.this.save("ch.rgw.docmgr-lucinda.restrictToCurrentPatient", this.isChecked());
            }
        };
        this.filterCurrentPatAction.setChecked(this.is("ch.rgw.docmgr-lucinda.restrictToCurrentPatient"));
        this.showInboxAction = new Action(Preferences.INBOX_NAME, 2){
            {
                this.setToolTipText(Messages.GlobalView_filterInbox_name);
                this.setImageDescriptor(Images.IMG_DOCUMENT_TEXT.getImageDescriptor());
            }

            public void run() {
                GlobalView.this.controller.toggleDoctypeFilter(this.isChecked(), Preferences.INBOX_NAME);
                GlobalView.this.save("ch.rgw.docmgr-lucinda.showInbox", this.isChecked());
            }
        };
        this.showInboxAction.setChecked(this.is("ch.rgw.docmgr-lucinda.showInbox"));
        String[] aquire = CoreHub.localCfg.get("ch.rgw.docmgr-lucinda.aquire_actions", "").split("\\n");
        this.aquireActions = new Action[aquire.length];
        int i = 0;
        while (i < aquire.length) {
            final String[] line = aquire[i].split(":");
            this.aquireActions[i] = new Action(line[0]){
                {
                    super($anonymous0);
                    this.setToolTipText(Messages.GlobalView_ReadExternal);
                    this.setImageDescriptor(Images.IMG_IMPORT.getImageDescriptor());
                }

                public void run() {
                    GlobalView.this.controller.launchAquireScript(line.length == 2 ? line[1] : line[0], GlobalView.this.getSite().getShell());
                }
            };
            ++i;
        }
    }

    private void save(String name, boolean value) {
        this.save(name, Boolean.toString(value));
    }

    private void save(String name, String value) {
        Preferences.set(name, value);
    }

    private String load(String name) {
        return Preferences.get(name, Messages.GlobalView_11);
    }

    private boolean is(String name) {
        return Boolean.parseBoolean(Preferences.get(name, Boolean.toString(false)));
    }

    public void activation(boolean mode) {
        if (mode) {
            this.controller.changePatient(this.ctx.getActivePatient());
        }
    }
}

