/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.lucinda.view;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.ungrad.StorageController;
import ch.elexis.ungrad.common.ui.MailUI;
import ch.elexis.ungrad.lucinda.Client3;
import ch.elexis.ungrad.lucinda.controller.Controller;
import ch.elexis.ungrad.lucinda.controller.DirectoryLabelProvider;
import ch.elexis.ungrad.lucinda.controller.DocumentComparator;
import ch.elexis.ungrad.lucinda.view.Messages;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Optional;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DirectoryViewPane
extends Composite {
    private static final String PREF_DIRECTORY_DATE_COLUMN_WIDTH = "directoryview.datecolumn.width";
    private static final int DEFAULT_DATE_COLUMN_WIDTH = 80;
    private static final int DEFAULT_NAME_COLUMN_WIDTH = 300;
    private static int COLUMN_DATE = 0;
    private static int COLUMN_NAME = 1;
    private String[] columnTitles = new String[]{Messages.DirectoryViewPane_col_date, Messages.DirectoryViewPane_col_filename};
    private int[] columnWidths = new int[]{80, 300};
    private Table table;
    private TableViewer tv;
    private DirectoryContentProvider dcp = new DirectoryContentProvider();
    private StorageController sc = new StorageController();
    private TableColumn dateColumn;

    public DirectoryViewPane(Composite parent, final Controller controlle) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.tv = new TableViewer((Composite)this, 67584);
        this.table = this.tv.getTable();
        this.createColumns();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tv.setLabelProvider((IBaseLabelProvider)new DirectoryLabelProvider());
        this.tv.setContentProvider((IContentProvider)this.dcp);
        this.tv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                File selected;
                String pname;
                Program proggie;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty() && (proggie = Program.findProgram((String)FileTool.getExtension((String)(pname = (selected = (File)sel.getFirstElement()).getAbsolutePath())).toLowerCase())) != null) {
                    proggie.execute(pname);
                }
            }
        });
        Menu menu = new Menu((Control)this.table);
        MenuItem mEdit = new MenuItem(menu, 0);
        MenuItem mSend = new MenuItem(menu, 0);
        if (CoreHub.localCfg.get("ch.elexis.ungrad.common/use_ai", false)) {
            new MenuItem(menu, 2);
            MenuItem mSummary = new MenuItem(menu, 0);
            MenuItem mDiagnoses = new MenuItem(menu, 0);
            MenuItem mMedication = new MenuItem(menu, 0);
            mSummary.setText(Messages.DirectoryViewPane_menu_ai_summary);
            mDiagnoses.setText(Messages.DirectoryViewPane_menu_ai_diagnoses);
            mMedication.setText(Messages.DirectoryViewPane_menu_ai_medication);
            mSummary.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection sel = DirectoryViewPane.this.tv.getStructuredSelection();
                    if (!sel.isEmpty()) {
                        File selected = (File)sel.getFirstElement();
                        controlle.askKI(selected, Messages.DirectoryViewPane_ai_prompt_summary, new Client3.INotifier(){

                            @Override
                            public boolean received(String text) {
                                SWTHelper.showInfo((String)Messages.DirectoryViewPane_ai_answer, (String)text);
                                return true;
                            }
                        });
                    }
                }
            });
            mDiagnoses.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection sel = DirectoryViewPane.this.tv.getStructuredSelection();
                    if (!sel.isEmpty()) {
                        File selected = (File)sel.getFirstElement();
                        controlle.askKI(selected, Messages.DirectoryViewPane_ai_prompt_diagnoses, new Client3.INotifier(){

                            @Override
                            public boolean received(String text) {
                                SWTHelper.showInfo((String)Messages.DirectoryViewPane_ai_answer, (String)text);
                                return true;
                            }
                        });
                    }
                }
            });
            mMedication.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection sel = DirectoryViewPane.this.tv.getStructuredSelection();
                    if (!sel.isEmpty()) {
                        File selected = (File)sel.getFirstElement();
                        controlle.askKI(selected, Messages.DirectoryViewPane_ai_prompt_medication, new Client3.INotifier(){

                            @Override
                            public boolean received(String text) {
                                SWTHelper.showInfo((String)Messages.DirectoryViewPane_ai_answer, (String)text);
                                return true;
                            }
                        });
                    }
                }
            });
        }
        new MenuItem(menu, 2);
        MenuItem mDelete = new MenuItem(menu, 0);
        mEdit.setText(Messages.DirectoryViewPane_menu_rename);
        mSend.setText(Messages.DirectoryViewPane_menu_send);
        mDelete.setText(Messages.DirectoryViewPane_menu_delete);
        this.table.setMenu(menu);
        mEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = DirectoryViewPane.this.tv.getStructuredSelection();
                if (!sel.isEmpty()) {
                    File selected = (File)sel.getFirstElement();
                    InputDialog id = new InputDialog(DirectoryViewPane.this.getShell(), Messages.DirectoryViewPane_rename_title, Messages.DirectoryViewPane_rename_message, selected.getName(), null);
                    if (id.open() == 0) {
                        File dest = new File(selected.getParent(), id.getValue());
                        selected.renameTo(dest);
                        DirectoryViewPane.this.tv.refresh();
                        DirectoryViewPane.this.tv.setSelection((ISelection)new StructuredSelection((Object)dest));
                    }
                }
            }
        });
        mSend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = DirectoryViewPane.this.tv.getStructuredSelection();
                if (!sel.isEmpty()) {
                    File selected = (File)sel.getFirstElement();
                    String subject = CoreHub.localCfg.get("ch.rgw.docmgr-lucinda.mailsubject", "Dokumente");
                    String body = CoreHub.localCfg.get("ch.rgw.docmgr-lucinda.mailbody", "Bitte beachten Sie den Anhang");
                    MailUI mailer = new MailUI(DirectoryViewPane.this.getShell());
                    mailer.sendMail(subject, body, "", selected.getAbsolutePath());
                }
            }
        });
    }

    public void setPatient(Optional<IPatient> pat) {
        try {
            if (pat.isPresent()) {
                File dir = this.sc.getOutputDirFor(pat.get().getId(), true);
                this.tv.setInput((Object)dir);
            }
        }
        catch (Exception e) {
            ExHandler.handle((Throwable)e);
            SWTHelper.showError((String)Messages.DirectoryViewPane_error_setpatient, (String)e.getMessage());
        }
    }

    private void createColumns() {
        int savedDateWidth = CoreHub.localCfg.get(PREF_DIRECTORY_DATE_COLUMN_WIDTH, 80);
        int i = 0;
        while (i < this.columnTitles.length) {
            TableViewerColumn tvc = new TableViewerColumn(this.tv, 0);
            TableColumn tc = tvc.getColumn();
            tc.setText(this.columnTitles[i]);
            if (i == COLUMN_DATE) {
                this.dateColumn = tc;
                tc.setWidth(savedDateWidth);
                tc.addListener(11, event -> {
                    int newWidth = this.dateColumn.getWidth();
                    CoreHub.localCfg.set(PREF_DIRECTORY_DATE_COLUMN_WIDTH, newWidth);
                    CoreHub.localCfg.flush();
                });
            } else {
                tc.setWidth(this.columnWidths[i]);
            }
            this.addHeaderListener(tc, i);
            ++i;
        }
    }

    private void addHeaderListener(final TableColumn tc, final int index) {
        tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (tc.getData("direction") == null) {
                    tc.setData("direction", (Object)false);
                }
                boolean bDirec = (Boolean)tc.getData("direction") == false;
                DirectoryViewPane.this.tv.setComparator((ViewerComparator)new DocumentComparator(index, bDirec, tc.getText().equals(Messages.Master_col_caption_date)));
                tc.setData("direction", (Object)bDirec);
            }
        });
    }

    private static class DirectoryContentProvider
    implements IStructuredContentProvider {
        File dir;

        private DirectoryContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.dir = (File)newInput;
        }

        public Object[] getElements(Object arg0) {
            if (this.dir == null) {
                return new Object[0];
            }
            return this.dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String ext = FileTool.getExtension((String)name).toLowerCase();
                    return ext.equals("pdf") || ext.equals("jpg") || ext.equals("png") || ext.equals("txt") || ext.equals("odt") || ext.startsWith("doc");
                }
            });
        }
    }
}

