/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.lucinda.controller;

import ch.elexis.core.data.activator.CoreHub;
import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.text.model.Samdas;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.ungrad.AIUtil;
import ch.elexis.ungrad.lucinda.Activator;
import ch.elexis.ungrad.lucinda.Client3;
import ch.elexis.ungrad.lucinda.Lucinda;
import ch.elexis.ungrad.lucinda.Preferences;
import ch.elexis.ungrad.lucinda.controller.ContentProvider;
import ch.elexis.ungrad.lucinda.controller.IProgressController;
import ch.elexis.ungrad.lucinda.controller.LucindaLabelProvider;
import ch.elexis.ungrad.lucinda.controller.Messages;
import ch.elexis.ungrad.lucinda.view.DirectoryViewPane;
import ch.elexis.ungrad.lucinda.view.GlobalViewPane;
import ch.elexis.ungrad.lucinda.view.Master;
import ch.rgw.io.FileTool;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller
implements IProgressController {
    GlobalViewPane lucindaView;
    DirectoryViewPane dirView;
    ContentProvider cnt;
    TableViewer viewer;
    boolean bRestrictCurrentPatient = false;
    Map<Long, Integer> visibleProcesses = new HashMap<Long, Integer>();
    long actMax;
    int div;
    int actValue;
    private Lucinda lucinda;
    private Set<String> allowed_doctypes = new TreeSet<String>();
    private Logger log = LoggerFactory.getLogger(Controller.class);
    Composite envelope;
    StackLayout stack = new StackLayout();
    @Reference
    private IContextService contextService = ContextServiceHolder.get();
    int cPatWidth = 0;

    public Control getTopControl() {
        return this.envelope;
    }

    public Controller() {
        this.lucinda = new Lucinda();
        this.bRestrictCurrentPatient = Boolean.parseBoolean(Preferences.get("ch.rgw.docmgr-lucinda.restrictToCurrentPatient", Boolean.toString(false)));
        this.cnt = new ContentProvider();
    }

    public Composite createView(Composite parent) {
        if (Preferences.cfg.get("ch.rgw.docmgr-lucinda.showConsultation", true)) {
            this.allowed_doctypes.add(Preferences.KONSULTATION_NAME);
        }
        if (Preferences.cfg.get("ch.rgw.docmgr-lucinda.showOmnivore", true)) {
            this.allowed_doctypes.add(Preferences.OMNIVORE_NAME);
        }
        if (Preferences.cfg.get("ch.rgw.docmgr-lucinda.showInbox", true)) {
            this.allowed_doctypes.add(Preferences.INBOX_NAME);
        }
        this.envelope = new Composite(parent, 0);
        this.envelope.setLayout((Layout)this.stack);
        this.lucindaView = new GlobalViewPane(this.envelope, this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Konsultation kons;
                Map doc;
                String doctype;
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty() && Preferences.KONSULTATION_NAME.equals(doctype = (String)(doc = (Map)sel.getFirstElement()).get("lucinda_doctype")) && (kons = Konsultation.load((String)((String)doc.get("id")))).exists()) {
                    ElexisEventDispatcher.fireSelectionEvent((PersistentObject)kons);
                }
            }
        });
        this.dirView = new DirectoryViewPane(this.envelope, this);
        this.stack.topControl = CoreHub.localCfg.get("ch.rgw.docmgr-lucinda.commonDir", false) ? this.dirView : this.lucindaView;
        this.changePatient(this.contextService.getActivePatient());
        return this.envelope;
    }

    public void setDirView() {
        this.stack.topControl = this.dirView;
        this.envelope.layout();
    }

    public void setLucindaView() {
        this.stack.topControl = this.lucindaView;
        this.envelope.layout();
    }

    public IStructuredContentProvider getContentProvider(TableViewer tv) {
        this.viewer = tv;
        return this.cnt;
    }

    public LabelProvider getLabelProvider() {
        return new LucindaLabelProvider();
    }

    public void clear() {
        this.viewer.setInput(new ArrayList());
    }

    public void restrictToCurrentPatient(boolean bRestrict) {
        this.bRestrictCurrentPatient = bRestrict;
        TableColumn tc = this.viewer.getTable().getColumn(Master.COLUMN_NAME);
        if (bRestrict) {
            this.cPatWidth = tc.getWidth();
            tc.setWidth(0);
        } else {
            tc.setWidth(this.cPatWidth > 0 ? this.cPatWidth : 100);
        }
        this.runQuery(this.lucindaView.getSearchField().getText());
    }

    public void reload() {
        this.dirView.setPatient(this.contextService.getActivePatient());
        this.runQuery(this.lucindaView.getSearchField().getText());
    }

    public void doRescan() {
        this.lucinda.rescan();
    }

    public void runQuery(String input) {
        try {
            Map result = this.lucinda.query(this.buildQuery(input));
            String status = (String)result.get("status");
            if ("ok".equals(status)) {
                final List queryResult = (List)result.get("result");
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Controller.this.viewer.setInput((Object)queryResult);
                    }
                });
            } else {
                Activator.getDefault().addMessage(result);
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
        }
    }

    protected String buildQuery(String input) {
        Optional oPat;
        StringBuilder q = new StringBuilder();
        if (this.bRestrictCurrentPatient && (oPat = this.contextService.getActivePatient()).isPresent()) {
            IPatient pat = (IPatient)oPat.get();
            q.append("+concern:").append(pat.getLastName().replaceAll(" ", "_")).append("_").append(pat.getFirstName().replaceAll(" ", "_")).append("_").append(new TimeTool(pat.getDateOfBirth()).toString(4));
        }
        if (this.allowed_doctypes.isEmpty()) {
            q.append(" -lucinda_doctype:*");
        } else {
            q.append(" +(");
            for (String doctype : this.allowed_doctypes) {
                q.append(" lucinda_doctype:").append(doctype);
            }
            q.append(")");
        }
        if (StringTool.isNothing((Object)input) || input.equals("*") || input.equals("*:*")) {
            q.append(" contents:*");
        } else if (input.contains(":")) {
            q.append("+").append(input);
        } else {
            q.append("+").append("contents:(").append(input).append(")");
        }
        this.log.info(q.toString());
        return q.toString();
    }

    public void loadDocument(Map doc) {
        String doctype = (String)doc.get("lucinda_doctype");
        if (Preferences.INBOX_NAME.equalsIgnoreCase(doctype)) {
            String docbase = Preferences.cfg.get("ch.rgw.docmgr-lucinda.document_store", "");
            this.loadFile(docbase, doc);
        } else if (doctype.equalsIgnoreCase(Preferences.KONSULTATION_NAME)) {
            Konsultation kons = Konsultation.load((String)((String)doc.get("id")));
            if (kons.exists()) {
                String entry = kons.getEintrag().getHead();
                if (entry.startsWith("<")) {
                    Samdas samdas = new Samdas(entry);
                    entry = samdas.getRecordText();
                }
                Fall fall = kons.getFall();
                Patient pat = fall.getPatient();
                this.contextService.setTyped((Object)pat);
                this.contextService.setTyped((Object)fall);
                this.contextService.setTyped((Object)kons);
            } else {
                SWTHelper.showError((String)Messages.Controller_cons_not_found_caption, (String)MessageFormat.format(Messages.Controller_cons_not_found_text, doc.get("title")));
            }
        } else {
            SWTHelper.showError((String)Messages.Controller_unknown_type_caption, (String)MessageFormat.format(Messages.Controller_unknown_type_text, doctype));
        }
    }

    private void loadFile(String docbase, Map<String, Object> doc) {
        String loc = (String)doc.get("loc");
        if (loc.contains(":/") || StringTool.isNothing((Object)docbase)) {
            try {
                Map result = this.lucinda.get((String)doc.get("id"));
                if (!result.get("status").equals("ok")) {
                    throw new Exception("Could not fetch file contents " + String.valueOf(result.get("message")));
                }
                byte[] contents = (byte[])result.get("result");
                String ext = FileTool.getExtension((String)loc);
                File temp = File.createTempFile("lucinda_", "." + ext);
                temp.deleteOnExit();
                FileTool.writeFile((File)temp, (byte[])contents);
                this.asyncRunViewer(temp.getAbsolutePath());
            }
            catch (Exception ex) {
                ExHandler.handle((Throwable)ex);
                SWTHelper.showError((String)Messages.Controller_could_not_launch_file, (String)ex.getMessage());
            }
        } else if (!loc.startsWith("/") && !loc.contains(":\\")) {
            if (!((String)docbase).endsWith(File.separator)) {
                docbase = (String)docbase + File.separator;
            }
            this.asyncRunViewer((String)docbase + loc);
        } else {
            this.asyncRunViewer(loc);
        }
    }

    private void asyncRunViewer(final String filepath) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String ext = FileTool.getExtension((String)filepath);
                    Program proggie = Program.findProgram((String)ext);
                    if (proggie != null) {
                        proggie.execute(filepath);
                    } else if (!Program.launch((String)filepath)) {
                        Runtime.getRuntime().exec(filepath);
                    }
                }
                catch (Exception ex) {
                    ExHandler.handle((Throwable)ex);
                    SWTHelper.showError((String)Messages.Controller_could_not_launch_file, (String)ex.getMessage());
                }
            }
        });
    }

    public void launchAquireScript(String command, Shell shell) {
        try {
            Optional oPat = this.contextService.getActivePatient();
            if (oPat.isEmpty()) {
                throw new Exception("No patient selected");
            }
            IPatient pat = (IPatient)oPat.get();
            String[] name = pat.getLastName().split("[ -]+");
            String[] fname = pat.getFirstName().split("[ -]+");
            TimeTool bdate = new TimeTool(pat.getDateOfBirth());
            StringBuilder sbConcern = new StringBuilder();
            String bdatec = bdate.toString(9);
            sbConcern.append(name[0]).append("_").append(fname[0]).append("_").append(bdatec.substring(6, 8)).append(".").append(bdatec.substring(4, 6)).append(".").append(bdatec.substring(0, 4));
            InputDialog id = new InputDialog(shell, "Document title", "Please enter a title for the document", "", null);
            if (id.open() == 0) {
                String title = id.getValue().replaceAll("[\\/\\:\\-\\?\\+\\*<>, ]", "_");
                new ScanJob(command, sbConcern.toString(), title).schedule();
            }
        }
        catch (Exception ex) {
            ExHandler.handle((Throwable)ex);
            SWTHelper.showError((String)"Could not launch script", (String)ex.getMessage());
        }
    }

    @Override
    public Long initProgress(int maximum) {
        Long proc = System.currentTimeMillis() + new Random().nextLong();
        this.visibleProcesses.put(proc, maximum);
        long val = 0L;
        for (Integer k : this.visibleProcesses.values()) {
            val += (long)k.intValue();
        }
        if (val < Integer.MAX_VALUE) {
            this.div = 1;
        }
        int amount = (int)(val / (long)this.div);
        this.lucindaView.initProgress(amount);
        return proc;
    }

    @Override
    public void addProgress(Long handle, int amount) {
        Integer val = this.visibleProcesses.get(handle);
        if ((val = Integer.valueOf(val - amount)) <= 0) {
            this.visibleProcesses.remove(handle);
            amount += val.intValue();
            if (this.visibleProcesses.isEmpty()) {
                this.lucindaView.finishProgress();
                this.actValue = 0;
            }
        } else {
            this.visibleProcesses.put(handle, val);
            this.actValue += amount;
            this.lucindaView.showProgress(this.actValue / this.div);
        }
    }

    public void toggleDoctypeFilter(boolean bOn, String doctype) {
        if (bOn) {
            this.allowed_doctypes.add(doctype);
        } else {
            this.allowed_doctypes.remove(doctype);
        }
        this.reload();
    }

    public void changePatient(Optional<IPatient> object) {
        if (this.bRestrictCurrentPatient) {
            Text text = this.lucindaView.getSearchField();
            String q = text.getText();
            this.runQuery(q);
        }
        this.dirView.setPatient(object);
    }

    public void setColumnWidths(String widths) {
        TableColumn[] tcs = this.viewer.getTable().getColumns();
        String[] cw = widths.split(",");
        if (cw.length == tcs.length) {
            int i = 0;
            while (i < cw.length) {
                try {
                    int w = Integer.parseInt(cw[i]);
                    tcs[i].setWidth(w);
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
    }

    public String getColumnWidths() {
        TableColumn[] tcs = this.viewer.getTable().getColumns();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tcs.length) {
            sb.append(Integer.toString(tcs[i].getWidth())).append(",");
            ++i;
        }
        return sb.substring(0, sb.length() - 1);
    }

    public void addSummary(File file) {
    }

    public void askKI(File file, final String prompt, final Client3.INotifier notifier) {
        Job job = Job.create((String)"KI Analyze", monitor -> {
            try {
                Client3 client = new Client3();
                client.analyzeFile(FileTool.readFile((File)file), new Client3.INotifier(){
                    StringBuilder sb = new StringBuilder();

                    @Override
                    public boolean received(String text) {
                        if (!StringTool.isNothing((Object)text) && text.length() > 3) {
                            this.sb.append(text);
                        } else {
                            try {
                                String model = "gemma3:12b";
                                String response = AIUtil.sendPrompt((String)model, (String)(prompt + this.sb.toString()));
                                notifier.received(response);
                            }
                            catch (Exception e) {
                                ExHandler.handle((Throwable)e);
                            }
                        }
                        return false;
                    }
                });
            }
            catch (Exception ex) {
                SWTHelper.showError((String)"Fehler bei KI Aufruf", (String)ex.getMessage());
            }
        });
        job.schedule();
    }

    class ScanJob
    extends Job {
        String command;
        String concern;
        String title;

        public ScanJob(String command, String concern, String title) {
            super("Acquire document");
            this.command = command;
            this.concern = concern;
            this.title = title;
        }

        protected IStatus run(IProgressMonitor arg0) {
            try {
                Process proc = Runtime.getRuntime().exec(new String[]{this.command, this.concern, this.title});
                int result = proc.waitFor();
                if (result != 0) {
                    Controller.this.log.error("could not launch aquire script");
                    return new Status(4, "Acquire", "Could not execute");
                }
                return Status.OK_STATUS;
            }
            catch (Exception ex) {
                return new Status(4, "Acquire", ex.getMessage());
            }
        }
    }
}

