/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.docmgr.lucinda.kons;

import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.elexis.ungrad.lucinda.Activator;
import ch.elexis.ungrad.lucinda.Preferences;
import ch.elexis.ungrad.lucinda.controller.IProgressController;
import ch.elexis.ungrad.lucinda.model.Customer;
import ch.elexis.ungrad.lucinda.model.Sender;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.VersionedResource;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.PlatformUI;

public class ConsultationIndexer
implements Customer {
    static final String TABLENAME = "BEHANDLUNGEN";
    private boolean cont = false;
    private IProgressController pc;
    Long progressHandle;
    private long lastCheck;

    public void setActive(boolean bActive) {
        this.cont = bActive;
    }

    public void start(IProgressController pc) {
        this.pc = pc;
        try {
            this.lastCheck = Long.parseLong(Preferences.get((String)"ch.rgw.docmgr-lucinda.konsLast", (String)"0"));
        }
        catch (NumberFormatException numberFormatException) {
            this.lastCheck = 0L;
        }
        StringBuilder querySQL = new StringBuilder("SELECT ID FROM ").append(TABLENAME).append(" WHERE lastupdate >=").append(this.lastCheck).append(" AND deleted='0' ORDER BY ").append("lastupdate");
        Query qbe = new Query(Konsultation.class);
        Collection konsen = qbe.queryExpression(querySQL.toString(), new LinkedList());
        this.progressHandle = pc.initProgress(konsen.size());
        this.setActive(true);
        PlatformUI.getWorkbench().getProgressService();
        Sender sender = new Sender((Customer)this, (List)konsen, false);
        sender.schedule();
    }

    public Map<String, Object> specify(PersistentObject po) {
        Konsultation kons = (Konsultation)po;
        long lastDisplayUpdate = System.currentTimeMillis();
        int numOfUpdates = 0;
        if (this.cont) {
            HashMap<String, Object> meta = new HashMap<String, Object>();
            Fall fall = kons.getFall();
            Patient patient = fall.getPatient();
            String bdRaw = this.get((PersistentObject)patient, "Geburtsdatum");
            String lastname = this.get((PersistentObject)patient, "Name");
            String firstname = this.get((PersistentObject)patient, "Vorname");
            String birthdate = new TimeTool(bdRaw).toString(9);
            String konsdate = new TimeTool(kons.getDatum()).toString(6);
            StringBuilder concern = new StringBuilder().append(lastname).append("_").append(firstname).append("_").append(birthdate.substring(6)).append(".").append(birthdate.substring(4, 6)).append(".").append(birthdate.substring(0, 4));
            try {
                VersionedResource vr = kons.getEintrag();
                String text = "<empty>";
                if (vr != null && vr.getHead() != null) {
                    text = vr.getHead();
                }
                meta.put("lastname", lastname);
                meta.put("firstname", firstname);
                meta.put("birthdate", birthdate);
                meta.put("date", konsdate);
                meta.put("author", kons.getAuthor() == null ? "?" : kons.getAuthor());
                meta.put("fall", this.get((PersistentObject)kons, "FallID"));
                meta.put("mandant", this.get((PersistentObject)kons, "MandantID"));
                meta.put("label", kons.getVerboseLabel());
                meta.put("rechnung", this.get((PersistentObject)kons, "RechnungsID"));
                meta.put("concern", concern.toString());
                meta.put("payload", text.getBytes("utf-8"));
                meta.put("title", kons.getLabel());
                meta.put("type", Preferences.KONSULTATION_NAME);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                ExHandler.handle((Throwable)e);
            }
            if (kons.getLastUpdate() > this.lastCheck) {
                this.lastCheck = kons.getLastUpdate();
                Preferences.set((String)"ch.rgw.docmgr-lucinda.konsLast", (String)Long.toString(this.lastCheck));
            }
            if (System.currentTimeMillis() - 1000L > lastDisplayUpdate) {
                this.pc.addProgress(this.progressHandle, numOfUpdates);
                numOfUpdates = 0;
                lastDisplayUpdate = System.currentTimeMillis();
            } else {
                ++numOfUpdates;
            }
            return meta;
        }
        this.pc.addProgress(this.progressHandle, Integer.MAX_VALUE);
        return null;
    }

    private String get(PersistentObject po, String field) {
        String ret = po.get(field);
        if (ret == null) {
            return "";
        }
        return ret;
    }

    public void finished(List<Map<String, Object>> messages) {
        Activator.getDefault().addMessages(messages);
        Preferences.cfg.flush();
    }

    public void success(String id) {
    }
}

