/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.ungrad.common.ui;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.rechnung.Messages;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Patient;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Money;
import ch.rgw.tools.Tree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class VerrDetailDialog
extends TitleAreaDialog {
    Patient pat;
    Tree tree;
    Hashtable<Fall, List<Konsultation>> faelle;

    public VerrDetailDialog(Shell shell, Tree subTree) {
        super(shell);
        Object o = subTree.contents;
        this.tree = subTree;
        if (o instanceof Patient) {
            this.pat = (Patient)o;
        } else if (o instanceof Fall) {
            this.pat = ((Fall)o).getPatient();
            this.tree = subTree.getParent();
        } else if (o instanceof Konsultation) {
            Fall fall = ((Konsultation)o).getFall();
            this.pat = fall.getPatient();
            this.tree = subTree.getParent().getParent();
        }
        this.faelle = new Hashtable();
        for (Object of : this.tree.getChildren()) {
            Tree tFall = (Tree)of;
            Fall fall = (Fall)tFall.contents;
            Collection c = tFall.getChildren();
            LinkedList<Konsultation> lKons = new LinkedList<Konsultation>();
            for (Tree tKons : c) {
                lKons.add((Konsultation)tKons.contents);
            }
            this.faelle.put(fall, lKons);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayoutData((Object)SWTHelper.getFillGridData((int)1, (boolean)true, (int)1, (boolean)true));
        ret.setLayout((Layout)new FillLayout());
        TreeViewer tv = new TreeViewer(ret, 512);
        tv.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                Object[] ret = ((Tree)parentElement).getChildren().toArray(new Tree[0]);
                Arrays.sort(ret, new Comparator<Tree>(){

                    @Override
                    public int compare(Tree t1, Tree t2) {
                        if (t1.contents instanceof Konsultation) {
                            Konsultation k1 = (Konsultation)t1.contents;
                            return k1.compareTo((Konsultation)t2.contents);
                        }
                        return 0;
                    }
                });
                return ret;
            }

            public Object getParent(Object element) {
                return ((Tree)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((Tree)element).hasChildren();
            }

            public Object[] getElements(Object inputElement) {
                Object[] ret = VerrDetailDialog.this.tree.getChildren().toArray(new Tree[0]);
                return ret;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        tv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Object o = ((Tree)element).contents;
                if (o instanceof Fall) {
                    Fall f = (Fall)o;
                    Money sum = new Money();
                    List<Konsultation> list = VerrDetailDialog.this.faelle.get(f);
                    if (list != null) {
                        for (Konsultation k : list) {
                            sum.addMoney(VerrDetailDialog.this.calcKons(k));
                        }
                    }
                    return f.getLabel() + " - " + sum.getAmountAsString();
                }
                if (o instanceof Konsultation) {
                    Konsultation k = (Konsultation)o;
                    return k.getLabel() + " - " + VerrDetailDialog.this.calcKons(k).getAmountAsString();
                }
                return super.getText(element);
            }
        });
        tv.setInput((Object)this);
        return ret;
    }

    private Money calcKons(Konsultation k) {
        IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).get();
        Money ret = new Money();
        for (IBilled v : encounter.getBilled()) {
            ret.addMoney(v.getTotal());
        }
        return ret;
    }

    public void create() {
        super.create();
        if (this.pat != null) {
            this.setTitle(this.pat.getLabel());
        } else {
            this.setTitle(Messages.Core_No_patient_selected);
        }
        this.setMessage(Messages.VerrDetailDialog_detailsOfOpenKons);
        this.getShell().setText(Messages.VerrDetailDialog_billingData);
    }

    protected boolean isResizable() {
        return true;
    }
}

